/* GLOBAL.H - RSAREF types and constants
 */

/* Modified Mon Dec 07 13:32:24 1992 by jgs to use gated conventions.  That
 * is, we now look for USE_PROTOTYPES instead of just PROTOTYPES.  
 * USE_PROTOTYPES gets defined in config.h.
 */

/* PROTOTYPES should be set to one if and only if the compiler supports
     function argument prototyping.
   The following makes PROTOTYPES default to 0 if it has not already
     been defined with C compiler flags.
 */

/* POINTER defines a generic pointer type */
typedef unsigned char *POINTER;

/* UINT2 defines a two byte word */
typedef unsigned short int UINT2;

/* UINT4 defines a four byte word */
typedef unsigned long int UINT4;

/* PROTO_LIST is defined depending on how USE_PROTOTYPES is defined above.
   If using PROTOTYPES, then PROTO_LIST returns the list, otherwise it
     returns an empty list.
 */

/*#ifdef USE_PROTOTYPES 
 * #define PROTO_LIST(list) list
 * #else 
 */
#define PROTO_LIST(list) ()
/* #endif  */
