#ifndef _ISO_SUPPORT_H
#define _ISO_SUPPORT_H

#ifndef AF_ISO
#define AF_ISO AF_NBS
#define PF_ISO PF_NBS
#endif


#ifndef IPPROTO_IDRP
#define IPPROTO_IDRP 45
#endif /* IPPROTO_IDRP */

#ifndef  ISOPROTO_IDRP
#define  ISOPROTO_IDRP  36
#endif /* ISOPROTO_IDRP */


struct iso_addr {
	u_char  isoa_len;               /* length (in bytes) */
	char    isoa_genaddr[20];       /* general opaque address */
};

/* used in the file idrp_sock.c */ 
struct sockaddr_iso {
        u_char                  siso_len;       /* length */
        u_char                  siso_family;    /* family */
        u_char                  siso_plen;      /* presentation selector length */
        u_char                  siso_slen;      /* session selector length */
        u_char                  siso_tlen;      /* transport selector length */
        struct  iso_addr        siso_addr;      /* network address */
        u_char                  siso_pad[6];    /* space for gosip v2 sels */
 
        /* makes struct 32 bytes long */
};


/*
 *      Fixed part of clnp header
 */
struct clnp_fixed {
        u_char  cnf_proto_id;   /* network layer protocol identifier */
        u_char  cnf_hdr_len;    /* length indicator (octets) */
        u_char  cnf_vers;       /* version/protocol identifier extension */
        u_char  cnf_ttl;        /* lifetime (500 milliseconds) */
        u_char  cnf_type;       /* type code */
                                /* Includes err_ok, more_segs, and seg_ok */
        u_char  cnf_seglen_msb; /* pdu segment length (octets) high byte */
        u_char  cnf_seglen_lsb; /* pdu segment length (octets) low byte */
        u_char  cnf_cksum_msb;  /* checksum high byte */
        u_char  cnf_cksum_lsb;  /* checksum low byte */
};

/* adding in definitions from iso_var.h  from BSDI */

/* adding in definitions form /usr/include/net/if.h */

/*
 *	Interface address, iso version. One of these structures is 
 *	allocated for each interface with an osi address. The ifaddr
 *	structure conatins the protocol-independent part
 *	of the structure, and is assumed to be first.
 */

#define	IFNAMSIZ 16

struct ifaddr_iso {
        struct  sockaddr ifa_addr;      /* address of interface */
        union {
                struct  sockaddr ifu_broadaddr;
                struct  sockaddr ifu_dstaddr;
        } ifa_ifu;
        struct  ifnet_iso *ifa_ifp;         /* back-pointer to interface */
        struct  ifaddr_iso *ifa_next;       /* next address for interface */
};


struct ifnet_iso {
	char	*if_name;		/* name, e.g. ``en'' or ``lo'' */
	short	if_unit;		/* sub-unit for lower level driver */
	short	if_mtu;			/* maximum transmission unit */
	short	if_flags;		/* up/down, broadcast, etc. */
	short	if_timer;		/* time 'til if_watchdog called */
	u_short	if_promisc;		/* net # of requests for promisc mode */
	int	if_metric;		/* routing metric (external only) */
	struct	ifaddr *if_addrlist;	/* linked list of addresses per if */
	struct	ifqueue_iso {
		struct	mbuf *ifq_head;
		struct	mbuf *ifq_tail;
		int	ifq_len;
		int	ifq_maxlen;
		int	ifq_drops;
	} if_snd;			/* output queue */
/* procedure handles */
	int	(*if_init)();		/* init routine */
	int	(*if_output)();		/* output routine */
	int	(*if_ioctl)();		/* ioctl routine */
	int	(*if_reset)();		/* bus reset routine */
	int	(*if_watchdog)();	/* timer routine */
/* generic interface statistics */
	int	if_ipackets;		/* packets received on interface */
	int	if_ierrors;		/* input errors on interface */
	int	if_opackets;		/* packets sent on interface */
	int	if_oerrors;		/* output errors on interface */
	int	if_collisions;		/* collisions on csma interfaces */
/* end statistics */
	struct	ifnet_iso *if_next;
	struct	ifnet_iso *if_upper;	/* next layer up */
	struct	ifnet_iso *if_lower;	/* next layer down */
	int	(*if_input)();		/* input routine */
	int	(*if_ctlin)();		/* control input routine */
	int	(*if_ctlout)();		/* control output routine */
#ifdef sun
        struct map *if_memmap;          /* rmap for interface specific memory */
#endif
};




/*
 * Structure used in SIOCGIFCONF request.
 * Used to retrieve interface configuration
 * for machine (useful for programs which
 * must know all networks accessible).
 */
struct	ifconf_iso {
	int	ifc_len;		/* size of associated buffer */
	union {
		caddr_t	ifcu_buf;
		struct	ifreq *ifcu_req;
	} ifc_ifcu;
};


struct iso_ifaddr {
	struct ifaddr_iso	ia_ifa;		/* protocol-independent info */
	int					ia_snpaoffset;
	struct iso_ifaddr	*ia_next;	/* next in list of iso addresses */
	struct	sockaddr_iso ia_addr;	/* reserve space for interface name */
	struct	sockaddr_iso ia_dstaddr; /* reserve space for broadcast addr */
	struct	sockaddr_iso ia_sockmask; /* reserve space for general netmask */
};


struct	iso_aliasreq {
	char	ifra_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	sockaddr_iso ifra_addr;
	struct	sockaddr_iso ifra_dstaddr;
	struct	sockaddr_iso ifra_mask;
	int	ifra_snpaoffset;
};

struct	iso_ifreq {
	char	ifr_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	sockaddr_iso ifr_Addr;
};

/*
 *	Given a pointer to an iso_ifaddr (ifaddr),
 *	return a pointer to the addr as a sockaddr_iso
 */

#define	IA_SIS(ia) ((struct sockaddr_iso *)(ia.ia_ifa->ifa_addr))

 /*
 *defines for IOCTLS
 * 
 * define	IA_SIS(ia) (&(((struct iso_ifaddr *)ia)->ia_addr))
 * define	SIOCDIFADDR_ISO	_IOW('i',25, struct iso_ifreq)	   - delete IF addr 
 * define	SIOCAIFADDR_ISO	_IOW('i',26, struct iso_aliasreq)  - add/chg IFalias
 * define	SIOCGIFADDR_ISO	_IOWR('i',33, struct iso_ifreq)	   -  get ifnet address 
 * define	SIOCGIFDSTADDR_ISO _IOWR('i',34, struct iso_ifreq) -  get dst address 
 * define	SIOCGIFNETMASK_ISO _IOWR('i',37, struct iso_ifreq) - get dst address 
 */

 /*
 * This stuff should go in if.h or if_llc.h or someplace else,
 * but for now . . .
 */

struct llc_etherhdr {
	char dst[6];
	char src[6];
	char len[2];
	char llc_dsap;
	char llc_ssap;
	char llc_ui_byte;
};

struct snpa_hdr {
	struct	ifnet_iso *snh_ifp;
	char	snh_dhost[6];
	char	snh_shost[6];
	short	snh_flags;
};


#ifdef KERNEL
struct iso_ifaddr	*iso_ifaddr;	/* linked list of iso address ifaces */
struct iso_ifaddr	*iso_localifa();	/* linked list of iso address ifaces */
struct ifqueue 		clnlintrq;		/* clnl packet input queue */
#endif /* KERNEL */


#endif /* _ISO_SUPPORT_H */
