/*
 * iso.h,v 1.14.2.1 1995/01/13 19:19:04 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994 by Cornell University. All rights */
/* reserved. Refer to Particulars and other Copyright notices at the end of this */
/* file. */

#ifndef _ISO_H
#define _ISO_H

#define	ISO_MAXADDRLEN	20
#define	SOCKADDR_ISO_LEN	(sizeof (iso_addr_default->iso) - 1 + ISO_MAXADDRLEN)

extern byte iso_default_prefix[];	/* the all zeros prefix */
extern sockaddr_un *iso_addr_default;	/* same thing as a sockaddr */

extern sockaddr_un *iso_masks[];	/* All possible contiguous masks */
extern byte iso_mask_list[SOCKADDR_ISO_LEN * (ISO_MAXADDRLEN * NBBY + 1)];
#define	iso_mask_default	iso_masks[0]

#define	ISO_LIMIT_MASKLEN	0, (size_t) (ISO_MAXADDRLEN * NBBY)

#define	iso_mask_natural(addr)	iso_masks[(socksize(addr) - (addr->iso.giso_addr - (byte *) addr)) * NBBY]

/* Locate an ISO mask given it's prefix length */
/*
#define        iso_mask_prefix(pfx)    ((pfx < 0 || pfx > (ISO_MAXADDRLEN * NBBY)) ? (sockaddr_un *) 0 : iso_masks[pfx])
*/
#define        iso_mask_prefix(pfx)    (((u_int) (pfx) > (ISO_MAXADDRLEN * NBBY)) ? (sockaddr_un *) 0 : iso_masks[pfx])

#define        iso_prefix_mask(mask) \
	((byte *) (mask) >= iso_mask_list && (byte *) (mask) < iso_mask_list + sizeof iso_mask_list) \
	? (((byte *) (mask) - iso_mask_list) / SOCKADDR_ISO_LEN) \
	: (u_int) -1


struct iso_net_addr {
        u_char  isoa_len;		/* length (in bytes) */
	u_char	isoa_family;
        u_char  isoa_genaddr[20];	/* general opaque address */
};

#define	ISO_ADDR_SIZE 20
#define ISO_NET_FROM_SOCKUN(p_net, p_sock) do { \
	(p_net) = (struct iso_net_addr *) (p_sock); \
	(p_net)->isoa_len -= 2; \
	} while (0)

#define iso_net_addr_cmp(n1, n2) (((n1)->isoa_family == (n2)->isoa_family) \
	&& ((n1)->isoa_len == (n2)->isoa_len) \
	&& (bcmp((n1)->isoa_genaddr, (n2)->isoa_genaddr, (n1)->isoa_len)== 0))

#ifdef RTPROTO_IDRP
#define IDRP_ISO_NET_ALLOC(p_net, net) do { \
	(p_net) = (struct iso_net_addr *) idrp_local_mem_fit(sizeof(*(p_net)));\
	bzero((caddr_t) (p_net), sizeof(struct iso_net_addr)); \
	bcopy((net).isoa_genaddr, (p_net)->isoa_genaddr, (net).isoa_len); \
	(p_net)->isoa_len = (net).isoa_len; \
	(p_net)->isoa_family = AF_ISO; \
	} while (0)
#endif

#define iso_net_copy(from, to) do { \
	bzero((caddr_t) (to), sizeof(struct iso_net_addr)); \
	bcopy((from)->isoa_genaddr, (to)->isoa_genaddr, (from)->isoa_len); \
	(to)->isoa_len = (from)->isoa_len; \
	(to)->isoa_family = AF_ISO; \
	} while (0)

#define	ISO_SOCK_SIZE	22		/* size of sockaddr_un for ISO */	

struct iso_prefix {
	u_char pfx_len;		
	u_char pfx[20];
};


PROTOTYPE(iso_mask_locate,
	  extern sockaddr_un *,
	  (sockaddr_un *));
PROTOTYPE(iso_family_init,
	  extern void,
	  (void));
PROTOTYPE(iso_init,
	  extern void,
	  (void));

/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#endif /* _ISO_H */
