/* 
 * $Id: idrp_timers.c,v 1.3 1996/08/21 03:06:12 sjr Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#include "include.h"
#include "iso.h"
#include "idrp.h"
#include <stdio.h>

PROTOTYPE(start_opensent_timer, static void, (idrpPeer *peer));

/* idrp_timers.c
 *
 *  Timer routines: 
 *   start and stop timers
 *	start_rexmit_timer 
 *	kill_rexmit_timer
 * 	start_keepalive_timer 
 * 	start_opensent_timer
 *      start_echo_timer
 */ 
  
 
/*
 * Start the retransmission timer if it isn't already running.
 */
void 
start_rexmit_timer(peer)
idrpPeer *peer;
{
	if (!peer->rexmit_timer_running) {
		task_timer_set(peer->idrp_retransmit_timer, peer->rexmit_time, (time_t) 0);
		peer->rexmit_timer_running = TRUE;
	}
}

/*
 * Kill the retransmission timer if it isn't needed.
 */
void 
kill_rexmit_timer(peer)
idrpPeer *peer;
{
	if (peer->rexmit_timer_running) {
		if (peer->rexmit_queue_head == NULL && peer->cred_avail_zero_seq_last == 0) {
			task_timer_reset(peer->idrp_retransmit_timer);
			peer->rexmit_timer_running = FALSE;
		}
	}
}

/*
 * Start the keepalive timer. 
 */

void 
start_keepalive_timer(peer)
idrpPeer *peer;
{
	task_timer_set(peer->idrp_keepalive_timer, peer->keepalive_time, (time_t) 0);
}

/*
 * Start the opensent timer
 */
static void 
start_opensent_timer(peer)
idrpPeer *peer;
{
	task_timer_set(peer->idrp_keepalive_timer,peer->opensent_time,(time_t) 0);
}


#ifdef ECHOKLUDGE
/*
 * start echo timer (only if ECHOKLUDGE is def'd)
 */
static void start_echo_timer(peer)
idrpPeer *peer;
{
	task_timer_set(peer->idrp_echo_timer, IDRP_ECHO_TIME, (time_t) 0);
}
#endif /* ECHOKLUDGE */
