/* 
 *  idrp_test_import.h --sjr
 */
#include "include.h"
#include "iso.h"
#include "idrp.h"
#include "inet.h"

#define GOOD_SNPA_ENTRY { (struct _snpa_entry *) NULL, 4, \
	{ 18, 52, 86, 120, 0, 0, 0, 0 } }
snpa_entry good_snpa_entry = GOOD_SNPA_ENTRY;

#define BAD_SNPA_ENTRY { (struct _snpa_entry *) NULL, 5, \
	{ 18, 52, 86, 120, 0, 0, 0, 0 } }
#define BAD_SNPA_ENTRY2 { (struct _snpa_entry *) NULL, 4, \
	{ 19, 52, 86, 120, 0, 0, 0, 0 } }

#define GOOD_SNPA_LIST { 4, 1, GOOD_SNPA_ENTRY }

#define GOOD_SNPA_LIST2 { 9, 2, \
	{  &good_snpa_entry, 5, { 18, 52, 86, 120, 0, 0, 0, 0 }}}
#define BAD_SNPA_LIST { 5, 1, BAD_SNPA_ENTRY }
#define BAD_SNPA_LIST2 { 4, 1, BAD_SNPA_ENTRY2 }

u_char good_addr[20] = { 53, 1, 35, 68, 86, 119, 137, 1, 35, 69, 103, 137, 1, 35, 69, 103, 137, 10, 251, 236}; 
#define GOOD_ADDR  { 73, 1, 35, 68, 86, 119, 137, 1, 35, 69, 103, 137, 1, 35, 69, 103, 137, 10, 251, 236}

#define GOOD_NET {20, AF_ISO, GOOD_ADDR}
/*
#define GOOD_LOCAL_NET {20, AF_ISO, {
local-net 0x47000580ffff000000040000000000232a01b400
*/

#define BAD_NET {6, AF_ISO, {1,2,3,4,5,6,0,0,0,0, 0,0,0,0,0,0,0,0,0,0}}

#define GOOD_NEXT_HOP { {20, AF_ISO, GOOD_ADDR}, (struct _idrp_next_hop *) NULL, 1, GOOD_SNPA_LIST }
#define GOOD_NEXT_HOP2 { GOOD_NET, (struct _idrp_next_hop *) NULL, 1, GOOD_SNPA_LIST2 }
#define BAD_NEXT_HOP_NET { BAD_NET, (struct _idrp_next_hop *) NULL, 1, GOOD_SNPA_LIST }
#define BAD_NEXT_HOP_SNPA { GOOD_NET, (struct _idrp_next_hop *) NULL, 1, BAD_SNPA_LIST }
#define BAD_NEXT_HOP_SNPA2 { GOOD_NET, (struct _idrp_next_hop *) NULL, 1, BAD_SNPA_LIST2 }
#define BAD_NEXT_HOP_BOTH { BAD_NET, (struct _idrp_next_hop *) NULL, 1, BAD_SNPA_LIST }
#define BAD_NEXT_HOP_BOTH2 { BAD_NET, (struct _idrp_next_hop *) NULL, 1, BAD_SNPA_LIST2 }

#define NULL_NET {0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0}
#define NULL_SNPA {0,0,0,0, 0,0,0,0}
#define VOID_NEXT_HOP { {0, 0, NULL_NET}, \
  (struct _idrp_next_hop *) NULL,  0, \
  {0, 0, { (snpa_entry *) NULL, 0, NULL_SNPA }} }

#define good_next_hop  { GOOD_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define good_next_hop2 { GOOD_NEXT_HOP2, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define bad_next_hop_net { BAD_NEXT_HOP_NET, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define bad_next_hop_snpa { BAD_NEXT_HOP_SNPA, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define bad_next_hop_snpa2 { BAD_NEXT_HOP_SNPA2, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define bad_next_hop_both { BAD_NEXT_HOP_BOTH, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }
#define bad_next_hop_both2 { BAD_NEXT_HOP_BOTH2, VOID_NEXT_HOP, VOID_NEXT_HOP, VOID_NEXT_HOP }

#define GOOD_STATUS IDRP_OPTS_EXT_INFO+IDRP_OPTS_MULTI_EXIT+IDRP_OPTS_HIER_REC
#define BAD_RS_STATUS GOOD_STATUS+IDRP_OPTS_ROUTE_SERVER
#define BAD_EXT_INFO_STATUS IDRP_OPTS_MULTI_EXIT+IDRP_OPTS_HIER_REC
#define BAD_HIER_REC_STATUS IDRP_OPTS_EXT_INFO+IDRP_OPTS_MULTI_EXIT
#define BAD_MULTI_EXIT_STATUS IDRP_OPTS_EXT_INFO+IDRP_OPTS_HIER_REC

#define GOOD_MX 25
#define GOOD_MX2 26
#define BAD_MX 24

#define GOOD_GW_ADDR ((((((35 * 256) + 42) * 256UL) + 1) * 256UL) + 42UL)
#define GOOD_IF_ADDR ((((((35 * 256) + 42) * 256UL) + 1) * 256UL) + 75UL)
	
sockaddr_un Good_gw;
sockaddr_un Good_if;
#define good_gw  &Good_gw
#define good_if  &Good_if
#define bad_gw  &Good_if
#define bad_if  &Good_gw
sockaddr_un Good_net;
sockaddr_un Bad_net;
#define good_net_addr &Good_net
#define bad_net_addr &Bad_net

#define GOOD_HOPCOUNT 19
#define BAD_HOPCOUNT 20
#define QNO IDRP_QOS_OP_NO
#define NULL_QOS_OP {QNO, 0}
#define good_capacity {IDRP_QOS_OP_EQ, 3}
#define bad_capacity {IDRP_QOS_OP_EQ, 2}

#define QOS_VALUE (IDRP_ATTBT_TRANSIT_DELAY|IDRP_ATTBT_RESIDUAL_ERROR|IDRP_ATTBT_EXPENSE|IDRP_ATTBT_PRIORITY)

#define NULL_DIST_ATT {-1, NULL, {QNO, NULL}, {QNO, NULL}, {QNO, NULL}, {QNO, NULL}};
#define EQ  IDRP_QOS_OP_EQ
idrp_distinguish_att Good_qos = {
	0, QOS_VALUE, 
	{EQ, 250},
	{EQ, 1599},
	{EQ, 9},
	{EQ, 0}
};
#define good_qos &Good_qos
idrp_distinguish_att Good_qos2 = {
	0, QOS_VALUE, 
	{EQ, 10},
	{EQ, 1599},
	{EQ, 9},
	{EQ, 2}
};
#define good_qos2 &Good_qos2
idrp_distinguish_att Bad_delay_qos = {
	0, QOS_VALUE, 
	{EQ, 251},
	{EQ, 1599},
	{EQ, 9},
	{EQ, 2}
};
#define bad_delay_qos &Bad_delay_qos 
idrp_distinguish_att Bad_error_qos = {
	0, QOS_VALUE, 
	{EQ, 250},
	{EQ, 1600},
	{EQ, 9},
	{EQ, 2}
};
#define bad_error_qos &Bad_error_qos
idrp_distinguish_att Bad_expense_qos = {
	0, QOS_VALUE, 
	{EQ, 10},
	{EQ, 1599},
	{EQ, 11},
	{EQ, 2}
};
#define bad_expense_qos &Bad_expense_qos 
idrp_distinguish_att Bad_priority_qos = {
	0, QOS_VALUE, 
	{EQ, 10},
	{EQ, 1599},
	{EQ, 9},
	{EQ, 1}
};
#define bad_priority_qos &Bad_priority_qos 

/*
  Good values:

                route-server restrict;
                extinfo;
                hierarch-rec;
                multiexit >= 25;

                net  0x49012344567789012345678901234567890afbec;
                snpa  0x12345678;
                gateway 35.42.1.42;
                interface 35.42.1.75;
                hopcount < 20;
                rd-transit-delay <= 250;
                rdlre < 1600;
                expense < 10;
                priority != 1;
                capacity > 2;
*/
#define ROUTE_OPT(status, multi, next_hop, p_gw, p_intf, hopcount, p_qos, cap)	{ \
	0, next_hop, (sockaddr_un *) NULL, p_gw, p_intf, (status), \
	(struct _idrpRoute_options *) NULL, multi, 0, \
	{0,0,0,0,0,0,0,0,0,0}, AF_ISO, cap, 0, hopcount, \
	(idrp_canon_rdpath *) NULL, (idrp_canon_rdpath *) NULL, \
	p_qos, (struct _idrpRoute_options *)	NULL \
	}

/*
typedef struct _idrpRoute_options {
        idrp_next_hop   next_hop[IDRP_NLRI_FAMILIES_SUPPORTED]; 
} idrpRoute_options;
*/

struct _idrp_next_hop next_hops[]= {
	GOOD_NEXT_HOP,
	VOID_NEXT_HOP
};	

/*
struct _idrpRoute_options route_opts[1] = {
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity)
};
*/
struct _idrpRoute_options route_opts[] = {
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(BAD_RS_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(BAD_EXT_INFO_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(BAD_HIER_REC_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(BAD_MULTI_EXIT_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX2, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, BAD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop2, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, bad_next_hop_net, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, bad_next_hop_snpa, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, bad_next_hop_snpa2, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, bad_next_hop_both, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, bad_next_hop_both2, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, bad_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, bad_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, BAD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos2, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, bad_delay_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, bad_error_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, bad_expense_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, bad_priority_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, good_capacity),
ROUTE_OPT(GOOD_STATUS, GOOD_MX, good_next_hop, good_gw, good_if, GOOD_HOPCOUNT, good_qos, bad_capacity),
ROUTE_OPT(0, 0, good_next_hop, ((sockaddr_un *) NULL), ((sockaddr_un *) NULL), 0, good_qos, good_capacity)
};

