/* 
 * $Id: idrp_rt.c,v 1.3 1996/08/17 00:40:24 skh Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#include "include.h"
#include "iso.h"
#include "idrp.h"
#include "inet.h"

/* idrp_rt.c - utilites relating to the routing table
 * 		Generic utilities such as
 * 	sock_supported
 */

int sock_supported(peer,addr)
idrpPeer	*peer;
sockaddr_un	*addr;
{
int	i;

	NLRI_FAMILY_LOOP(i)
		{
		if (socktype(addr) == nlri_family[i].family)
			{
			return(TRUE);
			}
		} NLRI_FAMILY_LOOP_END;	
			
	return(FALSE);
}

sockaddr_un *
idrp_sock_dup(peer,p_sock)
idrpPeer	*peer;
sockaddr_un	*p_sock;
{
sockaddr_un	*p_s;

	/* allocate memory for task 
	 * copy the socket parameters 
	 */

	p_s = (sockaddr_un *) idrp_local_mem_fit(sizeof(struct iso_net_addr));
	p_s->a.ga_len = p_sock->a.ga_len;
	p_s->a.ga_family = p_sock->a.ga_family;
	switch (p_s->a.ga_family)
		{
		case AF_ISO:
			bcopy(&p_sock->iso.giso_addr,&p_s->iso.giso_addr,p_s->a.ga_len);
			break;

		case AF_INET:
			bcopy(&p_sock->in.gin_port,&p_s->in.gin_port,1);
			bcopy(&p_sock->in.gin_addr,&p_s->in.gin_addr,sizeof(struct in_addr));
			break;
		}
	return(p_s);
}	
