/* 
 * $Id: idrp_ps_free.c,v 1.5 1996/08/24 07:21:11 skh Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

/*
 *  idrp_ps_free.c -- sjr
 *
 *  Function for freeing IDRP's ps (process-specific) data.
 */

#include "include.h"
#include "idrp.h"
#include "idrp_policy.h"
#include <stdio.h>

void
idrp_ps_free __PF1(p_adv, adv_entry *)
{
	idrp_ps_t 
		*p_idrp_ps;

	idrp_canon_rdpath 
		*p_rdpath_elem, 
		*p_rdpath; 

	p_idrp_ps = (idrp_ps_t *) (p_adv->adv_ps);
	switch (p_idrp_ps->ps_flag & IDRP_PSFT_TYPE) 
	{
		case (IDRP_PSFT_RIBID):
		case (IDRP_PSFT_EXTINFO):
		case (IDRP_PSFT_ROUTESERV):
		case (IDRP_PSFT_HIERARCH):
			break;

		case (IDRP_PSFT_CAPACITY):
		        if (p_idrp_ps->ps_capacity)
		        	IDRP_MEM_FIT_FREE(p_idrp_ps->ps_capacity);
			break;

		case (IDRP_PSFT_MULTIEXIT):
		        if (p_idrp_ps->ps_multi_exit)
		                IDRP_MEM_FIT_FREE(p_idrp_ps->ps_multi_exit);
			break;

		case (IDRP_PSFT_NEXTHOP_NET):
			IDRP_MEM_FIT_FREE(p_idrp_ps->ps_nexthop_net);
			break;

		case (IDRP_PSFT_NEXTHOP_SNPA):
			idrp_free_snpa_list(p_idrp_ps->ps_nexthop_snpas);
			IDRP_MEM_FIT_FREE(p_idrp_ps->ps_nexthop_snpas);
			break;

		case (IDRP_PSFT_NEXTHOP_IPGW):
			sockfree(p_idrp_ps->ps_gw);
			break;

		case (IDRP_PSFT_NEXTHOP_IPINTF):
		case (IDRP_PSFT_LOCAL_IP_INTF):
			sockfree(p_idrp_ps->ps_intf);
			break;

		case (IDRP_PSFT_HOPCNT):
			if (p_idrp_ps->ps_hopcount)
				IDRP_MEM_FIT_FREE(p_idrp_ps->ps_hopcount);
			break;

		case (IDRP_PSFT_DISTINCL):
			for (p_rdpath_elem = p_idrp_ps->ps_dist_list_incl, p_rdpath = p_rdpath_elem->p_next; 
			     p_rdpath_elem; 
			     p_rdpath_elem = p_rdpath, p_rdpath = ((p_rdpath) ? p_rdpath->p_next : p_rdpath)) {
				IDRP_MEM_FIT_FREE(p_rdpath_elem);
			}
			break;

		case (IDRP_PSFT_DISTEXCL):
			for (p_rdpath_elem = p_idrp_ps->ps_dist_list_excl, p_rdpath = p_rdpath_elem->p_next; 
			     p_rdpath_elem; p_rdpath_elem = p_rdpath, p_rdpath = p_rdpath->p_next) {
				IDRP_MEM_FIT_FREE(p_rdpath_elem);
			}
			break;

		case (IDRP_PSFT_TRANSIT_DELAY):
		case (IDRP_PSFT_RESIDUAL_ERROR):
		case (IDRP_PSFT_EXPENSE):
		case (IDRP_PSFT_PRIORITY):
		case (IDRP_PSFT_SECURITY):
		case (IDRP_PSFT_SECURITY_ID):
		case (IDRP_PSFT_SECURITY_INFO):
			if (p_idrp_ps->ps_qos) {
				IDRP_MEM_FIT_FREE(p_idrp_ps->ps_qos);
			}
			break;

		/* TODO:  change the LOCAL_SNPA when SNPAs are actually used! */
		case (IDRP_PSFT_LOCAL_SNPA):
			IDRP_MEM_FIT_FREE(p_idrp_ps->ps_iso_net_addr);
			break;

		/* This is not used, at this time... */
		case (IDRP_PSFT_DISTATT):
		default:
			assert(FALSE);
	}
	idrp_mem_fit_free(&p_adv->adv_ps, sizeof(idrp_ps_t));
/*
	IDRP_MEM_FIT_FREE(p_idrp_ps);
	p_adv->adv_ps = (VOID_T) NULL;
*/
}
