/* 
 * $Id: idrp_proto_parse.h,v 1.3 1996/07/16 00:10:48 sjr Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#ifndef _idrp_proto_parse_h
#define _idrp_proto_parse_h
/* 
 * idrp_proto_parse.h --SJR
 *
 * For constants used by IDRP in the parsing of the config file.
 * These values are from the Draft Final Text of ISO/IEC 10747, p. 73.
 */

#define LIMIT_IDRP_CAPACITY 1, 255
#define LIMIT_IDRP_EXPENSE  1, 65535
#define LIMIT_IDRP_HOLD_TIME 1, 65535
#define LIMIT_IDRP_MINADV_INTERVAL 1, 65535
#define LIMIT_IDRP_HOPCOUNT 0, 255
#define LIMIT_IDRP_PREFERENCE 0, 255 /* This value is NOT on p. 73. */
#define LIMIT_IDRP_PRIORITY	0, 14
#define LIMIT_IDRP_QOSVAL   1, 255
#define LIMIT_IDRP_RD_TRANSIT_DELAY	0, 65535
#ifdef __STDC__
#define LIMIT_IDRP_RDLRE	0, 4294967295UL
#else
#define LIMIT_IDRP_RDLRE	0, 4294967295L
#endif
#define LIMIT_IDRP_MULTIEXIT 0, 255 /* non-negative, 1-byte */
#endif
