/* 
 * $Id: idrp_out_list.c,v 1.8 1996/08/28 20:33:46 sjr Exp $ 
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#include "include.h"
#include "iso.h"
#include "idrp.h"


/* idrp_out_list.c - 
 * 
 * 1) create_idrp_out_att - create idrp outbound attribute
 * 2) free_out_att - free secondary storage on the attribute
 * 3) idrp_free_out_list - free the outbound list
 * 4) link_out_att - link attribute on the attribute list
 * 5) unlink_out_att - unlink the attribute from the attribute list 	
 */


idrp_attribute_record *
create_idrp_out_att(p_idrp_rt,peer)
idrpRoute	*p_idrp_rt;
idrpPeer	*peer;
{
idrp_attribute_record *p_attr;
idrp_attribute_record *p_att;

/*
 *  copy into a new attribute record -
 *   1) point to existing attribute record
 *      for data fields in normal attribute
 *   2) user attributes
 *   3) transitive attributes
 */


	p_attr = p_idrp_rt->p_attr;
	p_att = (idrp_attribute_record *) idrp_local_mem_fit(sizeof(idrp_attribute_record));
	p_att->peer_alloc = peer;
	p_att->local_mask = IDRP_LOCAL_OUTPUT_ATTR;

	/* 
         * 1) copy over options 
	 * 2) copy over the options 
 	 */

	p_att->p_opts = (idrpRoute_options *) idrp_local_mem_fit(sizeof(idrpRoute_options));
	idrp_copy_opts(p_attr->p_opts,p_att->p_opts,p_attr->rib_id);

	p_att->rib_id = p_attr->rib_id;
	p_att->idrp_mask = p_attr->idrp_mask;
	p_att->p_transitive = p_attr->p_transitive;

	bcopy(&p_attr->attrib[0],&p_att->attrib[0],(sizeof(idrp_attribute_entry)*IDRP_ATTR_NO)); 
	bcopy(&p_attr->usr_attrib[0],&p_att->usr_attrib[0],(sizeof(idrp_attribute_entry)*IDRP_ATTR_NO));
	return(p_att);
}

void
free_out_att(p_att,peer)
idrp_attribute_record	*p_att;
idrpPeer		*peer;
{
	/* free the things listed under the 
	 * local mask for the outboud 
	 * 	
	 */

	if ((p_att->local_mask & IDRP_OATT_MASK) != 0)
		{

		/* multi_exit does not have to be freed
		 * ext-info does not need to be freed
		 */

		if ((p_att->local_mask & IDRP_OATT_NEXT_HOP) != 0)
			{
			/* free the data saved for the PDU
			 */
			idrp_mem_fit_free((void **)&p_att->attrib[IDRP_ATTR_NEXT_HOP].data,p_att->attrib[IDRP_ATTR_NEXT_HOP].length);
			} 

		if (p_att->local_mask & IDRP_OATT_DIST_LIST_NEW)
			{
			/* free the new DISTTRIBUTION memory in
			 * the attribute record 
			 * and the dist_list structure
			*/
			if (peer)
				{				
				/* single peer called during sending routes
				 */

				if (p_att->p_opts->p_DIST_LIST[peer->id])
					{
					free_dist_list(p_att->p_opts->p_DIST_LIST[peer->id]);	
					}
				}
			else
				{

				/* if null - clear all peers during reinit
				 */
				
				idrpPeer *p_peer;

				IDRP_LIST(p_peer,idrp_peers)
					{	
					if (p_att->p_opts->p_DIST_LIST[p_peer->id])
						{
						free_dist_list(p_att->p_opts->p_DIST_LIST[p_peer->id]);	
						}
					} IDRP_LIST_END;
				}

			if (p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].present!= 0)
				{
				idrp_mem_fit_free((void **)&p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].data,p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].length);
				}
			if (p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].present != 0 )
				{
				idrp_mem_fit_free((void **)&p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].data,p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].length);
				}
			
			} 
		if ((p_att->local_mask & IDRP_OATT_DIST_LIST_EXIST) != 0) 
			{
			/* free the new DISTTRIBUTION LIST */
			if (p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].present != 0)
				{
				idrp_mem_fit_free((void **)&p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].data,p_att->attrib[IDRP_ATTR_DIST_LIST_INCL].length);
				}
			if (p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].present != 0 )
				{
				idrp_mem_fit_free((void **)&p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].data,p_att->attrib[IDRP_ATTR_DIST_LIST_EXCL].length);
				}
			}
  
			 
#ifdef	IDRP_RDC
			if (p_att->local_mask &
			 (IDRP_OATT_RDPATH_CONFED | IDRP_OATT_RDPATH_CONFED_POL))
			{
			/* free the new rdpath 
			*/
			}
#endif /* IDRP_RDC */ 
		}  
	
	/* free the idrp_attribute record itself
	 */

	idrp_free_opts(p_att->p_opts);
	IDRP_MEM_FIT_FREE(p_att);

}

void
idrp_free_outann_list(p_out_ann,peer)
idrp_ann_list	*p_out_ann;
idrpPeer	*peer;
{
idrp_ann_list *p_atl = p_out_ann;
idrp_ann_list *p_atl2 = NULL;

        while (p_atl)
                {
                p_atl2 = p_atl;
                p_atl = p_atl->p_next;
		if (p_atl && p_atl->p_attr)
			{
			unlink_out_att(p_atl->p_attr);
			free_out_att(p_atl->p_attr,peer);
			}
                IDRP_MEM_FIT_FREE(p_atl2);
                }
}


void
idrp_free_oatt_list(rib_id,peer)
int		rib_id;
idrpPeer	*peer;
{
idrp_attribute_record *p_att;


	OATT_LIST_NULL(rib_id)
		{
                trace_tf(idrp_trace_options,0,TR_NORMAL,  ("idrp_free_oatt_list null  %x", rib_id));
		}
	else OATT_LIST_EMPTY(rib_id) 
	 	{
		/*
		 * - empty list
		 */
       		trace_tf(idrp_trace_options,0,TR_NORMAL,  ("idrp_free_oatt_list empty rib id %x", rib_id));
	    	}
	else
	   	{		
		OATTR_LIST(p_att,rib_id)	
			{
			unlink_out_att(p_att);
			free_out_att(p_att,peer);
			} OATTR_LIST_END;

		}
}



void
link_out_att(p_att)
idrp_attribute_record *p_att;
{
int	rib_id = p_att->rib_id;

	OATT_LIST_EMPTY(rib_id)
		{
		OATT_LIST_HEAD(rib_id) = OATT_LIST_END(rib_id) = p_att;
		}
	else	
		{
		OATT_LIST_END(rib_id)->next = p_att;
		p_att->prev = OATT_LIST_END(rib_id);
		OATT_LIST_END(rib_id) = p_att;
		}
   
}		

void
unlink_out_att(p_att)
idrp_attribute_record *p_att;
{
int	rib_id = p_att->rib_id;

	/* if the start of the attribute record
	 */
	
	
	if (OATT_LIST_HEAD(rib_id) == p_att)
		{
		OATT_LIST_HEAD(rib_id) = p_att->next;
		if (p_att->next)
			{
			p_att->next->prev = (idrp_attribute_record *) 0;
			}
		else
			{
			assert(OATT_LIST_END(rib_id) == p_att);
			OATT_LIST_END(rib_id) = (idrp_attribute_record *) NULL;
			}
	
		}
	else
		{
		p_att->prev->next = p_att->next;
		if (p_att->next)
			{
			p_att->next->prev = p_att->prev;
			}
		else
			{
			assert(OATT_LIST_END(rib_id) == p_att);
			OATT_LIST_END(rib_id) = p_att->prev;
			}
		}	
	
}

