/* 
 * $Id: idrp_macros.h,v 1.17 1996/08/29 06:31:34 skh Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#ifndef _idrp_macros_h
#define _idrp_macros_h

/* Macros that might turn into gated macros */

#define GENERIC_LIST(x, y) for ((x) = (y); (x); (x) = (x)->next)
#define GENERIC_PLIST(x, y) for ((x) = (y); (x); (x) = (x)->p_next)

#define	RT_PROTO_ALL(p_res_arg, rt_arg, rth_arg, proto_arg)	for ((rt_arg) = (p_res_arg); (((rt_arg) == (rt_entry *) &(rth_arg)->rt_forw)|| (p_rt->rt_gwp->gw_proto != (proto_arg)); (rt_arg) = (rt_arg)->rt_forw)


/* Macros for code */

#define IDRP_LIST(peer_arg, peerlist_arg)  GENERIC_PLIST((peer_arg), (peerlist_arg))
#define IDRP_LIST_END

#define IDRP_INT_PEER(peer_arg) for ((peer_arg) = idrp_peers; (peer_arg) != idrp_ext_peers; (peer_arg) = (peer_arg)->p_next)
#define IDRP_INT_PEER_END

#define IDRP_EXT_PEER(peer_arg) GENERIC_PLIST((peer_arg), idrp_ext_peers)
#define IDRP_EXT_PEER_END

#define PEER_CNT_LOOP(i_arg)	for ((i_arg) = 0; (i_arg) < idrp_neighbors; (i_arg)++)
#define	PEER_CNT_LOOP_END

#define	PEER_CONNECTED(peer_arg) (((peer_arg) != NULL) && ((peer_arg)->idrp_flags & IDRPF_CONNECT) !=0)		

#ifdef IDRP_QOS
#define	ATTR_LIST(att_arg,i_arg)	GENERIC_LIST(att_arg,idrp_attr_list[i_arg])	
#define	ATTR_LIST_END		
#define	ATTR_LIST_EMPTY(i_arg)	if (idrp_attr_list[i_arg] == NULL)
#define	ATTR_LIST_HEAD(i_arg)	idrp_attr_list[i_arg]	

#define	OATTR_LIST(att_arg,i_arg)	GENERIC_LIST(att_arg,idrp_oatt_list[i_arg]->p_start)	
#define	OATTR_LIST_END

#define OATT_LIST_NULL(i_arg)		if (idrp_oatt_list[(i_arg)] == NULL)

#define	OATT_LIST_EMPTY(i_arg)	if (idrp_oatt_list[(i_arg)]->p_start == NULL)
#define	OATT_LIST_HEAD(i_arg)	idrp_oatt_list[(i_arg)]->p_start	
#define	OATT_LIST_END(i_arg)	idrp_oatt_list[(i_arg)]->p_end	

#else
#define ATTR_LIST(att_arg,i_arg)	GENERIC_LIST((att_arg), idrp_attr_list)
#define	ATTR_LIST_END
#define	ATTR_LIST_EMPTY(i_arg)	if (idrp_attr_list == NULL)
#define	ATTR_LIST_HEAD(i_arg)	idrp_attr_list	

#define	OATTR_LIST(att_arg,i_arg)	GENERIC_LIST(att_arg,idrp_oatt_list->p_start)	
#define	OATTR_LIST_END

#define OATT_LIST_NULL(i_arg)		if (idrp_oatt_list == NULL)
#define	OATT_LIST_EMPTY(i_arg)		if (idrp_oatt_list->p_start == NULL)
#define	OATT_LIST_HEAD(i_arg)		idrp_oatt_list->p_start
#define	OATT_LIST_END(i_arg)		idrp_oatt_list->p_end	
#endif



#define ATTR_LIST_END

#define NLRI_FAMILY_LOOP(i_arg) for ((i_arg) = 0; (i_arg) < IDRP_NLRI_FAMILIES_SUPPORTED; (i_arg)++) 
#define	NLRI_FAMILY_LOOP_END

#define	RDPATH_LIST(p_can_list_arg, p_can_arg)	GENERIC_PLIST((p_can_arg), (p_can_list_arg))
#define	RDPATH_LIST_END


#define IDRP_RDPATH_LIST(p_rdp_list_arg, rd_path_list_start_arg)  GENERIC_PLIST((p_rdp_list_arg), (rd_path_list_start_arg))
#define	IDRP_RDPATH_LIST_END

#define	IDRP_RDPATH_RDI_LIST(p_rd_path_arg, p_rd_path_list_arg)	GENERIC_PLIST((p_rd_path_arg), (p_rd_path_list_arg)->p_start)
#define	IDRP_RDPATH_RDI_LIST_END

#define	IDRP_RDI_ARRAY_WALK(p_rd_path_arg, i_arg, rdi_cnt_arg)	for ((i_arg) = 0; (i_arg) < (p_rd_path_arg)->cnt; (i_arg) = (i_arg)+(rdi_cnt_arg))
#define	IDRP_RDI_ARRAY_WALK_END 

#define IDRP_RDPATH_WALK_FREE(p_rd_arg, p_rdpath_arg, p_rd_next_arg)	for((p_rd_arg) = (p_rdpath_arg); (p_rd_arg); (p_rd_arg) = (p_rd_next_arg))  { \
							 (p_rd_next_arg) = (p_rd_arg)->p_next;
#define	IDRP_RDPATH_WALK_FREE_END			}	

#define IDRP_WALK_RT_CHAIN(p_head_arg, p_ch_arg)	for ((p_ch_arg) = (idrp_rt_chain_walk *) (p_head_arg); (p_ch_arg)->p_rt; (p_ch_arg) = (p_ch_arg)->p_next)
#define IDRP_WALK_RT_CHAIN_END	

#define ANN_LIST(p_atl_arg, p_ann_list_arg)	GENERIC_PLIST((p_atl_arg), (p_ann_list_arg))
#define ANN_LIST_END

#define	ANN_WITH_LIST_WALK(p_irt_arg, i_arg, p_atl_arg)	for ((p_irt_arg) = (p_atl_arg)->with_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_arg)->p_with) 
#define	ANN_WITH_LIST_WALK_END

#define	ANN_WITH_LIST_DEL_WALK(p_irt_arg, i_arg, p_atl_arg, p_rt_next_arg) for ((p_irt_arg) = (p_atl_arg)->with_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_rt_next_arg))  { \
							 (p_rt_next_arg) = (p_irt_arg)->p_with;
#define	ANN_WITH_LIST_DEL_WALK_END		}	

#define	ANN_ANN_LIST_WALK(p_irt_arg, i_arg, p_atl_arg)	for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_arg)->p_ann_nlri)	
#define	ANN_ANN_LIST_WALK_END

#define	OANN_ANN_LIST_WALK(p_irt_arg, i_arg, p_atl_arg)	for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_arg)->p_oann_next)	
#define	OANN_ANN_LIST_WALK_END

#define	ANN_ANN_LIST_DEL_WALK(p_irt_arg, i_arg, p_atl_arg, p_irt_next_arg)  for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_next_arg)) {  \
								 (p_irt_next_arg) = (p_irt_arg)->p_ann_nlri;	
#define	ANN_ANN_LIST_DEL_WALK_END		}


#define ANN_ANN_NEXT_NLRI(p_irt_arg, i_arg, p_atl_arg)	for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_arg)->p_next_nlri)
#define	ANN_ANN_NEXT_NLRI_END

#define ANN_ANN_NEXT_NLRI_DEL(p_irt_arg, i_arg, p_atl_arg, p_irt_next_arg)	for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_next_arg)) { \
								(p_irt_next_arg) = (p_irt_arg)->p_next_nlri;
#define	ANN_ANN_NEXT_NLRI_DEL_END		}

/* define ANN_ANN_LINK_WALK(p_irt_arg, i_arg, p_atl_arg, p_irt_next_arg,link)	
 * 
 * 			for ((p_irt_arg) = (p_atl_arg)->ann_nlri[(i_arg)].head; (p_irt_arg); (p_irt_arg) = (p_irt_next_arg)) { \
 * 				switch(link) { \
 * 					case NLRI_LINKED_P_NEXT: \ 
 * 						  (p_irt_next_arg) = (p_irt_arg)->p_next_nlri; \
 *						  break; \
 * 					case NLRI_LINKED_P_WITH: \ 
 * 						  (p_irt_next_arg) = (p_irt_arg)->p_next_nlri; \
 * 						  break; \
 * 					case NLRI_LINKED_P_ANN: \		 
 * 						  (p_irt_next_arg) = (p_irt_arg)->p_ann_nlri; \
 * 						  break; \
 * 					case NLRI_LINKED_P_MIN_ADV: \ 
 * 						  (p_irt_next_arg) = (p_irt_arg)->p_next_nlri; \
 * 						  break; \
 * 					case NLRI_LINKED_P_MIN_ADV_RD: \ 
 * 						  (p_irt_next_arg) = (p_irt_arg)->p_next_nlri; \
 *  						  break; \
 * 					} 
 * #define	ANN_ANN_LINK_WALK_END		}
 */


#define	IDRP_ADV_LIST_WALK(p_adv, p_adv_head)	GENERIC_PLIST((p_adv), (p_adv_head))
#define	IDRP_ADV_LIST_WALK_END


#define IDRP_PARSE_ATT_LIST(p_att_arg, res_arg)          for ((p_att_arg) = (res_arg)->p_att; (p_att_arg); (p_att_arg) = (p_att_arg)->p_parse_next)
#define IDRP_PARSE_ATT_LIST_END

#define IDRP_PARSE_ROUTE_ID_LIST(p_rte_arg, p_att_arg, i_arg)   for ((p_rte_arg) = (p_att_arg)->p_parse_re->p_route[(i_arg)]; (p_rte_arg); (p_rte_arg) = (p_rte_arg)->p_next_nlri)
#define IDRP_PARSE_ROUTE_ID_LIST_END

#define	IDRP_PARSE_RTE_DEL_WALK(p_rte_arg, p_att_arg, p_next_rte)	for ((p_rte_arg) = (p_att_arg)->p_parse_re; (p_rte_arg); (p_rte_arg) = (p_next_rte)) { \
							(p_next_rte) = (p_rte_arg)->p_next;

#define	IDRP_PARSE_RTE_DEL_WALK_END			}

#define	IDRP_PARSE_REFRESH_PDU(p_parse_ref_arg, p_res_arg)	GENERIC_PLIST((p_parse_ref_arg), (p_res_arg)->p_refresh)
#define	IDRP_PARSE_REFRESH_PDU_END


#define	DISTINGUISHED_ATT(type_arg)	 idrpAttrBits[(type_arg)] & IDRP_ATTBT_DISTINGUISH

#define	IDRP_ATTR_NUM_LOOP(i_arg)	for ((i_arg) = IDRP_ATTR_MIN; (i_arg) > IDRP_ATTR_MAX; (i_arg)++)
#define	IDRP_ATTR_NUM_LOOP_END			
 
#define	IDRP_USR_ATTR_NUM_LOOP(i_arg) for ((i_arg) = 0; (i_arg) <= IDRP_ATTR_USR_NO; (i_arg)++)
#define	IDRP_USR_ATTR_NUM_LOOP_END			

 

#define IDRP_TRANS_LIST(p_tran_arg, p_trans_list_arg)	GENERIC_PLIST((p_tran_arg), (p_trans_list_arg))
#define IDRP_TRANS_LIST_END


/* global RDI macros */

/* the global search macros needs to change when patricia trie gets added
 */

#define	IDRP_RDI_LIST(p_rdi_arg)	GENERIC_PLIST((p_rdi_arg), rdi_list)
#define	IDRP_RDI_LIST_END		


#define	IDRP_STATUS_BIT_CLEAR(p_arg, bit_arg)	(p_arg)->status &= ~(bit_arg)
#define	IDRP_STATUS_BIT_SET(p_arg, bit_arg)	(p_arg)->status |= (bit_arg)
#define IDRP_STATUS_BIT_TEST(p_arg, bit_arg)	if ((p_arg)->status & (bit_arg)) 
#define IDRP_STATUS_BIT_ON(p_arg, bit_arg)	((p_arg)->status & (bit_arg)) 

#define	IDRP_FLAG_BIT_CLEAR(p_arg, bit_arg)	(p_arg)->idrp_flags &= ~(bit_arg)
#define	IDRP_FLAG_BIT_SET(p_arg, bit_arg)	(p_arg)->idrp_flags |= (bit_arg)
#define IDRP_FLAG_BIT_TEST(p_arg, bit_arg)	if (((p_arg)->idrp_flags & (bit_arg)) != 0) 


#define IDRP_LOCAL_BIT_SET(p_arg, bit_arg)	(p_arg)->local_mask |= (bit_arg)
#define IDRP_LOCAL_BIT_CLEAR(p_arg, bit_arg)	(p_arg)->local_mask &= ~(bit_arg)
#define IDRP_LOCAL_BIT_TEST(p_arg, bit_arg)	(p_arg)->local_mask & (bit_arg)

#define	IDRP_QOS_STATUS_BIT_CLEAR(p_arg, bit_arg)	(p_arg)->qos_status &= ~(bit_arg)
#define	IDRP_QOS_STATUS_BIT_SET(p_arg, bit_arg)		(p_arg)->qos_status |= (bit_arg)
#define IDRP_QOS_STATUS_BIT_TEST(p_arg, bit_arg)	if ((p_arg)->qos_status & (bit_arg)) 
#define IDRP_QOS_STATUS_BIT_ON(p_arg, bit_arg)		 ((p_arg)->qos_status & (bit_arg)) 

#define IDRP_IDRP_BIT_SET(p_arg, bit_arg)	(p_arg)->idrp_mask |= (bit_arg)
#define IDRP_IDRP_BIT_CLEAR(p_arg, bit_arg)	(p_arg)->idrp_mask &= ~(bit_arg)
#define	IDRP_IDRP_MASK_TEST(p_arg, big_arg)	(p_arg)->idrp_mask & (big_arg)

#define IDRP_LOCAL_CNF_TEST(bit_arg)            idrp_this_node.config_options & (bit_arg)

#define	IDRP_TRACE_BIT_TEST(p_arg, bit_arg)	if (((p_arg)->trace_flags & (bit_arg)) != 0)
#define	IDRP_TRACE_BIT_TEST_END		

#define	IS_IDRP(p_rt_arg)	if (((p_rt_arg) != NULL) && (p_rt_arg)->rt_gwp->gw_proto == RTPROTO_IDRP)			
#define	IS_AN_IDRP(p_rt_arg)	(((p_rt_arg) != NULL) && (p_rt_arg)->rt_gwp->gw_proto == RTPROTO_IDRP)			
#define IS_LOCAL_IDRP(p_rt_arg) (((p_rt_arg) != NULL) && ((p_rt_arg)->rt_idrp != NULL) && ((p_rt_arg)->rt_idrp->peer->type == IDRP_PEER_LOCAL)) 


#define SNPA_LIST(i_arg, p_snpa_arg, list_arg)   for ((i_arg) = 0, (p_snpa_arg) = &((list_arg).snpa1); (i_arg) < (list_arg).cnt && ((p_snpa_arg)); (p_snpa_arg) = (p_snpa_arg)->p_next, (i_arg)++)
#define SNPA_LIST_END 			

#define IDRP_SNPA_LIST_TAIL(p_ent_arg, p_snpa_list_arg)	for ((p_ent_arg) = (snpa_entry *) (p_snpa_list_arg)->snpa1.p_next; (p_ent_arg)->p_next == (snpa_entry *) 0; (p_ent_arg) = (p_ent_arg)->p_next )
							
#ifdef ECHOKLUDGE
#define IS_SEQUENCED(type_arg) ((type_arg) == IDRP_OPEN_TYPE || \
			   (type_arg) == IDRP_UPDATE_TYPE || \
			   (type_arg) == IDRP_ECHO_TYPE || /* %% */ \
			   (type_arg) == IDRP_ECHO_REPLY_TYPE || /* %% */ \
			   (type_arg) == IDRP_RIB_REFRESH_TYPE)
#else
#define IS_SEQUENCED(type_arg) ((type_arg) == IDRP_OPEN_TYPE || \
			   (type_arg) == IDRP_UPDATE_TYPE || \
			   (type_arg) == IDRP_RIB_REFRESH_TYPE)
#endif



#define	IDRP_ROUTE_ID_HASH(id_arg)	((id_arg) % IDRP_HASH_TABLE_SIZE)
#define IDRP_RDPATH_HASH(id_arg)	((id_arg) % IDRP_RDPATH_HASH_SIZE) 

#define PFX_BYTE_LENGTH(pfx_arg) (((pfx_arg).pfx_len + 7) /8)

#define IDRP_BER(p_idrp_rt_arg)	 ((p_idrp_rt_arg)->p_p_best_ext->p_best_ext)

/* macros for route damping */

#define IS_IDRP_ACTIVE_ROUTE(p_idrp_rt_arg)	if ((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_active))
#define ACTIVE_IDRP_ROUTE(p_idrp_rt_arg)	((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_active->rt_idrp))

#ifdef	IDRP_QOS

#define	IDRP_DAMPED_ROUTE(p_idrp_rt_arg)	((p_idrp_rt_arg)->p_rt->rt_head->p_idrp_damping[(p_idrp_rt_arg)->p_attr->rib_id])
#define IS_IDRP_DAMPED_ROUTE(p_idrp_rt_arg)	(IDRP_DAMPED_ROUTE(p_idrp_rt_arg) == (p_idrp_rt_arg))
#define IS_IDRP_QOS_ACTIVE_ROUTE(p_idrp_rt_arg)	if ((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_head->p_qos_active[(p_idrp_rt_arg)->p_attr->rib_id]))
#define ACTIVE_QOS_IDRP_ROUTE(p_idrp_rt_arg)	((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_head->p_qos_active[(p_idrp_rt_arg)->p_attr->rib_id]))

#define IS_IDRP_HEAD(p_idrp_rt_arg)		if (((p_idrp_rt_arg)->p_rt) && ((p_idrp_rt_arg)->p_rt->rt_head)) 
#define	IS_IDRP_QOS_ACTIVE(p_idrp_rt_arg,rib_id_arg)		if ((p_idrp_rt_arg)->p_rt->rt_head->p_qos_active[(rib_id_arg)])
#define	IS_IDRP_QOS_LAST_ACTIVE(p_idrp_rt_arg,rib_id_arg)	if ((p_idrp_rt_arg)->p_rt->rt_head->p_qos_lastactive[(rib_id_arg))
#define	IDRP_QOS_LAST_ACTIVE(p_idrp_rt_arg,rib_id_arg)		((p_idrp_rt_arg)->p_rt->rt_head->p_qos_lastactive[(rib_id_arg)])

#else	/* IDRP_QOS */

#define	IDRP_DAMPED_ROUTE(p_idrp_rt_arg)	((p_idrp_rt_arg)->p_rt->rt_head->p_idrp_damping)

#define IS_IDRP_DAMPED_ROUTE(p_idrp_rt_arg)	(((p_idrp_rt_arg)!= NULL) && ((p_idrp_rt_arg)->p_rt != NULL) && ((p_idrp_rt_arg)->p_rt->rt_head != NULL) && (IDRP_DAMPED_ROUTE(p_idrp_rt_arg) == (p_idrp_rt_arg)))

#define	IS_A_IDRP_DAMPED_ROUTE(p_idrp_rt_arg)	 (IDRP_DAMPED_ROUTE(p_idrp_rt_arg) == (p_idrp_rt_arg))
#define IS_IDRP_ACTIVE_ROUTE(p_idrp_rt_arg)	if ((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_active))
#define ACTIVE_IDRP_ROUTE(p_idrp_rt_arg)	((idrpRoute*)((p_idrp_rt_arg)->p_rt->rt_active->rt_idrp))
#endif /* IDRP_QOS */

/* below two are used by idrp_del_rt_gated -- don't reset rt bit if timer is running on this route */
#define IDRP_RESET_RT_BIT		TRUE
#define IDRP_NO_RESET_RT_BIT		FALSE

/* Various SJR macros */
#define IDRP_LOCAL_MEM_FIT(t_arg) ((t_arg) *) idrp_local_mem_fit(sizeof((t_arg)))
#define IDRP_MEM_FIT_FREE(p_arg) idrp_mem_fit_free((void **) &(p_arg), (p_arg) ? sizeof(*(p_arg)) : 0); 

#define IDRP_MEM_FIT_ZERO(var_arg, t_arg) do { \
	(var_arg) = IDRP_LOCAL_MEM_FIT((t_arg)); \
	bzero((char *) (var_arg), (t_arg)); \
	} while (0)

#define IDRP_CANON_RDPATH_ALLOC(p_path_arg) do { \
	(p_path_arg) = (struct _idrp_canon_rdpath *) idrp_local_mem_fit(sizeof(*(p_path_arg))); \
	} while (0)
	 
#define IDRP_QOS_ALLOC(p_qos_arg, op_arg, val_arg) do { \
 	(p_qos_arg) = (struct _qos_operator *) idrp_local_mem_fit(sizeof(struct _qos_operator)); \
	(p_qos_arg)->operator = (op_arg); (p_qos_arg)->value = (val_arg); \
	} while (0)

#define IDRPROUTE_OPTS_ALLOC(p_IR_opts_arg) do { \
    	(p_IR_opts_arg) = (idrpRoute_options *) idrp_local_mem_fit(sizeof(idrpRoute_options)); \
    	(p_IR_opts_arg)->rib_id = RIB_ID_DEFAULT; \
    	} while(0)

#define IDRP_RDI_ALLOC(p_rdi_arg) do { \
	(p_rdi_arg) = (rdi *) idrp_local_mem_fit(sizeof(*(p_rdi_arg))); \
	} while (0)

#define IDRP_PS_ALLOC(adv_arg, flag_arg) do { \
	(adv_arg) = adv_alloc(ADVFT_PS, RTPROTO_IDRP); \
	(adv_arg)->adv_ps = (void_t) idrp_local_mem_fit(sizeof(struct _idrp_ps_t)); \
	((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag |= (flag_arg); \
	} while (0)

#define IDRP_PS_BIT_SET(adv_arg, flag_arg) BIT_SET((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))
#define IDRP_PS_BIT_RESET(adv_arg, flag_arg) BIT_RESET((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))
#define IDRP_PS_BIT_FLIP(adv_arg, flag_arg) BIT_FLIP((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))
#define IDRP_PS_BIT_TEST(adv_arg, flag_arg) BIT_TEST((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))
#define IDRP_PS_BIT_MATCH(adv_arg, flag_arg) BIT_MATCH((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))
#define IDRP_PS_BIT_COMPARE(adv_arg, flag_arg) BIT_COMPARE((((struct _idrp_ps_t *) (adv_arg)->adv_ps)->ps_flag), (flag_arg))

#define IDRP_DIST_ATT_ALLOC(p_dist_arg, flag_arg)  do { \
	(p_dist_arg) = (idrp_distinguish_att *) idrp_local_mem_fit(sizeof(idrp_distinguish_att)); \
  	BIT_SET((p_dist_arg)->idrp_mask, (flag_arg)); \
	} while (0)

#define IDRP_DIST_ATT_SET(dist_arg, op_arg, val_arg)  do { \
	(dist_arg).operator = (op_arg); \
  	(dist_arg).value = (val_arg); \
	} while (0)

#define IDRP_ROUTE_INFO_ALLOC(p_info_arg) do { \
	(p_info_arg) = (idrpRoute_info *) idrp_local_mem_fit(sizeof(*(p_info_arg))); \
	(p_info_arg)->idrp_pref = IDRP_INVALID_ROUTE_PREF; \
	} while (0)

#define IDRP_POLICY_RDPATH_ALLOC(p_rdp_arg) do { \
	(p_rdp_arg) = (policy_rdpath *) idrp_local_mem_fit(sizeof(*(p_rdp_arg))); \
	bzero((p_rdp_arg), sizeof(*(p_rdp_arg))); \
	} while (0)

#define QOS_TEST(policy_arg, val_arg) ((((policy_arg).operator == IDRP_QOS_OP_NO) \
	 && ((val_arg).operator == IDRP_QOS_OP_NO)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_LE) \
     && ((val_arg).value <= (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_LT) \
     && ((val_arg).value < (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_EQ) \
     && ((val_arg).value == (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_NE) \
     && ((val_arg).value != (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_GT) \
     && ((val_arg).value > (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_GE) \
     && ((val_arg).value >= (policy_arg).value)))

#define ONE_SIDED_QOS_TEST(policy_arg, val_arg) ( \
     (((policy_arg).operator == IDRP_QOS_OP_LE) \
     && ((val_arg) <= (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_LT) \
     && ((val_arg) < (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_EQ) \
     && ((val_arg) == (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_NE) \
     && ((val_arg) != (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_GT) \
     && ((val_arg) > (policy_arg).value)) \
   ||(((policy_arg).operator == IDRP_QOS_OP_GE) \
     && ((val_arg) >= (policy_arg).value)))


#define ISO_NET_CMP(p_net1_arg, p_net2_arg) bcmp_bothlens((const caddr_t) (p_net1_arg)->isoa_genaddr, (p_net1_arg)->isoa_len, (const caddr_t) (p_net2_arg)->isoa_genaddr, (p_net2_arg)->isoa_len)

#define RDI_CMP(p_rdi1_arg, p_rid2_arg) (((p_rdi1_arg) == (p_rid2_arg)) ? 0 : bcmp_bothlens((const caddr_t) (p_rdi1_arg)->rdi.isoa_genaddr, (p_rdi1_arg)->rdi.isoa_len, (const caddr_t) (p_rid2_arg)->rdi.isoa_genaddr, (p_rid2_arg)->rdi.isoa_len))

/* RIB lists */

#ifdef	IDRP_QOS

#define	QOS_RIB_LIST(i_arg)	for ((i_arg) = 0; (i_arg) < rib_cnt; (i_arg)++)  
#define QOS_RIB_LIST_END	

#define	QOS_RIB_ONLY_LIST(i_arg) for ((i_arg) = 1; (i_arg) < rib_cnt; (i_arg)++)  
#define QOS_RIB_ONLY_LIST_END
	
#define	LAST_RIB_LIST(i_arg)	for ((i_arg) = 0; (i_arg) < last_rib_cnt ; (i_arg)++)  
#define LAST_RIB_LIST_END	

#define PEER_RIB_LIST(i_arg,i_max_arg)	for ((i_arg) = 0; (i_arg) < (i_max_arg); (i_arg)++) 
#define PEER_RIB_LIST_END	


#else	/* IDRP_QOS */

#define	QOS_RIB_LIST(i_arg)
#define	QOS_RIB_LIST_END

#define	QOS_RIB_ONLY_LIST(i_arg)
#define QOS_RIB_ONLY_LIST_END

#define	LAST_RIB_LIST(i_arg)
#define LAST_RIB_LIST_END	

#define PEER_RIB_LIST(i_arg,i_max_arg)	
#define PEER_RIB_LIST_END	
#endif /* IDRP_QOS */


#endif /* not defined _idrp_macros_h */



