/* 
 * $Id: idrp_globals.h,v 1.10 1996/08/27 16:06:02 sjr Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#ifndef _idrp_globals_h
#define _idrp_globals_h

/* Options */

/* flow control */

extern int acked_something;	/* True if last received packet acknowledged something */

/* task interface */

extern int doing_idrp;		/* Are we running IDRP protocols? */
extern int idrp_reparsing;	/* idrp is reparsing */
extern boolean idrp_rdi_change;	/* idrp is reparsing */

extern task *idrp_master_task;			/* IDRP master task block */
extern  flag_t idrp_trace_flags;			/* Trace flags from parser */
extern  trace *idrp_trace_options;      	/* Trace options froms parser */
extern	int idrp_default_preference;		/* idrp default preference */


/* task block pointers for allocation of space in task block initialization */

extern block_t		idrp_huge_blk_index;
extern block_t		idrp_big_block_index;
extern block_t		idrp_small_blk_index;
extern block_t		idrp_med_blk_index;


/* idrp variables for unix sockets */

extern u_short idrp_port;	/* IDRP well known port */

/* global addresses for IP and OSI */
/* addresses for this box */
/* ip addresses - rt_ip_rdi - must have match to AS */
/* look at this again prior to moving to IP */

extern struct iso_net_addr rt_rdi;		/* Our routing domain identifier */
extern	rdi	*p_rt_rdi;			/* pointer to routing domain identifer in global list */
extern	rdi	*p_rt_rdi_ordered;		/* pointer to routing domain identifer in global list */
extern	rdpath_list	*p_my_rdpath;			/* pointer to my rdpath */	
extern RD_path	local_rd_path;			/* fake RD pathway structure */ 
						/* for local routes */
	
extern int    rt_net_cnt;		/* count of local iso addresses for this node */	
extern struct iso_net_addr rt_net[IDRP_MAX_LOCAL_NETS];	/* Our network entity title %% */
extern struct iso_net_addr rt_as_rdi;	/* our Mapping from AS to RDI */ 
extern snpa_list rt_snpa;		/* snpa for this node */

/* IP information */

extern struct iso_net_addr rt_ip_rdi;	/* Our Routing Domain identifier for IP */
					/* only if we are running SIN idrp */
					/* for IP and OSI */ 
extern sockaddr_un rt_ip_net[IDRP_MAX_LOCAL_NETS];		/* our IP address for NET */
extern	int	   rt_ip_net_cnt;			        /* cnt of nets */

/* local route information */

extern int		idrp_local_route_cnt;	/* count of local route blocks */
extern route_separator	idrp_local_route_id;	/* our local route id - negative, zero pref */
extern int 		local_hop_count;	/* our local hop count - zero */


/* link list of idrp neighbors - IP and OSI depends only on the address inside */

extern int	idrp_neighbors;		/* Count of neighbors */
extern int	idrp_ext_neighbors;	/* Count of external neighbors */
extern int	idrp_int_neighbors;	/* Count of external neighbors */
extern int	idrp_n_disabled;	/* configured but disabled neighbors */
extern int	idrp_n_established;	/* established IDRP neighbors */ 
extern int 	idrp_n_ext_established;	/* Unused? */

extern idrpPeer	*idrp_peers;		/* front of linked list of IDRP peers */
extern idrpPeer	*idrp_peers_end;	/* last of linked list of IDRP peers */
extern idrpPeer	*idrp_ext_peers;	/* pointer to first external peer */
extern idrpPeer	*idrp_last_int_peer;	/* pointer to last intternal peer */

extern idrpPeer	idrp_this_node;		/* peer structure for this node */
					/* used in local routes */
extern int	consistency_errors;	/* consistency errors */

extern pref_t idrp_ext_def_pref; /* external default preference */
extern pref_t idrp_int_def_pref; /* internal default preference */

extern int	rib_cnt;
extern int	last_rib_cnt;

#ifdef IDRP_QOS
/* qos ribs information */

extern  u_int		qos_rib_changed;		/* flag in qos_rib */	
extern idrp_qos_rib	*qos_rib[IDRP_MAX_QOS_RIBS+1];
extern idrp_qos_rib	*last_qos_rib[IDRP_MAX_QOS_RIBS+1];

#endif
 

/* attribute lists */

#ifdef IDRP_QOS

extern	idrp_attribute_record *idrp_attr_list[IDRP_MAX_QOS_RIBS+1];		/* zero entry is always default */ 
extern	idrp_att_list 	      *idrp_oatt_list[IDRP_MAX_QOS_RIBS+1];		/* linked list of output only attributes */

extern	idrp_attribute_record *last_attr_list[IDRP_MAX_QOS_RIBS+1];		/* zero entry is always default */ 
extern	idrp_att_list 	      *last_oatt_list[IDRP_MAX_QOS_RIBS+1];		/* linked list of output only attributes */
#else /* ifdef IDRP_QOS */

extern	idrp_attribute_record *idrp_attr_list;		/* linked list of attributes */
extern	idrp_att_list 	      *idrp_oatt_list;		/* linked list of output only attributes */
#endif /* IDRP_QOS */

extern	idrp_rdpath_hash  *rd_path_list_hash[IDRP_RDPATH_HASH_SIZE];
extern	rdi	*rdi_list;			/* global rdi list - rdi listed once */

extern  idrp_canon_rdpath	*canon_rd_list; /* canonical list of rd paths */
	
/* stuff for best external routes pseudo-RIB */

extern idrp_best_ext *ber_rib_head;	/* points to beginning of best external */

/* add structure for adding to table */
/* idrp pdu buffer */

extern idrpPdu	*idrp_send_buffer;	/* buffer for sending idrp pdu */

/* Policy definitions for idrp
 *
 * import_lists -
 * 
 * idrp_import_list   - global import policy list
 * idrp_export_list - global list of idrp export policy
 *
 *     		  
 *		   
 */


extern int notifyLengths[];		/* Lengths of notifyData */
extern metric_t idrp_default_metric;	/* Default IDRP metric to use */

extern adv_entry *idrp_import_list;	/* List of IDRP advise entries */
extern adv_entry *idrp_import_list_any_rdi; 	/* IDRP "any" lists */
extern adv_entry *idrp_import_rdpath_list;  	/* List of IDRP RD paths */
extern adv_entry *idrp_export_list;	/* List of IDRP export entries */
extern adv_entry *idrp_export_list_any_rdi; 	/* IDRP "any" lists */

/* idrp protocol states */
 
extern const bits idrpStates[];		/* Values of the states */

/* should this change to bits??? */

extern const char *idrpManagementEvents[];	/* Names of IDRP management events */
extern const char *idrpTypes[];		/* Names of IDRP PDU types */
extern const char *idrpAttrTypeStrings[];    /* Names of IDRP Attribute Types */


/* Maybe this should be replaced by a shift of these bits
 * Must match the sequence of ATTRIBUTE types
 */

extern const char idrpAttrType[];		/* Type code for IDRP Attributes */ 

/* attribute flags array */

extern const int idrpAttrFlags[]; 		/* attribute flag values */
extern const int idrpManatt[];		/* attribute bit mask */
extern	const boolean idrpXmitatt[];		/* logical array of attributes that are modified before xmit */ 

extern const int idrpAttrBits[];		/* attribute bit mask */
extern const boolean idrpAttrDIS[];		/* distinguished attribute array */

extern const bits idrp_flag_bits[];		/* pretty print bits */ 
extern const char *idrpChangeTypes[];		/* Names of IDRP change field values */
extern const nlri_proto_info idrp_nlri_proto_id[];	/* protocol id info array for nlri in update */ 
extern const nlri_fam	nlri_family[];		/* nlri family */
extern const fam_nlri	family_nlri[];		/* nlri family */
extern const u_int	proto_header_len[];	/* header length for each protocol  for update pdu */

/* these arrays are not set-up */
 
extern const bits idrpEvents[];		/* Event values */

extern const char 	*char_qos_operators[];	/* qos operators */		

#endif	/* not defined _idrp_globals_h */
