#
#    Set up some global variables for file names and locations
#    for running the gated config file generator and test program.
#

#
#    THE FOLLOWING VARIABLES ARE SYSTEM- AND USER-DEPENDENT.
#
#    gated_work_dir  Directory where the gated.conf, expected.txt,
#                    and gated (or link to) are located.
#
#    gated_test_dir  Directory which contains the individual test
#                    subdirectories.
#
#    gated_scripts   Directory containing scripts and templates needed
#                    for running this program and the gated config file
#                    generator.
#
#    gated_sync_file_dir  Directory for coordinating node synchronization
#                         (having all nodes run the same test at the same time).
#
#    gated_mainlog_dir    Tells gated writes the log file.
#                         Used by config file generator to set file name
#                         and by test program as reference.
#
#    gated_default_rt_gw  Gateway for the default IP route.
#    Used by:
#      - test program to install default route after clearing routing table
#      - config file generator for gw field if no "ip_gw" specified in .cfg file
#
#    gated_perl_cmd       Perl executable (directory and file name)
#

setenv gated_work_dir        ~skh/gated/$HOST
setenv gated_test_dir        /lusr/skh/j/g/tests
setenv gated_scripts         /lusr/skh/j/g/scripts
setenv gated_sync_dir        /lusr/skh/j/g/sync
setenv gated_mainlog_dir     /var/log
setenv gated_qos_dir         /var/tmp
setenv gated_default_rt_gw   198.108.60.2
setenv gated_perl_cmd        /usr/local/bin/perl


#
#    SYSTEM INDEPENDENT VARS
#

#  Location of log files to be stored locally
setenv gated_locallog_dir $gated_work_dir/logs

#  Name of the gated log file
setenv gated_log_file_name gatedlog.idrp

#  Location of machine map for config file generator
setenv gated_machine_map $gated_scripts/machines.map

#  Location of template for config file generator
setenv gated_template_file $gated_scripts/config_template.tpl

#  Name of the config file gated is to use
setenv gated_config_file $gated_work_dir/gated.conf

#  Name of the expected results file
setenv gated_results_file $gated_work_dir/expected.txt

#  Name of the patterns file used by compare script
setenv gated_cmp_pat_file $gated_scripts/cmp_patterns.txt

#  Name of the script to use to compare routing table
#  with expected results
setenv gated_cmp_script "$gated_perl_cmd $gated_scripts/cmp_results.perl"

#  Name of the QOS file (used in comparing expected results)
setenv gated_qos_file $gated_qos_dir/qos_kernel.log

