#!/bin/csh
#
#
set log_file="/var/log/gatedlog.idrp"
set pattern="MEM_TRACE"
#
set tot_tot=`grep "$pattern" $log_file | wc -l`
set alloc_tot=`grep "$pattern.*alloc" $log_file | wc -l`
set free_tot=`grep "$pattern.*free" $log_file | wc -l`
#
set sm_tot=`grep "$pattern.*sm" $log_file | wc -l`
set med_tot=`grep "$pattern.*med" $log_file | wc -l`
set big_tot=`grep "$pattern.*big" $log_file | wc -l`
set huge_tot=`grep "$pattern.*huge" $log_file | wc -l`
set peer_tot=`grep "$pattern.*peer" $log_file | wc -l`
#
set sm_alloc=`grep "$pattern.*sm.*alloc" $log_file | wc -l`
set med_alloc=`grep "$pattern.*med.*alloc" $log_file | wc -l`
set big_alloc=`grep "$pattern.*big.*alloc" $log_file | wc -l`
set huge_alloc=`grep "$pattern.*huge.*alloc" $log_file | wc -l`
set peer_alloc=`grep "$pattern.*peer.*alloc" $log_file | wc -l`
#
set sm_free=`grep "$pattern.*sm.*free" $log_file | wc -l`
set med_free=`grep "$pattern.*med.*free" $log_file | wc -l`
set big_free=`grep "$pattern.*big.*free" $log_file | wc -l`
set huge_free=`grep "$pattern.*huge.*free" $log_file | wc -l`
set peer_free=`grep "$pattern.*peer.*free" $log_file | wc -l`
#
@ sm_diff  = $sm_alloc - $sm_free
@ med_diff = $med_alloc - $med_free
@ big_diff = $big_alloc - $big_free
@ huge_diff  = $huge_alloc - $huge_free
@ peer_diff  = $peer_alloc - $peer_free
#
echo "               ------------------"
echo "               Calls to MEM_TRACE"
echo "               ------------------"
echo ""
echo "          Total		Alloc	Free	Diff"
echo "=============================================="
echo "small     $sm_tot		$sm_alloc	$sm_free	$sm_diff"
echo "medium    $med_tot		$med_alloc	$med_free	$med_diff"
echo "big       $big_tot		$big_alloc	$big_free	$big_diff"
echo "huge      $huge_tot		$huge_alloc	$huge_free	$huge_diff"
echo "peer      $peer_tot		$peer_alloc	$peer_free	$peer_diff"
echo "=============================================="
echo "          $tot_tot		$alloc_tot	$free_tot"
echo ""
