/*
 * Public Release 3
 * 
 * $Id: ripng.h,v 1.1.2.3 1998/10/20 19:31:37 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

extern flag_t ripng_flags;		/* Option flags */
extern trace *ripng_trace_options;	/* RIPng tracing configuration */
extern const bits ripng_trace_types[];	/* List of RIPng specific trace flags */
extern metric_t ripng_default_metric;	/* Default metric to use when propogating */
extern int ripng_n_trusted;		/* Number of Trusted RIPng gateways */
extern metric_t ripng_preference;	/* Preference for RIP routes */
extern gw_entry *ripng_gw_list;		/* List of RIPng gateways */
extern adv_entry *ripng_export_list;	/* List of nets to export */
extern adv_entry *ripng_import_list;	/* List of nets to import and not import */
extern adv_entry *ripng_int_policy;	/* List of interface policy */

/* Values for ripng_flags */
#define RIPNGF_ON		BIT(0x01)	/* RIPng is enabled */
#define RIPNGF_TERMINATE	BIT(0x02)	/* RIPng is terminating */
#define	RIPNGF_RECONFIG		BIT(0x08)	/* Initial processing or reconfiguration */

#define RIPNG_METRIC_SHUTDOWN		15
#define RIPNG_METRIC_UNREACHABLE	16
#define RIPNG_METRIC_NEXTHOP		255

#define RIPNG_LIMIT_METRIC		1, RIPNG_METRIC_UNREACHABLE /* for parser */

#define	RIPNG_CONFIG_IN			1 /* ripin */
#define	RIPNG_CONFIG_OUT		2 /* ripout */
#define	RIPNG_CONFIG_METRICIN		3 /* metricin */
#define	RIPNG_CONFIG_METRICOUT		4 /* metricout */
#define	RIPNG_CONFIG_MAX		5 /* max if option */

/* Tracing */
#define	TR_RIPNG_INDEX_PACKETS	0	/* All packets */
#define	TR_RIPNG_INDEX_REQUEST	1	/* Request packets (REQUEST, POLL, POLLENTRY) */
#define	TR_RIPNG_INDEX_RESPONSE	2	/* Response packets (RESPONSE) */
#define	TR_RIPNG_INDEX_OTHER	3	/* Other packets (TRACE_ON, TRACE_OFF) */

#define	TR_RIPNG_DETAIL_REQUEST		TR_DETAIL_1
#define	TR_RIPNG_DETAIL_RESPONSE	TR_DETAIL_2
#define	TR_RIPNG_DETAIL_OTHER		TR_DETAIL_3

/*  */

PROTOTYPE(ripng_init,
	  extern void,
	  (void));
PROTOTYPE(ripng_var_init,
	  extern void,
	  (void));
