/*
 * Public Release 3
 * 
 * $Id: isis_prototypes.h,v 1.3.2.2 1998/10/20 19:30:15 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */


#ifndef _isis_prototypes_h
#define _isis_prototypes_h

/* from isis_main.c */
PROTOTYPE(isis_init, extern void, (void));
PROTOTYPE(isis_var_init, extern void, (void));

/* from isis_globals.c */
PROTOTYPE(setAreaAddr, extern void, (u_char *));
PROTOTYPE(initGlobals, extern void, (int));

/* from isis_spf.c */
PROTOTYPE(isis_spf, extern void, (int));

/* from isis_spf_iter.c */
PROTOTYPE(spf_get_first_lsp, extern void, (struct lsp_iter_state *));
PROTOTYPE(set_subfield_state, extern void, (struct subfield_iter_state *));
PROTOTYPE(get_first_nodeaddr, extern octet *, (struct subfield_iter_state *, IS_ID *));
PROTOTYPE(get_next_nodeaddr, extern octet *, (struct subfield_iter_state *));

/* from isis_events.c */
PROTOTYPE(logAdjEvent, extern void, (CircuitEntry *, AdjacencyEntry *, const char *));
PROTOTYPE(adjInitFailureEvent, extern void, (CircuitEntry *, AdjacencyEntry *, ReasonCode, SystemID6 *, int));
PROTOTYPE(adjDownEvent, extern void, (CircuitEntry *, AdjacencyEntry *, ReasonCode));
PROTOTYPE(adjUpEvent, extern void, (CircuitEntry *, AdjacencyEntry *));
PROTOTYPE(desigSysChangeEvent, extern void, (CircuitEntry *, int, Boolean));
PROTOTYPE(circuitUpEvent, extern void, (CircuitEntry *));

/* from isis_flood.c */
PROTOTYPE(removeFromDeletedList, extern void, (LSEntry *));
PROTOTYPE(updateLifetime, extern void, (LSEntry *));
PROTOTYPE(normalLSPExpired, extern int, (LSEntry *));
PROTOTYPE(deletedLSPExpired, extern int, (LSEntry *));
PROTOTYPE(signalDecisionProcess, extern void, (int));
PROTOTYPE(firstLSP, extern LSEntry *, (int));
PROTOTYPE(newLSEntry, extern LSEntry *, (u_char *, int, LSSignature *));
PROTOTYPE(locateLSPByID, extern LSEntry *, (int, LSPID));
PROTOTYPE(locateLowestLSP, extern LSEntry *, (int, LSPID));
PROTOTYPE(correctedLifetime, extern u_short, (LSEntry *));
PROTOTYPE(floodPt2Pt, extern void, (task_timer *, time_t));
PROTOTYPE(floodBroadcast, extern void, (task_timer *, time_t));
PROTOTYPE(dumpDB, extern void, (void));
PROTOTYPE(storeLSEntry, extern void, (LSEntry *));
PROTOTYPE(updateLSEntry, extern Boolean, (LSEntry *, u_char *, int, LSSignature *));
PROTOTYPE(setFlags, extern void, (Boolean *, int, int));
PROTOTYPE(clrFlags, extern void, (Boolean *, int, int));
PROTOTYPE(printLSPContents, extern void, (FILE *, u_char *, int));
PROTOTYPE(CEToIndex, extern int, (CircuitEntry *));
PROTOTYPE(ackLSP, extern void, (CircuitEntry *, LSEntry *));
PROTOTYPE(sendLSP, extern void, (CircuitEntry *, LSEntry *));
PROTOTYPE(updateSeqAndFlood, extern void, (LSEntry *, long));
PROTOTYPE(ackAndFlood, extern void, (CircuitEntry *, LSEntry *));
PROTOTYPE(markForDeletion, extern void, (LSEntry *, int));
PROTOTYPE(purgeLSP, extern void, (LSEntry *));
PROTOTYPE(dumpLSPList, extern void, (AgeList *));
PROTOTYPE(dumpLSPDB, extern void, (FILE *, int));
PROTOTYPE(floodAllLSPs, extern void, (CircuitEntry *, int));
PROTOTYPE(isis_freelseChangeList, extern void, (void));

/* from isis_lanhello.c */
PROTOTYPE(lanElection, extern void, (CircuitEntry *, int));
PROTOTYPE(lanFirstTimeElection, extern void, (CircuitEntry *));
PROTOTYPE(purgeExistingPLSP, extern void, (CircuitEntry *, int));
PROTOTYPE(isolated, extern int, (CircuitEntry *));
PROTOTYPE(sendLANHello, extern int, (CircuitEntry *, Unsigned8));
PROTOTYPE(processLANHello, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(processESAdj, extern void, (CircuitEntry *, int, SystemID6 *, u_short, MACAddress));

/* from isis_lsp.c */
PROTOTYPE(updateAreaAddrs, extern void, (AreaAddrList *, LSPOption *));
PROTOTYPE(lspChanged, extern void, (LSPDesc *));
PROTOTYPE(enterLSPOverload, extern void, (LSSignature *));
PROTOTYPE(newLSPGroup, extern LSPGroup *, (u_char, u_char));
PROTOTYPE(addIPReachToLSP, extern prefIP *, (LSPGroup *, MetricList, struct in_addr, struct in_addr, u_char, as_path *));
PROTOTYPE(addPrefixNeighbor, extern prefISO *, (LSPGroup *, MetricList, octet *, int, as_path *));
PROTOTYPE(addESNeighbor, extern LSPOptPtr, (LSPGroup *, MetricList, int, SystemID6));
PROTOTYPE(lspIPPrefixChanged, extern void, (prefIP *, MetricList));

/* from isis_pktdispatch.c */
PROTOTYPE(ISISpduInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ESISpduInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ISHInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));
PROTOTYPE(ESHInput, extern void, (CircuitEntry *, u_char *, int, MACAddress));

/* from isis_snp.c */
PROTOTYPE(sendCSNP, extern void, (CircuitEntry *, int));
PROTOTYPE(generateCSNP, extern void, (task_timer *, time_t));
PROTOTYPE(generatePSNP, extern void, (task_timer *, time_t));

/* from isis_adjacency.c */
PROTOTYPE(ageListInsert, extern void, (AgeList *, u_char *));
PROTOTYPE(ageListRemove, extern void, (AgeList *, u_char *));
PROTOTYPE(locateAdjByMAC, extern AdjacencyEntry *, (MACAddress));
PROTOTYPE(startAdjScan, extern AdjacencyEntry *, (void));
PROTOTYPE(nextAdj, extern AdjacencyEntry *, (void));
PROTOTYPE(newAgeList, extern AgeList *, (PTIF, u_short));
PROTOTYPE(createAdjacency, extern AdjacencyEntry *, (CircuitEntry *, SystemType, MACAddress, u_short, int));
PROTOTYPE(adjacencyExpired, extern int, (AdjacencyEntry *));
PROTOTYPE(ageListAge, extern void, (void));
PROTOTYPE(removeAdjFromHash, extern void, (AdjacencyEntry *));
PROTOTYPE(initOldAdjacencies, extern void, (void));
PROTOTYPE(deleteOldAdjacencies, extern void, (int));
PROTOTYPE(addOldAdjacency, extern void, (AdjacencyEntry *));
PROTOTYPE(updateAdjHt, extern void, (CircuitEntry *, AdjacencyEntry *, u_short));

/* from isis_circuit.c */
PROTOTYPE(createCircuit, extern CircuitEntry *, (int, CircuitType, char *, MetricList, MetricList, 
						 u_char, u_char, Boolean, MACAddress, int));
PROTOTYPE(changeCircuit, extern void, (CircuitEntry *, MetricList, MetricList, u_char, u_char));

PROTOTYPE(circuitL1IIHTimeout, extern void, (task_timer *, time_t));
PROTOTYPE(circuitL2IIHTimeout, extern void, (task_timer *, time_t));
PROTOTYPE(circuitP2PIIHTimeout, extern void, (task_timer *, time_t));
PROTOTYPE(isisDie, extern void, (void));
PROTOTYPE(solicitESConfig, extern void, (CircuitEntry *));
PROTOTYPE(switchToIS, extern void, (void));

/* from isis_common.c */
PROTOTYPE(getTimeOfDay, extern long, (void));
PROTOTYPE(LSPinsertAreaAddrList, extern u_char *, (AreaAddrList, u_char *));
PROTOTYPE(insertAreaAddrList, extern u_char *, (AreaAddrList, u_char *));
PROTOTYPE(insertPadding, extern u_char *, (u_char *, int));
PROTOTYPE(typeToStr, extern const char *, (int));
PROTOTYPE(circuitLevelToStr, extern char *, (u_char));
PROTOTYPE(circuitTypeToStr, extern const char *, (CircuitType));
PROTOTYPE(IDToStr, extern char *, (u_char *, int));
PROTOTYPE(LSPIDToStr, extern char *, (LSPID));
PROTOTYPE(flagsToStr, extern char *, (flag_t));
PROTOTYPE(systemTypeToStr, extern const char *, (SystemType));
PROTOTYPE(reasonCodeToStr, extern const char *, (ReasonCode));
PROTOTYPE(adjStateToStr, extern const char *, (AdjacencyState));
PROTOTYPE(LSSigToStr, extern char *, (LSSignature *));
PROTOTYPE(addCommon, extern int, (CommonHeader *, u_int));
PROTOTYPE(mallocOrDie, extern caddr_t, (int));
PROTOTYPE(justMalloc, extern char *, (int));
PROTOTYPE(dumpBuffer, extern void, (u_char *, int));
PROTOTYPE(transmitPacket, extern void, (CircuitEntry *, MACAddress, u_char *, int));
PROTOTYPE(printAreaAddrList, extern void, (const char *, AreaAddrList *));
PROTOTYPE(matchAreaAddr, extern int, (AreaAddr *, AreaAddr *));
PROTOTYPE(matchAreaAddrList, extern int, (AreaAddrList *, AreaAddrList *));
PROTOTYPE(withinOurArea, extern Boolean, (AreaAddr *));
PROTOTYPE(arrayCmp, extern int, (u_char *, u_char *, int));
PROTOTYPE(parseNsap, extern int, (u_char *, u_char, AreaAddr *, u_char *));
PROTOTYPE(IDMemberOf, extern int, (SystemID6, SystemID6 *, int));
PROTOTYPE(enableRoutingModule, extern void, (void));
PROTOTYPE(disableRoutingModule, extern void, (void));
PROTOTYPE(LSPIDtoStr, extern char *, (LSPID));

/* from isis_dual.c */
PROTOTYPE(insertProtoSup, extern u_char *, (u_char *, Boolean));
PROTOTYPE(insertIPaddr, extern u_char *, (CircuitEntry *, u_char *, Boolean));
PROTOTYPE(setIPReachable, extern prefIP *, (int, u_char, MetricList, struct in_addr, struct in_addr, as_path *));
PROTOTYPE(clearIPReachable, extern void, (int, u_char, prefIP *));
PROTOTYPE(addIPAddr, extern void, (CircuitEntry *, struct in_addr));

/* from isis_gated_util.c */
#if (_BSD > 43) || (BSD > 43)
PROTOTYPE(Transmit, extern int, (CircuitEntry *, MACAddress, u_char *, int));
#else
PROTOTYPE(Transmit, extern int, (void));
#endif

/* from isis_netdutil.c */
PROTOTYPE(netdTransmitSock, extern int, (void));
PROTOTYPE(netdReceiveSock, extern int, (char *));
PROTOTYPE(netdTransmit, extern void, (int, int, char *, char *, int));
PROTOTYPE(netdReceive, extern int, (int, char *, int, sockaddr_un *, int, int *));

/* from isis_parseutil.c */
PROTOTYPE(retrieveAreaAddr, extern AreaAddr *, (char));
PROTOTYPE(storeAreaAddr, extern char, (u_char *));
PROTOTYPE(parseProtoSup, extern u_int, (u_char *, u_char));

/* from isis_timer.c */
PROTOTYPE(feepTimer, extern void, (void));

/* from isis_trollutil.c */
PROTOTYPE(trollTransmit, extern int, (CircuitEntry *, MACAddress, char *, int));

#endif	/* _isis_prototypes_h */
