/*
 * Public Release 3
 * 
 * $Id: dvmrp.h,v 1.3.2.2 1998/10/20 19:29:30 swright Exp $
 *
 *  Author: Tom Pusateri <pusateri@netedge.com>
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifdef	PROTO_DVMRP
/*
 * Distance Vector Multicast Routing Protocol
 *  
 */

/*
 * DVMRP message types (carried in the "code" field of an IGMP header)
 */
#define DVMRP_PROBE		1	/* for finding neighbors             */
#define DVMRP_REPORT		2	/* for reporting some or all routes  */
#define DVMRP_ASK_NEIGHBORS	3	/* sent by mapper, asking for a list */
					/* of this router's neighbors. */
#define DVMRP_NEIGHBORS		4	/* response to such a request */
#define DVMRP_ASK_NEIGHBORS2	5	/* as above, want new format reply */
#define DVMRP_NEIGHBORS2	6
#define DVMRP_PRUNE		7	/* prune message */
#define DVMRP_GRAFT		8	/* graft message */
#define DVMRP_GRAFT_ACK		9	/* graft acknowledgement */
#define DVMRP_MAX_TYPE		10	/* all dvmrp messages below this */


/*
 * DVMRP Version capabilities
 * These flags help us determine the capabilities of the versions
 * of DVMRP we must interoperate with.
 */
#define DVMRP_NBR_LEAF		0x01	/* has no downstream neighbors */
#define	DVMRP_NBR_PRUNE		0x02	/* capable of handling prunes */
#define	DVMRP_NBR_GENID		0x04	/* includes generation id in probe */
#define DVMRP_NBR_MTRACE	0x08	/* capable of handling traceroute */

#define DVMRP_NBR_ONEWAY	0x01	/* nbr doesn't know about us */

#define DVMRP_VERSION_MAJOR	3	/* Gated DVMRP release */ 
#define	DVMRP_VERSION_MINOR	20	/* First beta release */

extern adv_entry *dvmrp_int_policy;	/* DVMRP control info */

/*
 * Timer declarations
 */

#define NEIGHBOR_PROBE_INTERVAL	10	/* periodic neighbor probing */
#define NEIGHBOR_PROBE_OFFSET	1	/* initial neighbor probing */
#define NEIGHBOR_EXPIRE_TIME	140	/* neighbor timeout */

#define DVMRP_T_PROBE		10	/* periodic neighbor probe */
#define DVMRP_T_UPDATE		60	/* periodic route report interval */
#define DVMRP_T_EXPIRE		140	/* time to delete active route */
#define DVMRP_T_HOLDDOWN	60	/* holddown period */
#define	DVMRP_T_MAX	(time_t) 5
#define	DVMRP_T_MIN	(time_t) 1
#define	DVMRP_T_FLASH	(time_t) (grand((u_int32) (DVMRP_T_MAX - DVMRP_T_MIN + 1)) + DVMRP_T_MIN)
					/* Number of updates per holddown */
#define	DVMRP_HOLDCOUNT		(DVMRP_T_HOLDDOWN/DVMRP_T_UPDATE)

#define	DVMRPTF_POLL		TARGETF_USER1	/* Target has been polled */
#define	DVMRPTF_TUNNEL		TARGETF_USER2	/* Target is a tunnel */
/*
 * tracing declarations
 */

#define	TR_DVMRP_INDEX_PACKETS		0	/* All packets */
#define	TR_DVMRP_INDEX_PROBE		1	/* Probe packets */
#define	TR_DVMRP_INDEX_REPORT		2	/* Report packets */
#define	TR_DVMRP_INDEX_ASK_NBRS		3	/* Ask Nbr packets */
#define	TR_DVMRP_INDEX_NBRS		4	/* Nbr packets */
#define	TR_DVMRP_INDEX_ASK_NBRS2	5	/* New Ask Nbr packets */
#define	TR_DVMRP_INDEX_NBRS2		6	/* New Nbr packets */
#define	TR_DVMRP_INDEX_PRUNE		7	/* Prune packets */
#define	TR_DVMRP_INDEX_GRAFT		8	/* Graft packets */
#define	TR_DVMRP_INDEX_GRAFT_ACK	9	/* Graft Ack packets */

#define	TR_DVMRP_DETAIL_PROBE		TR_DETAIL_1
#define	TR_DVMRP_DETAIL_REPORT		TR_DETAIL_2
#define	TR_DVMRP_DETAIL_ASK_NBRS	TR_DETAIL_3
#define	TR_DVMRP_DETAIL_NBRS		TR_DETAIL_3
#define	TR_DVMRP_DETAIL_ASK_NBRS2	TR_DETAIL_3
#define	TR_DVMRP_DETAIL_NBRS2		TR_DETAIL_3
#define	TR_DVMRP_DETAIL_PRUNE		TR_DETAIL_4
#define	TR_DVMRP_DETAIL_GRAFT		TR_DETAIL_5
#define	TR_DVMRP_DETAIL_GRAFT_ACK	TR_DETAIL_5

extern trace *dvmrp_trace_options;	/* DVMRP tracing configuration */
extern const bits dvmrp_trace_types[];	/* List of DVMRP specific trace flags */

/*
 * defines used by parser
 */

#define	DVMRP_ENABLED		0x01	/* DVMRP protocol status bit */

extern int dvmrp_config_status;		/* if DVMRP is enabled in new config */

/* Values for dvmrp_flags */
#define DVMRPF_ON         BIT(0x01)   /* DVMRP is enabled */
#define DVMRPF_BROADCAST  BIT(0x02)   /* Broadcast to all interfaces */
#define DVMRPF_FLASHDUE   BIT(0x04)   /* Flash update due when time expires */
#define DVMRPF_NOFLASH    BIT(0x08)   /* No flash update until normal update */
#define DVMRPF_RECONFIG   BIT(0x10)   /* In the process of reconfiguration */

#define	INADDR_DVMRP_GROUP		0xe0000004	/* 224.0.0.4 */

#define	DVMRP_HOP			1	/* Min hop count passing thru */
#define	DVMRP_LIMIT_METRIC		1, 0xffff
#define	DVMRP_LIMIT_THRESHOLD		1, 0xff
#define	DVMRP_LIMIT_RATE		1, 0xffffffff

#define	DVMRP_CONFIG_ENABLE		1
#define	DVMRP_CONFIG_DISABLE		2
#define	DVMRP_CONFIG_METRIC		3
#define	DVMRP_CONFIG_THRESHOLD		4
#define	DVMRP_CONFIG_RATELIMIT		5
#define	DVMRP_CONFIG_MAX		6

extern adv_entry *dvmrp_int_policy;		/* DVMRP control info */

#define	DVMRP_MAX_REPORT 		8192
#define DVMRP_UNREACHABLE		32
#define DVMRP_CACHE_TIMEOUT		300
#define DVMRP_PRUNE_TIMEOUT		180
#define DVMRP_TUNNEL_RATELIMIT		500
#define DVMRP_GRAFT_RETRANS_TIMEOUT	5


/*
 * DVMRP Neighbor list (per interface)
 */

typedef struct _nbr_list {
    struct _nbr_list *dr_forw, *dr_back;	/* DR list */
    struct _nbr_list *tq_forw, *tq_back;	/* timer queue list */
    sockaddr_un *nbr_addr;			/* Router address */
    time_t refresh_time;			/* Time of last refresh */
    flag_t nbr_flags;				/* neighbor specific flags */
    flag_t cap_flags;				/* last capability flags */
    u_int32 genid;				/* last genid received */
    gw_entry *gwp;				/* gateway ptr for route */
    if_addr *ifap;				/* interface nbr is on */
} nbr_list;

/*
 * DVMRP Route Change list
 */

typedef struct _dvmrp_rt_list {
    struct _dvmrp_rt_list *rtl_next;		/* Pointer to next on chain */
    struct _dvmrp_rt_list *rtl_root;		/* Pointer to root of list */
    rt_entry *rtl_rt;
} dvmrp_rt_list;

typedef struct _dvmrp_td_entry {
    struct _dvmrp_td_entry *left;
    struct _dvmrp_td_entry *right;
    u_int32 dvmrp_tree_mask;			/* Bit to test */
    u_int32 dvmrp_tree_key;			/* Address, host byte order */
    u_short	td_flags;
    u_short	td_metric;
    rt_entry	*td_rt;
} dvmrp_td_entry;

typedef struct _dvmrp_target {
    struct _dvmrp_target *target_forw;	/* Pointer to the next one */
    struct _dvmrp_target *target_back;	/* Pointer to the last one */
    sockaddr_un	**target_dst;		/* Destination */
    sockaddr_un	**target_src;		/* Source */
    if_addr	*target_ifap;		/* Interface */
    gw_entry	*target_gwp;		/* Gateway if available */
    flag_t	target_flags;		/* Protocol dependent flags */
    int		target_td_count[sizeof(u_int32) * NBBY];
    dvmrp_td_entry	*target_td_head[sizeof(u_int32) * NBBY];
} dvmrp_target;

extern block_t dvmrp_td_block_index;

PROTOTYPE(dvmrp_init,
	  extern void,
	  (void));
PROTOTYPE(dvmrp_var_init,
	  extern void,
	  (void));
PROTOTYPE(dvmrp_parse_tunnel,
	  extern int,
	  (sockaddr_un *,
	   if_addr_entry *,
	   config_entry *cp,
	   char *));
PROTOTYPE(dvmrp_rt_add,
	  rt_entry *,
	  (rt_parms *));
PROTOTYPE(dvmrp_flash,
	  void,
	  (task *,
	   struct _dvmrp_rt_list *));
PROTOTYPE(dvmrp_td_delete,
	  void,
	  (dvmrp_target *,
	   dvmrp_td_entry *));
PROTOTYPE(dvmrp_td_add,
	  dvmrp_td_entry *,
	  (dvmrp_target *,
	   rt_entry *));
PROTOTYPE(dvmrp_td_locate,
	  dvmrp_td_entry *,
	  (dvmrp_target *,
	   rt_head *));

#endif
