/*
 * Public Release 3
 * 
 * $Id: bgp4mp_sock.h,v 1.1.2.4 1999/01/25 21:13:18 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/* macros to select IPv6 address given pointer to a struct sockaddr */

#define	sock2bgp6(x)	((x)->bgp6.bgp6_addr)
#define	sock2bgpll6(x)	((x)->bgp6.bgp6_lladdr)
#define	sock2bgppt6(x)	((x)->bgp6.bgp6_port)
#define	sock2bgpfl6(x)	((x)->bgp6.bgp6_flowinfo)

#define	sockclear_bgp6(x)	\
	bzero((void_t)(x), sizeof ((x)->bgp6)); \
	socktype(x) = AF_INET6; \
	socksize(x) = sizeof ((x)->bgp6);

#define	bgp6_promote(x)	\
	bzero((void_t)&sock2bgpll6(x), sizeof(sock2bgpll6(x))); \
	socksize(x) = sizeof ((x)->bgp6);

#define	sockaddrcmp_bgp6(x, y)	\
	(SAME_ADDR6(sock2bgp6(x), sock2bgp6(y)))

#define	sockcmp_bgp6(x, y)	\
	(sock2bgppt6(x) == sock2bgppt6(y) && \
	 SAME_ADDR6(sock2bgp6(x), sock2bgp6(y)) && \
	 SAME_ADDR6(sock2bgpll6(x), sock2bgpll6(y)))

#define	bgp6_addrcmp_mask(a, b, m)	\
		((!((((int *)&a)[0] ^ ((int *)&b)[0]) & ((int *)&m)[0])) && \
		 (!((((int *)&a)[1] ^ ((int *)&b)[1]) & ((int *)&m)[1])) && \
		 (!((((int *)&a)[2] ^ ((int *)&b)[2]) & ((int *)&m)[2])) && \
		 (!((((int *)&a)[3] ^ ((int *)&b)[3]) & ((int *)&m)[3])))

#define	is_valid_bgp6(x)	\
	((x)->bgp6.bgp6_lladdr.s6_addr[0] != 0)
#define	is_invalid_bgp6(x)	\
	((x)->bgp6.bgp6_lladdr.s6_addr[0] == 0)
#define	mk_valid_bgp6(x)	\
	((x)->bgp6.bgp6_lladdr.s6_addr[0] = 0xfe)
#define	mk_invalid_bgp6(x)	\
	((x)->bgp6.bgp6_lladdr.s6_addr[0] = 0)

/*
 * Routines in bgp4+.c
 */

PROTOTYPE(bgp6_fill_ll,
	  int,
	  (sockaddr_un *,
	   if_addr *));
PROTOTYPE(bgp6_share_if,
	  int,
	  (sockaddr_un *,
	   sockaddr_un *,
	   if_addr *));

