/*
 * GateD Releases Unicast, Multicast, IPv6, RSd
 * 
 * Copyright (c) 1996,1997,1998,1999 
 * The Regents of the University of Michigan.
 * All Rights Reserved.
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit Network, Inc. at the 
 * University of Michigan.
 * 
 * Merit GateD Consortium
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE FUNCTIONS 
 * CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR THAT 
 * OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for any special, 
 * indirect, incidental or consequential damages with respect to any claim 
 * by Licensee or any third party arising from use of the software. 
 * GateD was originated and developed through release 3.0 by Cornell 
 * University and its collaborators.
 * 
 * Please send questions or comments to gated-people@gated.org.
 *
 * Please submit bugs, bug fixes, and enhancements using the send-pr(1) 
 * utility or via the web at 
 * www.gated.org/gated-web/support/html/report_prob.html.
 * 
 * ------------------------------------------------------------------------
 *
 *      Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *          All rights reserved.
 *
 *      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 *      EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *      AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *      GateD is based on Kirton's EGP, UC Berkeley's routing
 *      daemon   (routed), and DCN's HELLO routing Protocol.
 *      Development of GateD has been supported in part by the
 *      National Science Foundation.
 *
 * ------------------------------------------------------------------------
 *
 *      Portions of this software may fall under the following
 *      copyrights:
 *
 *      Copyright (c) 1988 Regents of the University of California.
 *      All rights reserved.
 *
 *      Redistribution and use in source and binary forms are
 *      permitted provided that the above copyright notice and
 *      this paragraph are duplicated in all such forms and that
 *      any documentation, advertising materials, and other
 *      materials related to such distribution and use
 *      acknowledge that the software was developed by the
 *      University of California, Berkeley.  The name of the
 *      University may not be used to endorse or promote
 *      products derived from this software without specific
 *      prior written permission.  THIS SOFTWARE IS PROVIDED
 *      ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 *      INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * __END_OF_COPYRIGHT__
 */

#if defined(PROTO_MPBGP6)
#if !defined(__MPBGP6_H__)
#define __MPBGP6_H__

/* Flags for supporting import/export of v6 routes */
#define BGPF_IMPORT_V6_MP	0x1000
#define BGPF_EXPORT_V6_MP	0x2000

#define BGPC_MP_V6_UNI          0x20    /* Use MP attrs for V6 Unicast */
#define BGPC_MP_V6_MULTI        0x40    /* Use MP attrs for V6 Multicast */
#define BGPC_MP_V6_UNI_MULTI    0x80    /* Use MP attrs for V6 Uni & Multi */

#define RT_FAM(rt) \
	socktype((rt)->rt_head->rth_dest)

#define RT_PREFIX_MASK(rt, bclen) \
	do { \
		rt_entry * Xrt; \
		Xrt = (rt); \
		switch (socktype(Xrt->rt_dest_mask)) { \
		case AF_INET: \
			(bclen) = inet_prefix_mask(Xrt->rt_dest_mask); \
			break; \
		case AF_INET6: \
			(bclen) = inet6_prefix_mask(Xrt->rt_dest_mask); \
			break; \
		default: \
			assert(FALSE); \
		} \
	} while (0)

/*
 * A macro for sorting peer addresses for snmp purposes.
 */

#define BGPSORT_ADDRv6(addr, word) \
	htonl(((u_int32 *)&(sock2in6(addr)))[(word)])
#define BGPSORT_LT(p1, addr, p2) \
        ((socktype((addr)) < socktype((p2)->bgp_addr)) ? TRUE: \
            ((socktype((addr)) > socktype((p2)->bgp_addr)) ? FALSE: \
            ((socktype((addr)) == AF_INET) ? BGPSORT_LTv4(p1, addr, p2) : \
            ((socktype((addr)) != AF_INET6) ? FALSE : \
            ((BGPSORT_ADDRv6(addr, 0) < BGPSORT_ADDRv6((p2)->bgp_addr, 0)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 0) > BGPSORT_ADDRv6((p2)->bgp_addr, 0)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 1) < BGPSORT_ADDRv6((p2)->bgp_addr, 1)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 1) > BGPSORT_ADDRv6((p2)->bgp_addr, 1)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 2) < BGPSORT_ADDRv6((p2)->bgp_addr, 2)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 2) > BGPSORT_ADDRv6((p2)->bgp_addr, 2)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 3) < BGPSORT_ADDRv6((p2)->bgp_addr, 3)) \
                ?  TRUE : \
            ((BGPSORT_ADDRv6(addr, 3) > BGPSORT_ADDRv6((p2)->bgp_addr, 3)) \
                ?  TRUE : \
            (((p1)->bgp_peer_as < (p2)->bgp_peer_as) ? TRUE : \
            (((p1)->bgp_peer_as > (p2)->bgp_peer_as) ? FALSE: \
            (((p1)->bgp_local_as < (p2)->bgp_local_as) ? TRUE: \
		FALSE)))))))))))))))

#define BGP_NH_SIZE(fam) \
	(((fam) == AF_INET) ? sizeof(struct in_addr) : \
	    (((fam) == AF_INET6) ? sizeof(struct in6_addr) : 0))

int mpbgp6_add_v6_mp_caps(bgpPeer *, byte **);
int mpbgp6_get_capabilities(bgpPeer *, flag_t);

#endif /* !defined(__MPBGP6_H__) */
#endif /* defined(PROTO_MPBGP6) */
