typedef struct _cm_var_t {
	size_t	v_ref;
	void	*v_data;
} cm_var_t;

typedef GQ_HEAD(, _cm_scope_t) cm_scope_list;
struct _cm_scope_t {
	GQ_LINK(_cm_scope_t) cs_link;	/* link into parent scopes */
	cm_scope_t 	cs_parent;	/* parent scope */
	const char	*cs_name;	/* name of this scope */
	cm_scope_list_t	cs_list;	/* child scopes */
	cm_free_t	cs_free;	/* called to free vars */
	cm_changed_t	cs_changed;	/* called when var changes */
	size_t		cs_nvar;	/* number of vars */
	cm_var_t	**cs_vars;	/* block of vars */
};

#define	var_decref(s, v, id) do {			\
	if (--(v)->v_ref == 0 && (s)->cs_free)		\
		(*(s)->cs_free)(id, (v)->v_data);	\
	} while (0)
#define	var_incref(v)	(++(v)->v_ref)

static block_t scope_block; 
static cm_scope_list_t scope_list;

void
cm_scope_init(void)
{
	GQ_INIT(&scope_list);
	cm_scope_block = task_block_init(sizeof(struct _cm_scope_t),
	    "cm_scope_t");
}

void
cm_scope_terminate(void)
{
	/* XXX */
}

cm_scope_t
cm_scope_delete(cm_scope_t scope)
{
	cm_scope_t *child, *nchild;
	cm_var_t *v, *ev;
	cm_id_t id;

	/* delete subscopes */
	for (child = GQ_FIRST(&scope->cs_list); child; child = nchild) {
		nchild = GQ_NEXT(child, cs_link);
		cs_scope_delete(child);
	}

	/* unlink from parent */
	GQ_REMOVE(scope, cs_link);

	/* free variables */
	v = scope->cs_vars;
	ev = v + scope->cs_nvar;
	for (id = 0; v < ev; ++v, ++id)
		if (*v)
			var_decref(scope, *v, id);
		
	task_mem_free(0, scope->cs_name);
	task_mem_free(0, scope->cs_vars);
	task_block_free(cm_scope_block, scope);
}

static cm_scope_t
scope_create(const char *name, cm_id_t maxids, cm_free_t frfunc,
    cm_changed_t chfunc)
{
	cm_scope_t scope;

	scope = task_block_alloc(cm_scope_block);
	scope->cs_name = task_mem_strdup(0, name);
	/* XXX eventually we should just create scopes with items at end */
	scope->cs_items = taks_mem_malloc(0, maxids * sizeof(cm_item_t *));
	scope->cs_nitem = maxids;
	scope->cs_free = frfunc;
}

cm_scope_t
cm_scope_create(const char *name, cm_id_t maxids, cm_free_t frfunc,
     ch_changed_t chfunc)
{
	cm_scope_t scope;

	scope = scope_create(name, maxids, frfunc, chfunc);

	/* link into global list */
	GQ_ADDHEAD(&scope_list, scope, cs_link);
}

cm_scope_t
cm_scope_create_sub(cm_scope_t parent, const char *name, cm_changed_t chfunc)
{
	cm_scope_t scope;
	cm_var_t *v, *ev;

	scope = scope_create(name, parent->cs_nvar, name, chfunc,
	    parent->cs_free);
	GQ_ADDHEAD(&parent->cs_list, scope, cs_link);
	scope->cs_parent = parent;
	/* copy?? */
}

const char *
cm_scope_get_name(cm_scope_t scope)
{
	return (scope->cs_name);
}

cm_scope_t
cm_scope_get_parent(cm_scope_t scope)
{
	return (scope->cs_parent);
}

void
cm_scope_delete(cm_scope_t scope)
{
	/* XXX */
}

void *
cm_get_data(cm_scope_t scope, cm_id_t id)
{
}

void
cm_set_data(cm_scope_t scope, cm_id_t id, void *data)
{
}

int cm_var_is_set(cm_scope_t, cm_id_t);
void *cm_var_get(cm_scope_t, cm_id_t);
void cm_var_set(cm_scope_t, cm_id_t, void *);
void cm_var_unset(cm_scope_t, cm_id_t);
