/*
 * Gated Release 4.x, 5.x, 6.x, 7.x
 * 
 * $Id: mpbgp6.c,v 1.3 2000/05/08 20:17:01 mrr Exp $
 */

/*
 * GateD Releases Unicast, Multicast, IPv6, RSd
 * 
 * Copyright (c) 1996,1997,1998,1999 
 * The Regents of the University of Michigan.
 * All Rights Reserved.
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit Network, Inc. at the 
 * University of Michigan.
 * 
 * Merit GateD Consortium
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE FUNCTIONS 
 * CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR THAT 
 * OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for any special, 
 * indirect, incidental or consequential damages with respect to any claim 
 * by Licensee or any third party arising from use of the software. 
 * GateD was originated and developed through release 3.0 by Cornell 
 * University and its collaborators.
 * 
 * Please send questions or comments to gated-people@gated.org.
 *
 * Please submit bugs, bug fixes, and enhancements using the send-pr(1) 
 * utility or via the web at 
 * www.gated.org/gated-web/support/html/report_prob.html.
 * 
 * ------------------------------------------------------------------------
 *
 *      Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *          All rights reserved.
 *
 *      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 *      EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *      AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *      GateD is based on Kirton's EGP, UC Berkeley's routing
 *      daemon   (routed), and DCN's HELLO routing Protocol.
 *      Development of GateD has been supported in part by the
 *      National Science Foundation.
 *
 * ------------------------------------------------------------------------
 *
 *      Portions of this software may fall under the following
 *      copyrights:
 *
 *      Copyright (c) 1988 Regents of the University of California.
 *      All rights reserved.
 *
 *      Redistribution and use in source and binary forms are
 *      permitted provided that the above copyright notice and
 *      this paragraph are duplicated in all such forms and that
 *      any documentation, advertising materials, and other
 *      materials related to such distribution and use
 *      acknowledge that the software was developed by the
 *      University of California, Berkeley.  The name of the
 *      University may not be used to endorse or promote
 *      products derived from this software without specific
 *      prior written permission.  THIS SOFTWARE IS PROVIDED
 *      ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 *      INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * __END_OF_COPYRIGHT__
 */

#include "include.h"
#if defined(PROTO_MPBGP6)
#include "inet4core/inet.h"
#include "inet6core/inet6.h"
#include "mpbgp/mpbgp_proto.h"
#include "mpbgp/mpbgp.h"
#include "mpbgp6/mpbgp6.h"
#include "mpbgp6/mpbgp6_proto.h"
#include "bgp/bgp_var.h"

/*
 * Add mp-capabilities for IPv6.  There is no way, at present, to not include
 * both unicast and multicast.
 */
int
mpbgp6_add_v6_mp_caps(bgpPeer *bnp, byte **cp)
{
	int len;

	len = 0;
	if (BIT_TEST(bnp->bgp_options, BGPO_EXPORT_V6_MP|BGPO_IMPORT_V6_MP)
	    && !BIT_TEST(bnp->bgp_hiscaps, BGPC_NO_MPEX)) {
		BGP_PUT_SHORT(AF_INET6, *cp);
		BGP_PUT_BYTE(0, *cp);
		BGP_PUT_BYTE(PA4MP_SAFI_UNI_MULTI, *cp);
		len += 4;
	}
	return len;
}

/*
 * Pull out the v6 capabilities we received and put them on the peer
 */
int
mpbgp6_get_capabilities(bgpPeer *bnp, flag_t capabilities)
{
        if (BIT_TEST(capabilities, BGPC_MP_V6_MULTI|BGPC_MP_V6_UNI_MULTI)) {
                if (!BIT_TEST(bnp->bgp_options, BGPO_IMPORT_V6_MP|
                    BGPO_EXPORT_V6_MP)) {
                        byte caps[6], *cptr = caps;

                        BGP_PUT_BYTE(BGPCC_MP_EXT, cptr);
                        BGP_PUT_BYTE(4, cptr);
                        BGP_PUT_SHORT(AF_INET6, cptr);
                        BGP_PUT_BYTE(0, cptr);
                        if (BIT_TEST(capabilities, BGPC_MP_V4_MULTI)) {
                                BGP_PUT_BYTE(PA4MP_SAFI_MULTI, cptr);  
                        } else {      
                                BGP_PUT_BYTE(PA4MP_SAFI_UNI_MULTI, cptr);
                        }
                        bgp_send_notify(bnp, BGP_ERR_OPEN, BGP_ERROPN_BADCAP,  
                            caps, sizeof(caps));
                        bgp_peer_close(bnp, BGPEVENT_RECVOPEN);
                        return 1;     
                }
                if (BIT_TEST(bnp->bgp_options, BGPO_EXPORT_V6_MP)) {   
                        BIT_SET(bnp->bgp_flags, BGPF_EXPORT_V6_MP);    
                } else {
                        BIT_RESET(bnp->bgp_flags, BGPF_EXPORT_V6_MP);  
                }
                if (BIT_TEST(bnp->bgp_options, BGPO_IMPORT_V6_MP)) {   
                        BIT_SET(bnp->bgp_flags, BGPF_IMPORT_V6_MP);    
                } else {
                        BIT_RESET(bnp->bgp_flags, BGPF_IMPORT_V6_MP);  
                }
        }
	return 0;
}

#endif /* defined(PROTO_MPBGP6) */
