/*
 * Public Release 3
 * 
 * $Id: inet6.h,v 1.5 2000/02/21 18:03:14 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#define IPV6_MAXHDRLEN  40     /* ipv6 header length is fixed at 40 bytes  */

#ifdef NO_CMSG_SPACE
#define CMSG_LEN(l)   (_CMSG_ALIGN(sizeof(struct cmsghdr)) + (l))
#define CMSG_SPACE(l) (_CMSG_ALIGN(sizeof(struct cmsghdr)) + _CMSG_ALIGN(l)) 
#endif

/* REALLY ugly Solaris hack */
#ifdef	SUNOS5_0
#include	<netinet/in.h>
/* Unaligned IPv6 header */
typedef struct ipv6h_s {
	u_char  ipv6h_vers_and_flow[4]; /* vers # in hi 4 bits, rest flow */
	u_char  ipv6h_length[2];
	u_char  ipv6h_nexthdr;
	u_char  ipv6h_hoplimit;
	u_char  ipv6h_src[16];
	u_char  ipv6h_dst[16];
} ipv6h_t;
#endif	/* SUNOS5_0 */

/* kernel depended macros */
#ifdef NEED_LESS_ADDR6
static inline
if_addr *LLIF_WITHINDEX(_ifindex)
     u_int _ifindex;
{ 
    if_addr     *ifap; 
    IF_ADDR(ifap) { 
	if ((ifap->ifa_link->ifl_index == _ifindex) 
	    && (ifap->ifa_addr_local->in6.gin6_family == AF_INET6) 
	    && (IS_LINKLADDR6(ifap->ifa_addr_local->in6.gin6_addr))) { 
	    return ifap;
	} 
    } IF_ADDR_END(ifap); 
    return NULL;
}

static inline
if_addr *IF_WITHINDEX(_ifindex)
     u_int _ifindex;
{   
    if_addr     *ifap;
    IF_ADDR(ifap) {
        if ((ifap->ifa_link->ifl_index == _ifindex)
         && (ifap->ifa_addr_local->in6.gin6_family == AF_INET6)
         && (!IS_LINKLADDR6(ifap->ifa_addr_local->in6.gin6_addr))) {
            return ifap;
        }
    } IF_ADDR_END(ifap);
	return NULL;
}
#endif /* NEED_LESS_ADDR6 */

#ifdef PROTO_INET6
/*
 * XXX these should probably go away and we should use the std versions 
 * that they define to -- everyong has them
 */
#ifndef IS_ANYADDR6
#define IS_ANYADDR6(a) IN6_IS_ADDR_UNSPECIFIED(&(a))
#endif
#ifndef IS_LINKLADDR6
#define IS_LINKLADDR6(a) IN6_IS_ADDR_LINKLOCAL(a)
#endif
#ifndef IS_MULTIADDR6
#define IS_MULTIADDR6(a) IN6_IS_ADDR_MULTICAST(a)
#endif
#ifndef SAME_ADDR6
#define SAME_ADDR6(a,b) IN6_ARE_ADDR_EQUAL(&(a), &(b))
#endif

#define PUT_IFINDEX_ADDR6(a, index) do  {  \
			/* XXX should this be htons()?? */	\
			u_int16 lla_index = (index); \
			u_int8  *lptr = (u_int8 *)&lla_index; \
		 	(a).s6_addr[2] = *lptr++; \
	         	(a).s6_addr[3] = *lptr;	\
    } while (0)  

#define GET_IFINDEX_ADDR6(a)	((a).s6_addr[2] << 16 | (a).s6_addr[3])

#endif /* PROTO_INET6 */

/* macros to select IPv6 address given pointer to a struct sockaddr */

/* clear and init a sockaddr_un for Inet use */
#define	sock2in6(x)	((x)->in6.gin6_addr)
#define	sock2port6(x)	((x)->in6.gin6_port)
#define	sock2flow6(x)	((x)->in6.gin6_flowinfo)
#define	sockclear_in6(x)	\
			bzero((void_t)(x), sizeof ((x)->in6)); \
			socktype(x) = AF_INET6; \
    			socksize(x) = sizeof ((x)->in6);
#define	sockaddrcmp_in6(a, b)	(SAME_ADDR6(sock2in6(a), sock2in6(b)))
#define	sockaddrless_in6(a, b)	(LESS_ADDR6(sock2in6(a), sock2in6(b)))
#define	sockcmp_in6(a, b)	(sock2port6(a) == sock2port6(b) && sockaddrcmp_in6(a, b))

#define	sockaddrmask_in6(addr, mask)	do {	\
	((u_int32 *)&sock2in6(addr))[0] &= ((u_int32 *)&sock2in6(mask))[0]; \
	((u_int32 *)&sock2in6(addr))[1] &= ((u_int32 *)&sock2in6(mask))[1]; \
	((u_int32 *)&sock2in6(addr))[2] &= ((u_int32 *)&sock2in6(mask))[2]; \
	((u_int32 *)&sock2in6(addr))[3] &= ((u_int32 *)&sock2in6(mask))[3]; \
	} while (0)

#define	sockmask_in6(addr, mask)	do {				\
				sock2port6(addr) &= sock2port6(mask);	\
				sockaddrmask_in6(addr, mask)		\
	} while (0)

#define	inet6_addrcmp_mask(a, b, m)	\
	((!((((u_int32 *)&a)[0] ^ ((u_int32 *)&b)[0]) & ((u_int32 *)&m)[0])) && \
	 (!((((u_int32 *)&a)[1] ^ ((u_int32 *)&b)[1]) & ((u_int32 *)&m)[1])) && \
	 (!((((u_int32 *)&a)[2] ^ ((u_int32 *)&b)[2]) & ((u_int32 *)&m)[2])) && \
	 (!((((u_int32 *)&a)[3] ^ ((u_int32 *)&b)[3]) & ((u_int32 *)&m)[3])))

#define	SOCKADDR_IN6_LEN	sizeof (inet6_addr_default->in6)
#ifdef	PROTO_BGP4MP
#define	SOCKADDR_BGP6_LEN	sizeof (inet6_addr_default->bgp6)
#endif	/* PROTO_BGP4MP */

/* additional definitions to netinet/in.h */

#ifndef IPPROTO_OSPF
#define IPPROTO_OSPF 89
#endif	/* IPPROTO_OSPF */

extern int inet6_ipforwarding;		/* IPv6 forwarding engine enabled */

extern const bits inet6_proto_bits[];	/* Protocol types */

/* Common addresses */
extern sockaddr_un *inet6_addr_default;
extern sockaddr_un *inet6_addr_loopback;
extern sockaddr_un *inet6_addr_any;
extern sockaddr_un *inet6_addr_reject;
extern sockaddr_un *inet6_addr_blackhole;
extern sockaddr_un *inet6_addr_allnodes;
extern sockaddr_un *inet6_addr_allrouters;

#define	inet6_mask_default	inet6_masks[INET6_MASK_DEFAULT]
#define	inet6_mask_host		inet6_masks[INET6_MASK_HOST]

extern	sockaddr_un *inet6_masks[];		/* Table of all possible *contiguous* masks */
extern	byte inet6_mask_list[SOCKADDR_IN6_LEN * (sizeof (struct in6_addr) * NBBY + 1)];	/* The actual masks */

#define	INET6_LIMIT_MASKLEN	0, 128

#define	INET6_LIMIT_TTL		1, 255

#define INET6_SCOPE_NONE	0
#define INET6_SCOPE_V4COMPAT	1
#define INET6_SCOPE_GLOBAL	2
#define INET6_SCOPE_LINKLOCAL	3
#define INET6_SCOPE_SITELOCAL	4
#define INET6_SCOPE_MULTICAST	5

/* Masks */
#define	INET6_MASK_DEFAULT	0		/* 0:0:0:0:0:0:0:0 */
#define	INET6_MASK_HOST		128		/* ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff */
#define INET6_NODE_NOMASK			0
#define	INET6_MASK_INVALID	129		/* Oops! */

/* Locate an inet mask given it's prefix length */
#define        inet6_mask_prefix(pfx)   (((u_int)pfx > 128) ? (sockaddr_un *) 0 : inet6_masks[pfx])

/* Calculate the prefix length given a mask */
#define        inet6_prefix_mask(mask) \
	(((byte *) (mask) >= inet6_mask_list && (byte *) (mask) < inet6_mask_list + sizeof inet6_mask_list) \
	? (((byte *) (mask) - inet6_mask_list) / SOCKADDR_IN6_LEN) \
	: (u_int) -1)

extern struct in6_addr inaddr6_hostmask;
extern struct in6_addr inaddr6_empty;

#ifdef IPV6_MULTICAST
extern task *inet6_task;
#endif /* IPV6_MULTICAST */

extern sockaddr_un * inet6_mask_locate(sockaddr_un *);
extern if_addr * inet6_ifwithnet(sockaddr_un *);
extern void inet6_family_init(void);
extern void inet6_var_init(void);
extern void inet6_init(void);
extern void inet6_allrouters_join(if_addr *);
extern void inet6_allrouters_drop(if_addr *);
extern byte inet6_scope_of(sockaddr_un *);
