/*
 * Public Release 3
 * 
 * $Id: bgp4mp_proto.h,v 1.2 2000/01/14 20:55:22 wfs Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef	__BGP4MP_PROTO_H__
#define	__BGP4MP_PROTO_H__		/* nothing */

/*
 *	Protocol definitions for BGP4+.  The stuff in here is related to
 *	the BGP4+ protocol itself and should be independent of gated.
 */

/*
 * The following macro extracts network addresses from the stream.  It
 * is used to decode the end of update messages, and understands that
 * network numbers are stored internally in network byte order.
 */

#define	BGP_GET_ADDR6(addr, cp) \
	do { \
		register byte *Xap; \
		register int i; \
		Xap = (byte *)&(sock2in6(addr)); \
		for (i = 0; i < 16; i++) \
			*Xap++ = *(cp)++; \
	} while (0)

/*
 * These macros, the alternative to the above, extract BGP4+-style
 * address prefixes from the stream.  The bit count is returned
 * by the first, the next couple are for testing (to see if the
 * bitcount is okay and there is space) and the remainder set the
 * address.
 */
#define	BGP_OKAY_BITCOUNT6(bc)	((bc) <= 128)

#define	BGP_GET_PREFIX6(bitcount, addr, cp) \
	do { \
		register byte *Xap; \
		int i, j = BGP_PREFIX_LEN(bitcount); \
		Xap = (byte *)&(sock2in6(addr)); \
		for (i = 0; i < 16; i++) \
			if (i < j) \
				*Xap++ = *(cp)++; \
			else \
				*Xap++ = 0; \
	} while (0)

/*
 * The following puts a network address into the buffer in the
 * form a BGP4+ update message would like.  We know the address
 * is in network byte order already.
 */
#define BGP_PUT_ADDR6(addr, cp) \
   do { \
    register byte *Xap; \
    Xap = (byte *)&(sock2in6(addr)); \
    memcpy(cp, Xap, 16);\
    cp += 16; \
   } while (0)


#define	BGP_PUT_LLADDR6(addr, cp) \
	do { \
		register byte *Xap; \
		register int i; \
		Xap = (byte *)&(sock2bgpll6(addr)); \
		for (i = 0; i < 16; i++) \
			*(cp)++ = *Xap++; \
	} while (0)

/*
 * The following puts an address prefix into the buffer in the
 * format BGP4+ update messages like it, and is the alternative to
 * the above.
 */
#define	BGP_PUT_PREFIX6(bitcount, addr, cp) \
	do { \
		register byte *Xap; \
		register byte Xbc = (byte)(bitcount); \
		register int i = (bitcount + 7) >> 3; \
		*(cp)++ = Xbc; \
		if ((bitcount > 128) || (bitcount <= 0)) \
			break; \
		Xap = (byte *)&(sock2in6(addr)); \
		while (--i >= 0) \
			*(cp)++ = *Xap++; \
	} while (0)
		
#endif				/* __BGP4MP_PROTO_H__ */

