/*
 * Public Release 3
 * 
 * $Id: ripng_internal.h,v 1.3 2000/03/17 09:04:05 naamato Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "ripng.h"

/* ripng_init.c */
extern sockaddr_un *ripng_addr;

/* ripng_targets.c */
extern target ripng_targets;
extern task_timer *ripng_timer_update;
extern task_timer *ripng_timer_expire;
extern task_timer *ripng_timer_garbage;

/* ripng_send.c */

/* ripng_dump.c */
extern const bits ripng_cmd_bits[];

/*  */

#define RIPNG_PORT	521
#define RIPNG_MAXHOPLIM	255

struct ripng {
    u_int8	ripng_command;
    u_int8	ripng_version;
    u_int16	ripng_null16;
};

#define RIPNG_COMMAND_REQUEST		1
#define RIPNG_COMMAND_RESPONSE		2
#define RIPNG_COMMAND_MAX		3

#define RIPNG_VERSION_1			1

struct ripng_netinfo {
    struct in6_addr	ripng_prefix;
    u_int16		ripng_tag;
    u_int8		ripng_prefixlen;
    u_int8		ripng_metric;
};

struct ripng_nexthop {
    struct in6_addr	ripng_nexthop;
    u_int16		ripng_null16;
    u_int8		ripng_null8;
    u_int8		ripng_fill8;
};
    

#define RIPNG_T_UPDATE		(14 + (grand(1000000) % 31)) /* 30+-15sec */
#define RIPNG_T_EXPIRE		180
#define RIPNG_T_GARBAGE_COLLECT	120

#define RIPNGTF_MC	TARGETF_USER1	/* use multicast */
#define RIPNGTF_POLL	TARGETF_USER2	/* already polled */

/*  */
/* ripng_dump.c */
extern void ripng_dump(task *, FILE *);
extern void ripng_trace(trace *,
	   int,
	   if_addr *,
	   sockaddr_un *,
	   register struct ripng *,
	   register size_t,
	   int);
extern void ripng_tsi_dump(FILE *,
	   rt_head *,
	   void_t,
	   const char *);

/* ripng_targets.c */
extern void ripng_ifachange(task *,
	   if_addr *);
extern void ripng_flash(task *,
	   rt_list *);
extern void ripng_expire(task_timer *,
           time_t);
extern void ripng_control_reset(task *,
           if_addr *);

/* ripng_send.c */
extern void ripng_job(task_timer *,
	   time_t);
extern void ripng_supply(target *,
	   sockaddr_un *,
	   flag_t,
	   flag_t,
	   int);
extern void ripng_send(task *,
	   if_addr *,
	   flag_t,
	   sockaddr_un *,
	   struct ripng *,
	   size_t);
int ripng_mc_set(task *,
	   target *);

/* ripng_recv.c */
extern void ripng_recv(task *);
