/*
 * Public Release 3
 * 
 * $Id: krt_ipv6multicast.c,v 1.7 2000/04/11 05:21:17 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */



#define	INCLUDE_IOCTL
#define	INCLUDE_ROUTE
#include "include.h"


#ifdef	PROTO_INET
#include "inet4core/inet.h"
#endif	/* PROTO_INET */
#ifdef	PROTO_INET6
#include "inet6core/inet6.h"
#endif	/* PROTO_INET6 */
#include "krt/krt.h"
#include "krt/krt_var.h"

#ifdef HAVE_LINUX_SOCKIOS_H
#include <linux/sockios.h>
#endif /* HAVE_LINUX_SOCKIOS_H */

typedef struct _krt_multicast6_entry {
    struct _krt_multicast6_entry *kme_forw;
    struct _krt_multicast6_entry *kme_back;
    flag_t kme_flags;
#define	KMEF_INSTALLED	0x01		/* We installed it in the kernel */
#define	KMEF_EXISTS	0x02		/* Not installed by us */
    flag_t kme_refcount;
    sockaddr_un *kme_group;
    sockaddr_un *kme_router;		/* Router it is installed with */
} krt_multicast6_entry;

static krt_multicast6_entry krt_multicast6_entries = { &krt_multicast6_entries, &krt_multicast6_entries } ;

#define	KRT_MC(p)	{ for (p = krt_multicast6_entries.kme_forw; p != & krt_multicast6_entries; p = p->kme_forw)
#define	KRT_MC_END(p)	if (p == &krt_multicast6_entries) p = (krt_multicast6_entry *) 0; }


static const bits krt_multicast6_bits[] = {
    { KMEF_INSTALLED,	"Installed" },
    { KMEF_EXISTS,	"Exists" },
    { 0,		NULL }
} ;




block_t krt_v6mc_block = 0;


static krt_multicast6_entry *
krt_multicast6_create (sockaddr_un *group)
{
    krt_multicast6_entry *kp;

    if (!krt_v6mc_block) {
	krt_v6mc_block = task_block_init(sizeof (*kp), "krt_multicast6_entry");
    }

    kp = (krt_multicast6_entry *) task_block_alloc(krt_v6mc_block);
    INSQUE(kp, krt_multicast6_entries.kme_back);

    kp->kme_group = sockdup(group);

    return kp;
}


static void
krt_multicast6_request (u_int type, krt_multicast6_entry *kp)
{
    krt_parms parms;
    if_addr *ifap = (if_addr *) 0;
    sockaddr_un *router;

    parms.krtp_n_gw = 1;
    parms.krtp_state = 0;
    parms.krtp_protocol = RTPROTO_ANY;
    parms.krtp_ifaps = &ifap;
    parms.krtp_routers = &router;
    
    switch (type) {
    case RTM_ADD:
	router = inet6_addr_loopback;
	(void) krt_change(krt_task,
			  kp->kme_group,
			  inet6_mask_host,
			  (krt_parms *) 0,
			  &parms);

	BIT_SET(kp->kme_flags, KMEF_INSTALLED);
	BIT_RESET(kp->kme_flags, KMEF_EXISTS);
	break;

    case RTM_DELETE:
	router = kp->kme_router ? kp->kme_router : inet6_addr_loopback;
	(void) krt_change(krt_task,
			  kp->kme_group,
			  inet6_mask_host,
			  &parms,
			  (krt_parms *) 0);

	BIT_RESET(kp->kme_flags, KMEF_INSTALLED|KMEF_EXISTS);
	break;

    default:
	assert(FALSE);
    }

    if (kp->kme_router) {
	sockfree(kp->kme_router);
	kp->kme_router = (sockaddr_un *) 0;
    }
}


static void
krt_multicast6_free (krt_multicast6_entry *kp)
{
    if (BIT_TEST(kp->kme_flags, KMEF_INSTALLED)) {
			krt_multicast6_request(RTM_DELETE, kp);
    }
		
    REMQUE(kp);

    sockfree(kp->kme_group);
    task_block_free(krt_v6mc_block, (void_t) kp);
}


void
krt_multicast6_add (sockaddr_un *group)
{
    krt_multicast6_entry *kp;

    KRT_MC(kp) {
  if (sockaddrcmp(group, kp->kme_group)) {
      break;
  }
    } KRT_MC_END(kp);

    if (kp) {
  /* Exists */

  if (BIT_TEST(kp->kme_flags, KMEF_EXISTS)) {
      /* Already exists in kernel */

      /* Delete and reinstall the way we want it */
      krt_multicast6_request(RTM_DELETE, kp);
      krt_multicast6_request(RTM_ADD, kp);
  }
    } else {
  /* Allocate a new one */
  kp = krt_multicast6_create(group);

  /* Install it in kernel */
#if !defined(PROTO_INET6)
  krt_multicast6_request(RTM_ADD, kp);
#endif /* !PROTO_INET6 */
    }

    kp->kme_refcount++;
}

void
krt_multicast6_delete(sockaddr_un *group)
{
    krt_multicast6_entry *kp;

    KRT_MC(kp) {
	if (sockaddrcmp(group, kp->kme_group)) {
	    /* Found it */

	    if (!--kp->kme_refcount) {
		/* Last reference, remove it */

		krt_multicast6_free(kp);
	    }
	    break;
	}
    } KRT_MC_END(kp);
}


int
krt_multicast6_install (sockaddr_un *group, sockaddr_un *router)
{
    krt_multicast6_entry *kp;

    KRT_MC(kp) {
	if (sockaddrcmp(group, kp->kme_group)) {
	    if (BIT_TEST(kp->kme_flags, KMEF_EXISTS)) {
		/* Delete duplicate entries */

		return TRUE;
	    }

	    kp->kme_router = sockdup(router);
	    if (kp->kme_refcount) {
		/* One of ours, fix the router */

		krt_multicast6_request(RTM_DELETE, kp);
		krt_multicast6_request(RTM_ADD, kp);
	    }

	    return FALSE;
	}
    } KRT_MC_END(kp);

    kp = krt_multicast6_create(group);

    kp->kme_router = sockdup(router);
    BIT_SET(kp->kme_flags, KMEF_EXISTS);

    return FALSE;
}


#ifdef	RTM_CHANGE
void
krt_multicast6_change (int type, rt_parms *rtp)
{
    krt_multicast6_entry *kp;
    
    KRT_MC(kp) {
	if (sockaddrcmp(rtp->rtp_dest, kp->kme_group)) {
	    break;
	}
    } KRT_MC_END(kp);

    switch (type) {
    case RTM_DELETE:
    case RTM_OLDDEL:
	if (kp->kme_refcount) {
	    /* We are using this, force it to be reinstalled */

	    krt_multicast6_request(RTM_ADD, kp);
	} else {
	    /* We are not using it, release it */

	    krt_multicast6_free(kp);
	}
	break;

    case RTM_ADD:
    case RTM_OLDADD:
	krt_multicast6_install(rtp->rtp_dest, rtp->rtp_router);
	break;

    case RTM_CHANGE:
	if (kp) {
	    if (kp->kme_refcount > 1) {
		/* We are using this, don't let it change */
		
		krt_multicast6_request(RTM_DELETE, kp);
		krt_multicast6_request(RTM_ADD, kp);
	    }
	} else {
	    /* We don't yet know about it */

	    krt_multicast6_install(rtp->rtp_dest, rtp->rtp_router);
	}
	break;

    default:
	/* Ignore */
	break;
    }
}
#endif	/* RTM_CHANGE */


#ifdef  USE_ZLIB
#undef fprintf
#define fprintf	gzprintf
#endif
void
krt_multicast6_dump (task *tp, FILE *fd)
{
    if (krt_multicast6_entries.kme_forw != &krt_multicast6_entries) {
	krt_multicast6_entry *kp;
	
	(void) fprintf(fd, "\tIP Multicast default interfaces:\n");

	KRT_MC(kp) {
	    (void) fprintf(fd, "\t\t%-15A\trefcount %d  flags <%s>\n",
			   kp->kme_group,
			   kp->kme_refcount,
			   trace_bits(krt_multicast6_bits, kp->kme_flags));
	} KRT_MC_END(kp) ;

	(void) fprintf(fd, "\n");
    }
}
#ifdef  USE_ZLIB
#undef fprintf
#endif
