/*
 * Public Release 3
 * 
 * $Id: icmpv6.h,v 1.6 2000/03/31 17:14:01 chopps Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* older pre-std defines */
#if defined(ICMPV6_MGM_QUERY) && !defined(ICMP6_MEMBERSHIP_QUERY)
#define ICMP6_MEMBERSHIP_QUERY      ICMPV6_MGM_QUERY
#endif

#if defined(ICMPV6_MGM_REPORT) && !defined(ICMP6_MEMBERSHIP_REPORT)
#define ICMP6_MEMBERSHIP_REPORT     ICMPV6_MGM_REPORT
#endif

#if defined(ICMPV6_MGM_REDUCTION) && !defined(ICMP6_MEMBERSHIP_REDUCTION)
#define ICMP6_MEMBERSHIP_REDUCTION  ICMPV6_MGM_REDUCTION
#endif

#ifdef  ICMPV6_PACKET_TOOBIG  
#include <netinet/ip6.h>
#include <netinet/ip6_icmp.h>
#define ICMP6_MEMBERSHIP_QUERY      ICMPV6_MGM_QUERY
#define ICMP6_MEMBERSHIP_REPORT     ICMPV6_MGM_REPORT
#define ICMP6_MEMBERSHIP_REDUCTION  ICMPV6_MGM_REDUCTION
#define ICMP6_DST_UNREACH          ICMPV6_DEST_UNREACH 
#define ICMP6_PACKET_TOO_BIG				ICMPV6_PACKET_TOOBIG 
#define ICMP6_TIME_EXCEEDED        ICMPV6_TIME_EXCEEDED 
#define ICMP6_PARAM_PROB           ICMPV6_PARAMPROB 
#define ND_REDIRECT                ND6_REDIRECT 
#define ICMP6_ECHO_REQUEST         ICMPV6_ECHOREQUEST 
#define ICMP6_ECHO_REPLY            ICMPV6_ECHOREPLY
#define ND_ROUTER_SOLICIT          ND6_ROUTER_SOLICITATION 
#define ND_ROUTER_ADVERT          ND6_ROUTER_ADVERTISEMENT 
#define ND_NEIGHBOR_SOLICIT				ND6_NEIGHBOR_SOLICITATION 
#define ND_NEIGHBOR_ADVERT				ND6_NEIGHBOR_ADVERTISEMENT  

#define mld6_type nadv6_hdr.icmp6_type 
#define mld6_code nadv6_hdr.icmp6_code
#define mld6_cksum  nadv6_hdr.icmp6_cksum
#define mld6_maxdelay nadv6_hdr.icmp6_data16[0]
#define mld6_reserved nadv6_hdr.icmp6_data16[1]
#endif 

#define	ICMPV6_PACKET_MAX	2048	/* Maximum ICMPv6 packet size we expect */
#ifndef ICMP6_MAXTYPE
#define ICMP6_MAXTYPE	141    
#endif

struct icmp6_hdr;

extern task *icmpv6_task;
extern trace *icmpv6_trace_options;
extern const bits icmpv6_trace_types[];
extern void (*icmpv6_methods[256])(task *,
		    sockaddr_un *,
		    sockaddr_un *,
		    struct icmp6_hdr *,
		    size_t);

#ifdef ICMPV6_SEND
int icmpv6_send(struct icmp6_hdr *, size_t, sockaddr_un *, sockaddr_un *,
    if_addr *, flag_t);
#endif

/* Tracing */

#define	TR_ICMPV6_DETAIL_REDIRECT	TR_DETAIL_1
#define	TR_ICMPV6_DETAIL_ROUTER		TR_DETAIL_2
#define	TR_ICMPV6_DETAIL_INFO		TR_DETAIL_3
#define	TR_ICMPV6_DETAIL_ERROR		TR_DETAIL_4

#define	TR_ICMPV6_INDEX_PACKETS		0
#define	TR_ICMPV6_INDEX_REDIRECT	1
#define	TR_ICMPV6_INDEX_ROUTER		2
#define	TR_ICMPV6_INDEX_INFO		3
#define	TR_ICMPV6_INDEX_ERROR		4

#define ICMPV6_PROTO_ND      1
#define ICMPV6_PROTO_MLD     2
   
extern void icmpv6_var_init(void);
extern void icmpv6_init(void);
#if	defined(ICMPV6_SEND)
extern int icmpv6_send(struct icmp6_hdr *,
	   size_t,
	   sockaddr_un *,
	   sockaddr_un *,
	   if_addr *,
	   flag_t);
#endif	/* defined(ICMPV6_SEND) */

