/* protocol initialization routines */

#ifdef PROTO_ASPATHS
void aspath_init(void);
#endif /* PROTO_ASPATHS */

#ifdef PROTO_BGMP
void bgmp_init(void);
void bgmp_var_init(void);
#endif /* PROTO_BGMP */

#if defined(PROTO_BGP) || defined(PROTO_MPBGP)
void bgp_init(void);
void bgp_var_init(void);
# if defined(GATED_MEMBER) && defined(PROTO_SNMP)
void init_bgp_vars(void);
# endif /* GATED_MEMBER && PROTO_SNMP */
#endif /* PROTO_BGP && PROTO_MPBGP */

#if defined(PROTO_BGP4MP)
void bgp4mp_init(void);
void bgp4mp_var_init(void);
#endif /* PROTO_BGP4MP */

#ifdef PROTO_CMU_SNMP
void snmp_init(void);
void snmp_var_init(void);
#endif /* PROTO_CMU_SNMP */

#ifdef PROTO_DVMRP
void dvmrp_init(void);
void dvmrp_var_init(void);
# if defined(PROTO_SNMP)
void init_dvmrp_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_DVMRP */

#ifdef PROTO_EGP
void egp_init(void);
void egp_var_init(void);
# if defined(PROTO_SNMP)
void init_egp_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_EGP */

#ifdef PROTO_GII
void gii_init(void);
void gii_var_init(void);
#endif /* PROTO_GII */

#ifdef PROTO_ICMP
void icmp_init(void);
void icmp_var_init(void);
#endif /* PROTO_ICMP */

#ifdef PROTO_ICMP6
void icmp6_init(void);
void icmp6_var_init(void);
#endif /* PROTO_ICMP6 */

#if defined(PROTO_ICMP) || defined(PROTO_ICMPV6) || defined(KRT_RT_SOCK)
void redirect_var_init(void);
#endif	

/* IF */
void if_init(void);

#ifdef PROTO_IGMP
void igmp_init(void);
void igmp_var_init(void);
# if defined(PROTO_SNMP)
void init_igmp_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_IGMP */

#ifdef PROTO_IGRP
void igrp_init(void);
void igrp_var_init(void);
#endif /* PROTO_IGRP */

#ifdef PROTO_INET
void inet_init(void);
void inet_var_init(void);
#endif /* PROTO_INET */

#ifdef PROTO_INET6
void inet6_init(void);
void inet6_var_init(void);
#endif /* PROTO_INET6 */

#ifdef PROTO_IPX
void ipxrip_init(void);
void ipxrip_var_init(void);
void ipxsap_init(void);
void ipxsap_var_init(void);
#endif /* PROTO_IPX */

#ifdef PROTO_ISIS2
void isis_init(void);
void isis_var_init(void);
#endif /* PROTO_ISIS2 */

#ifdef PROTO_ISO
void iso_init(void);
#endif /* PROTO_ISO */

/* KRT */
void krt_init(void);
void krt_var_init(void);

#ifdef PROTO_MSDP
void msdp_init(void);
void msdp_var_init(void);
# if defined(PROTO_SNMP)
void init_msdp_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_MSDP */

#ifdef IP_MULTICAST_ROUTING
void mbr_init(void);
void mbr_terminate(void);
void mroute_init(void);
void mroute_var_init(void);
# if defined(PROTO_SNMP)
void init_ipMRoute_vars(void);
# endif /* PROTO_SNMP */
#endif /* IP_MULTICAST_ROUTING */

#ifdef PROTO_OSPF
void ospf_init(void);
void ospf_var_init(void);
# if defined(PROTO_SNMP)
void init_ospf_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_OSPF */

#ifdef PROTO_OSPF2
void nospf_init(void);
void nospf_var_init(void);
# if defined(PROTO_SNMP)
void init_nospf_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_OSPF2 */

#ifdef PROTO_PIM
void pim_init(void);
void pim_var_init(void);
#endif /* PROTO_PIM */

#if defined(PROTO_PIMSM) || defined(PROTO_PIM)
# if defined(PROTO_SNMP)
void init_pim_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_PIMSM || PROTO_PIM */

#ifdef PROTO_PIMV6
void pimv6_init(void);
void pimv6_var_init(void);
#endif /* PROTO_PIMV6 */

#ifdef PROTO_RDISC
void rdisc_init(void);
void rdisc_var_init(void);
#endif /* PROTO_RDISC */

#ifdef PROTO_RIP
void rip_init(void);
void rip_var_init(void);
# if defined(PROTO_SNMP)
void init_rip_vars(void);
# endif /* PROTO_SNMP */
#endif /* PROTO_RIP */

#ifdef PROTO_RIPNG
void ripng_init(void);
void ripng_var_init(void);
#endif /* PROTO_RIPNG */

#ifdef  PROTO_SLSP
void slsp_init(void);
void slsp_var_init(void);
# ifdef not_used
	/* XXX slsp MIB not converted to SMUX */
#  if defined(PROTO_SNMP)
void init_slsp_vars(void);
#  endif /* PROTO_SNMP */
# endif /* not_used */
#endif /* PROTO_SLSP */

#ifdef PROTO_SMUX
void smux_init(void);
void smux_var_init(void);
#endif /* PROTO_SMUX */
