/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include <time.h>
#include <fcntl.h>
#include <netdb.h>
#include <memory.h>
#include <string.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stream.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <sys/socket.h>
#include <net/if.h>

#include "slip_var.h"
#include "dp.h"
#include "dp_str.h"

char *sctime(),
     *port_str(),
     *cnts_str();

void
writelog(sitename, dev, starttime, stoptime, ss, req)
char *sitename, *dev;
time_t starttime, stoptime;
struct slipstat *ss;
struct dp_req *req;
{
    static char	WHERE[] = "writelog";
    int		f;
    long	hours;
    long	minutes;
    long	seconds;
    long	duration = stoptime - starttime;
    extern	char *ctime();
    char	lbuf[132+1], *l = lbuf;
    char	*cl;

    /* Just in case... */
    if (starttime == 0)
	return;

    hours = duration / 3600;
    minutes = (duration - hours * 3600) / 60;
    seconds = duration - hours * 3600 - minutes * 60;

    (void)sprintf(l, "%-12.12s%-5.5s %s %02ld:%02ld:%02ld %-7.7s ",
	sitename, dev, sctime(&starttime), hours, minutes, seconds, progname);
    l += strlen(l);

    (void)sprintf(l, "%-11s ", req ? port_str(req) : "");
    l += strlen(l);

    (void)sprintf(l, "I %-12s ",
		  cnts_str(ss->sl_ipackets, ss->sl_ibytes, ss->sl_ierrors));
    l += strlen(l);
    (void)sprintf(l, "O %-12s",
		  cnts_str(ss->sl_opackets, ss->sl_obytes, ss->sl_oerrors));
    l += strlen(l);

    while (*(l-1) == ' ')
	l--;

    *l++ = '\n';

    cl = expand_dir_file("$DPLOG_DIR", CALL_LOG);
    if ((f = open(cl, O_WRONLY|O_APPEND|O_CREAT, 0666)) < 0) {
	d_log(DLOG_DIAG, WHERE, "Can't open call log, %m");
	(void)free(cl);
	return;
    }
    (void)write(f, lbuf, l-lbuf);
    (void)close(f);
    (void)free(cl);
}

char *
cnts_str(pkts, bytes, errs)
u_int pkts, bytes, errs;
{
    static char cbuf[32];
    if (errs)
	(void)sprintf(cbuf, "%d/%d/%d", pkts, bytes, errs);
    else
	(void)sprintf(cbuf, "%d/%d", pkts, bytes);
    return cbuf;
}

char *
sctime(t)
time_t *t;
{
    static char tbuf[24];
    (void)strftime(tbuf, sizeof(tbuf), "%D %T", localtime(t));
    return tbuf;
}

char *
port_str(req)
struct dp_req *req;
{
    struct ip *ip = &req->dr_ip;
    struct protoent *pe;
    struct servent *se;
    char *proto, *port = (char *)0, prbuf[10], ptbuf[10];
    static char pbuf[50];

    if (pe = getprotobynumber((int)ip->ip_p)) {
	proto = pe->p_name;

	switch (ip->ip_p) {
	 case IPPROTO_TCP:
	    {
		struct tcphdr *th;
		int iplen = ip->ip_hl << 2;
		if (req->dr_hdrlen < iplen + 2 * sizeof(u_short))
		    break;
		th = (struct tcphdr *)&((char *)ip)[iplen];
		if ((se = getservbyport((int)th->th_dport, proto)) ||
		    (se = getservbyport((int)th->th_sport, proto)))
		    port = se->s_name;
		else {
		    (void)sprintf(ptbuf, "%d", th->th_dport);
		    port = ptbuf;
		}
	    }
	    break;
	 case IPPROTO_UDP:
	    {
		struct udphdr *uh;
		int iplen = ip->ip_hl << 2;
		if (req->dr_hdrlen < iplen + 2 * sizeof(u_short))
		    break;
		uh = (struct udphdr *)&((char *)ip)[iplen];
		if ((se = getservbyport((int)uh->uh_dport, proto)) ||
		    (se = getservbyport((int)uh->uh_sport, proto)))
		    port = se->s_name;
		else {
		    (void)sprintf(ptbuf, "%d", uh->uh_dport);
		    port = ptbuf;
		}
	    }
	    break;
	}
    }
    else {
	(void)sprintf(prbuf, "%d", ip->ip_p);
	proto = prbuf;
    }

    if (port)
	(void)sprintf(pbuf, "%s/%s", proto, port);
    else
	(void)sprintf(pbuf, "%s", proto);
    return pbuf;
}

/*
 *  Get the packet counts from the interface.
 */
#define	GETIFUINTAR(ifr, i)	(((int *)((ifr).ifr_data))[i])

getpacketcounts(ifnm, ss)
char *ifnm;
struct slipstat *ss;
{
    static char	WHERE[] = "getpacketcounts";
    struct ifreq ifr;
    int s;

    (void)memset((char *)&ifr, 0, sizeof(ifr));
    (void)strcpy(ifr.ifr_name, ifnm);

    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	d_log(DLOG_GENERAL, WHERE, "Can't create socket for \"%s\", %m",
	    ifnm);
	unlock_pid();
	exit(1);
    }
    if (ioctl(s, SIOCGDPIISTATS, (caddr_t)&ifr) < 0) {
	d_log(DLOG_GENERAL, WHERE, "Can't SIOCGDPIISTATS for \"%s\", %m",
	      ifnm);
	unlock_pid();
	exit(1);
    }

    ss->sl_ibytes   = GETIFUINTAR(ifr, 0);
    ss->sl_ipackets = GETIFUINTAR(ifr, 1);
    ss->sl_ierrors  = GETIFUINTAR(ifr, 2);

    if (ioctl(s, SIOCGDPIOSTATS, (caddr_t)&ifr) < 0) {
	d_log(DLOG_GENERAL, WHERE, "Can't SIOCGDPIOSTATS for \"%s\", %m",
	      ifnm);
	unlock_pid();
	exit(1);
    }

    ss->sl_obytes   = GETIFUINTAR(ifr, 0);
    ss->sl_opackets = GETIFUINTAR(ifr, 1);
    ss->sl_oerrors  = GETIFUINTAR(ifr, 2);
    (void)close(s);
}
