/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "configfile.y"

/*
**  A yacc input file for the innfeed config file.
**
**  Written by James Brister <brister@vix.com>
**
**  This file contains the heart of the innfeed configuration parser, written
**  in yacc.  It uses an external lexer generated by flex.
**
**  clang-format does not work off-the-shelf with mixed C and yacc code;
**  if it is run, the "%{" and "%}" lines should be commented so as not
**  to add extra indentation.
*/

#include "portable/system.h"

#include "innfeed.h"
#include <ctype.h>
#include <errno.h>
#include <syslog.h>

#include "inn/libinn.h"
#include "inn/messages.h"

#include "configfile.h"
#include "misc.h"

/* flex does not declare yydebug as static, and uses superfluous breaks. */
#if defined(__llvm__) || defined(__clang__)
# pragma GCC diagnostic ignored "-Wmissing-variable-declarations"
# pragma GCC diagnostic ignored "-Wunreachable-code-break"
#endif

#define UNKNOWN_SCOPE_TYPE "line %d: unknown scope type: %s"
#define SYNTAX_ERROR       "line %d: syntax error"

scope *topScope = NULL;
static scope *currScope = NULL;
char *errbuff = NULL;

static void appendName(scope *s, char *p, size_t len);
static char *valueScopedName(value *v);
static void freeValue(value *v);
static char *checkName(scope *s, const char *name);
static void addValue(scope *s, value *v);
static char *addScope(scope *s, const char *name, scope *val);
static void printScope(FILE *fp, scope *s, int indent);
static void printValue(FILE *fp, value *v, int indent);
static scope *newScope(const char *type);

/* Interface between lexer and parser. */
int yylex(void);

int yyerror(const char *s);
int yywrap(void);

int
getBool(scope *s, const char *name, int *rval, int inherit)
{
    value *v = findValue(s, name, inherit);

    if (v == NULL)
        return 0;
    else if (v->type != boolval)
        return 0;

    *rval = v->v.bool_val;
    return 1;
}


int
getString(scope *s, const char *name, char **rval, int inherit)
{
    value *v = findValue(s, name, inherit);

    if (v == NULL)
        return 0;
    else if (v->type != stringval)
        return 0;

    *rval = xstrdup(v->v.charp_val);
    return 1;
}


int
getReal(scope *s, const char *name, double *rval, int inherit)
{
    value *v = findValue(s, name, inherit);

    if (v == NULL)
        return 0;
    else if (v->type != realval)
        return 0;

    *rval = v->v.real_val;
    return 1;
}

int
getInteger(scope *s, const char *name, long *rval, int inherit)
{
    value *v = findValue(s, name, inherit);

    if (v == NULL)
        return 0;
    else if (v->type != intval)
        return 0;

    *rval = v->v.int_val;
    return 1;
}

void
freeScopeTree(scope *s)
{
    int i;

    if (s == NULL)
        return;

    if (s->parent == NULL && s->me != NULL) { /* top level scope */
        free(s->me->name);
        free(s->me);
    }


    for (i = 0; i < s->value_idx; i++)
        if (s->values[i] != NULL)
            freeValue(s->values[i]);

    free(s->values);
    free(s->scope_type);

    s->parent = NULL;
    s->values = NULL;

    free(s);
}


char *
addInteger(scope *s, const char *name, long val)
{
    value *v;
    char *error;

    if ((error = checkName(currScope, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = intval;
    v->v.int_val = val;

    addValue(s, v);

    return NULL;
}

char *
addChar(scope *s, const char *name, char val)
{
    value *v;
    char *error;

    if ((error = checkName(currScope, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = charval;
    v->v.char_val = val;

    addValue(s, v);

    return NULL;
}

char *
addBoolean(scope *s, const char *name, int val)
{
    value *v;
    char *error;

    if ((error = checkName(currScope, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = boolval;
    v->v.bool_val = val;

    addValue(s, v);

    return NULL;
}

char *
addReal(scope *s, const char *name, double val)
{
    value *v;
    char *error;

    if ((error = checkName(currScope, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = realval;
    v->v.real_val = val;

    addValue(s, v);

    return NULL;
}

char *
addString(scope *s, const char *name, const char *val)
{
    value *v;
    char *error;

    if ((error = checkName(currScope, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = stringval;
    v->v.charp_val = xstrdup(val);

    addValue(s, v);

    return NULL;
}

value *
findValue(scope *s, const char *name, int inherit)
{
    const char *p;

    if (name == NULL || *name == '\0')
        return NULL;

    if (*name == ':')
        return findValue(topScope, name + 1, 0);
    else if (s == NULL)
        return findValue(topScope, name, 0);
    else {
        int i;

        if ((p = strchr(name, ':')) == NULL)
            p = name + strlen(name);

        for (i = 0; i < s->value_idx; i++) {
            if (strlen(s->values[i]->name) == (size_t)(p - name)
                && strncmp(s->values[i]->name, name, p - name) == 0) {
                if (*p == '\0') /* last segment of name */
                    return s->values[i];
                else if (s->values[i]->type != scopeval)
                    errbuff = xstrdup("Component not a scope");
                else
                    return findValue(s->values[i]->v.scope_val, p + 1, 0);
            }
        }

        /* not in this scope. Go up if inheriting values and only if no ':'
           in name */
        if (inherit && *p == '\0')
            return findValue(s->parent, name, inherit);
    }

    return NULL;
}

/* find the scope that name belongs to. If mustExist is true then the name
   must be a fully scoped name of a value. relative scopes start at s. */
scope *
findScope(scope *s, const char *name, int mustExist)
{
    scope *p = NULL;
    char *q;
    int i;


    if ((q = strchr(name, ':')) == NULL) {
        if (!mustExist)
            p = s;
        else
            for (i = 0; p == NULL && i < s->value_idx; i++)
                if (strcmp(s->values[i]->name, name) == 0)
                    p = s;

        return p;
    } else if (*name == ':') {
        while (s->parent != NULL)
            s = s->parent;

        return findScope(s, name + 1, mustExist);
    } else {
        for (i = 0; i < s->value_idx; i++)
            if (strncmp(s->values[i]->name, name, q - name) == 0)
                if (s->values[i]->type == scopeval)
                    return findScope(s->values[i]->v.scope_val, q + 1,
                                     mustExist);
    }

    return NULL;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/


static void
appendName(scope *s, char *p, size_t len)
{
    if (s == NULL)
        return;
    else {
        appendName(s->parent, p, len);
        strlcat(p, s->me->name, len);
        strlcat(p, ":", len);
    }
}

static char *
valueScopedName(value *v)
{
    scope *p = v->myscope;
    int len = strlen(v->name);
    char *q;

    while (p != NULL) {
        len += strlen(p->me->name) + 1;
        p = p->parent;
    }
    len++;

    q = xmalloc(len);
    q[0] = '\0';
    appendName(v->myscope, q, len);
    strlcat(q, v->name, len);

    return q;
}

static void
freeValue(value *v)
{
    free(v->name);
    switch (v->type) {
    case scopeval:
        freeScopeTree(v->v.scope_val);
        break;

    case stringval:
        free(v->v.charp_val);
        break;

    default:
        break;
    }
    free(v);
}

static char *
checkName(scope *s, const char *name)
{
    int i;
    char *error = NULL;

    if (s == NULL)
        return NULL;

    for (i = 0; i < s->value_idx; i++) {
        char *n = NULL;

        if (strcmp(name, s->values[i]->name) == 0) {
            n = valueScopedName(s->values[i]);
            error = concat("Two definitions of ", n, (char *) 0);
            free(n);
            return error;
        }
    }

    return error;
}


static void
addValue(scope *s, value *v)
{
    v->myscope = s;

    if (s == NULL)
        return;

    if (s->value_count == s->value_idx) {
        if (s->values == 0) {
            s->values = (value **) xcalloc(10, sizeof(value *));
            s->value_count = 10;
        } else {
            s->value_count += 10;
            s->values = (value **) xrealloc(s->values,
                                            sizeof(value *) * s->value_count);
        }
    }

    s->values[s->value_idx++] = v;
}


static char *
addScope(scope *s, const char *name, scope *val)
{
    value *v;
    char *error;

    if ((error = checkName(s, name)) != NULL)
        return error;

    v = (value *) xcalloc(1, sizeof(value));
    v->name = xstrdup(name);
    v->type = scopeval;
    v->v.scope_val = val;
    val->me = v;
    val->parent = s;

    addValue(s, v);

    currScope = val;

    return NULL;
}


static void
printScope(FILE *fp, scope *s, int indent)
{
    int i;
    for (i = 0; i < s->value_idx; i++)
        printValue(fp, s->values[i], indent + 5);
}

static void
printValue(FILE *fp, value *v, int indent)
{
    int i;

    for (i = 0; i < indent; i++)
        fputc(' ', fp);

    switch (v->type) {
    case intval:
        fprintf(fp, "%s : %ld # INTEGER\n", v->name, v->v.int_val);
        break;

    case stringval:
        fprintf(fp, "%s : \"", v->name);
        {
            char *p = v->v.charp_val;
            while (*p) {
                if (*p == '"' || *p == '\\')
                    fputc('\\', fp);
                fputc(*p, fp);
                p++;
            }
        }
        fprintf(fp, "\" # STRING\n");
        break;

    case charval:
        fprintf(fp, "%s : %c", v->name, 047);
        switch (v->v.char_val) {
        case '\\':
            fprintf(fp, "\\\\");
            break;

        default:
            if (isprint((unsigned char) v->v.char_val))
                fprintf(fp, "%c", v->v.char_val);
            else
                fprintf(fp, "\\%03o", (unsigned int) v->v.char_val);
        }
        fprintf(fp, "%c # CHARACTER\n", 047);
        break;

    case realval:
        fprintf(fp, "%s : %f # REAL\n", v->name, v->v.real_val);
        break;

    case boolval:
        fprintf(fp, "%s : %s # BOOLEAN\n", v->name,
                (v->v.bool_val ? "true" : "false"));
        break;

    case scopeval:
        fprintf(fp, "%s %s { # SCOPE\n", v->v.scope_val->scope_type, v->name);
        printScope(fp, v->v.scope_val, indent + 5);
        for (i = 0; i < indent; i++)
            fputc(' ', fp);
        fprintf(fp, "}\n");
        break;

    default:
        fprintf(fp, "UNKNOWN value type: %u\n", v->type);
        exit(1);
    }
}


static scope *
newScope(const char *type)
{
    scope *t;
    int i;

    t = (scope *) xcalloc(1, sizeof(scope));
    t->parent = NULL;
    t->scope_type = xstrdup(type);

    for (i = 0; t->scope_type[i] != '\0'; i++)
        t->scope_type[i] = tolower((unsigned char) t->scope_type[i]);

    return t;
}


#define BAD_KEY   "line %d: illegal key name: %s"
#define NON_ALPHA "line %d: keys must start with a letter: %s"

static char *
keyOk(const char *key)
{
    const char *p = key;
    char *rval;

    if (key == NULL) {
        rval = xmalloc(strlen("line : NULL key") + 15);
        sprintf(rval, "line %d: NULL key", lineCount);
        return rval;
    } else if (*key == '\0') {
        rval = xmalloc(strlen("line : EMPTY KEY") + 15);
        sprintf(rval, "line %d: EMPTY KEY", lineCount);
        return rval;
    }

    if (!isalpha((unsigned char) *p)) {
        rval = xmalloc(strlen(NON_ALPHA) + strlen(key) + 15);
        sprintf(rval, NON_ALPHA, lineCount, key);
        return rval;
    }

    p++;
    while (*p) {
        if (!(isalnum((unsigned char) *p) || *p == '_' || *p == '-')) {
            rval = xmalloc(strlen(BAD_KEY) + strlen(key) + 15);
            sprintf(rval, BAD_KEY, lineCount, key);
            return rval;
        }
        p++;
    }

    return NULL;
}

static PFIVP *funcs = NULL;
static void **args = NULL;
static int funcCount;
static int funcIdx;

void
configAddLoadCallback(PFIVP func, void *arg)
{
    if (func == NULL)
        return;

    if (funcIdx == funcCount) {
        funcCount += 10;
        if (funcs == NULL) {
            funcs = xmalloc(sizeof(PFIVP) * funcCount);
            args = xmalloc(sizeof(void *) * funcCount);
        } else {
            funcs = xrealloc(funcs, sizeof(PFIVP) * funcCount);
            args = xrealloc(args, sizeof(void *) * funcCount);
        }
    }

    args[funcIdx] = arg;
    funcs[funcIdx++] = func;
}


void
configRemoveLoadCallback(PFIVP func)
{
    int i, j;

    for (i = 0; i < funcIdx; i++)
        if (funcs[i] == func)
            break;

    for (j = i; j < funcIdx - 1; j++) {
        funcs[j] = funcs[j + 1];
        args[j] = args[j + 1];
    }

    if (funcIdx > 1 && i < funcIdx) {
        funcs[i - 2] = funcs[i - 1];
        args[i - 2] = args[i - 1];
    }

    if (funcIdx > 0 && i < funcIdx)
        funcIdx--;
}


static int
doCallbacks(void)
{
    int i;
    int rval = 1;

    for (i = 0; i < funcIdx; i++)
        if (funcs[i] != NULL)
            rval = (funcs[i](args[i]) && rval);

    return rval;
}


static char *key;
/* clang-format off */

#line 709 "y.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_Y_TAB_H_INCLUDED
# define YY_YY_Y_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    PEER = 258,                    /* PEER  */
    GROUP = 259,                   /* GROUP  */
    IVAL = 260,                    /* IVAL  */
    RVAL = 261,                    /* RVAL  */
    NAME = 262,                    /* NAME  */
    XSTRING = 263,                 /* XSTRING  */
    SCOPE = 264,                   /* SCOPE  */
    COLON = 265,                   /* COLON  */
    LBRACE = 266,                  /* LBRACE  */
    RBRACE = 267,                  /* RBRACE  */
    TRUEBVAL = 268,                /* TRUEBVAL  */
    FALSEBVAL = 269,               /* FALSEBVAL  */
    CHAR = 270,                    /* CHAR  */
    WORD = 271,                    /* WORD  */
    IP_ADDRESS = 272               /* IP_ADDRESS  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define PEER 258
#define GROUP 259
#define IVAL 260
#define RVAL 261
#define NAME 262
#define XSTRING 263
#define SCOPE 264
#define COLON 265
#define LBRACE 266
#define RBRACE 267
#define TRUEBVAL 268
#define FALSEBVAL 269
#define CHAR 270
#define WORD 271
#define IP_ADDRESS 272

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 639 "configfile.y"

    scope *scp;
    value *val;
    char *name;
    int integer;
    double real;
    char *string;
    char chr;

#line 806 "y.tab.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);


#endif /* !YY_YY_Y_TAB_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_PEER = 3,                       /* PEER  */
  YYSYMBOL_GROUP = 4,                      /* GROUP  */
  YYSYMBOL_IVAL = 5,                       /* IVAL  */
  YYSYMBOL_RVAL = 6,                       /* RVAL  */
  YYSYMBOL_NAME = 7,                       /* NAME  */
  YYSYMBOL_XSTRING = 8,                    /* XSTRING  */
  YYSYMBOL_SCOPE = 9,                      /* SCOPE  */
  YYSYMBOL_COLON = 10,                     /* COLON  */
  YYSYMBOL_LBRACE = 11,                    /* LBRACE  */
  YYSYMBOL_RBRACE = 12,                    /* RBRACE  */
  YYSYMBOL_TRUEBVAL = 13,                  /* TRUEBVAL  */
  YYSYMBOL_FALSEBVAL = 14,                 /* FALSEBVAL  */
  YYSYMBOL_CHAR = 15,                      /* CHAR  */
  YYSYMBOL_WORD = 16,                      /* WORD  */
  YYSYMBOL_IP_ADDRESS = 17,                /* IP_ADDRESS  */
  YYSYMBOL_YYACCEPT = 18,                  /* $accept  */
  YYSYMBOL_input = 19,                     /* input  */
  YYSYMBOL_20_1 = 20,                      /* $@1  */
  YYSYMBOL_scope = 21,                     /* scope  */
  YYSYMBOL_entries = 22,                   /* entries  */
  YYSYMBOL_entry = 23,                     /* entry  */
  YYSYMBOL_24_2 = 24,                      /* $@2  */
  YYSYMBOL_25_3 = 25,                      /* $@3  */
  YYSYMBOL_26_4 = 26,                      /* $@4  */
  YYSYMBOL_value = 27                      /* value  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   30

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  18
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  10
/* YYNRULES -- Number of rules.  */
#define YYNRULES  21
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  33

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   272


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   667,   667,   667,   676,   678,   679,   680,   686,   686,
     692,   692,   698,   705,   705,   712,   718,   723,   729,   735,
     740,   745
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "PEER", "GROUP",
  "IVAL", "RVAL", "NAME", "XSTRING", "SCOPE", "COLON", "LBRACE", "RBRACE",
  "TRUEBVAL", "FALSEBVAL", "CHAR", "WORD", "IP_ADDRESS", "$accept",
  "input", "$@1", "scope", "entries", "entry", "$@2", "$@3", "$@4",
  "value", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-12)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-5)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
     -12,     2,   -12,   -12,     0,   -12,   -11,    -9,    -6,   -12,
       1,     3,     4,     8,   -12,   -12,   -12,    14,   -12,   -12,
     -12,   -12,   -12,   -12,   -12,   -12,   -12,   -12,    -1,     5,
      11,   -12,   -12
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     5,     1,     0,     7,     0,     0,    13,     6,
       0,     0,     0,     0,     8,    10,    12,     0,     5,     5,
      16,    19,    20,    17,    18,    21,    15,    14,     0,     0,
       0,     9,    11
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -12,   -12,   -12,     6,    22,   -12,   -12,   -12,   -12,   -12
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     1,     2,    28,    29,     9,    18,    19,    13,    27
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      -3,     5,     3,     6,     7,    10,     5,    11,     6,     7,
      12,    31,    14,     0,    15,    16,     8,    -4,    17,    20,
      21,     8,    22,    32,     4,    30,     0,    23,    24,    25,
      26
};

static const yytype_int8 yycheck[] =
{
       0,     1,     0,     3,     4,    16,     1,    16,     3,     4,
      16,    12,    11,    -1,    11,    11,    16,    12,    10,     5,
       6,    16,     8,    12,     2,    19,    -1,    13,    14,    15,
      16
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    19,    20,     0,    22,     1,     3,     4,    16,    23,
      16,    16,    16,    26,    11,    11,    11,    10,    24,    25,
       5,     6,     8,    13,    14,    15,    16,    27,    21,    22,
      21,    12,    12
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    18,    20,    19,    21,    22,    22,    22,    24,    23,
      25,    23,    23,    26,    23,    27,    27,    27,    27,    27,
      27,    27
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     0,     2,     2,     0,     6,
       0,     6,     3,     0,     4,     1,     1,     1,     1,     1,
       1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 667 "configfile.y"
       {
        lineCount = 1;
        addScope(NULL, "", newScope(""));
        topScope = currScope;
    }
#line 1828 "y.tab.c"
    break;

  case 3: /* input: $@1 entries  */
#line 671 "configfile.y"
              {
        if (!doCallbacks())
            YYABORT;
    }
#line 1837 "y.tab.c"
    break;

  case 7: /* entries: entries error  */
#line 680 "configfile.y"
                    {
        errbuff = xmalloc(strlen(SYNTAX_ERROR) + 12);
        sprintf(errbuff, SYNTAX_ERROR, lineCount);
        YYABORT;
    }
#line 1847 "y.tab.c"
    break;

  case 8: /* $@2: %empty  */
#line 686 "configfile.y"
                        {
        errbuff = addScope(currScope, (yyvsp[-1].name), newScope("peer"));
        free((yyvsp[-1].name));
        if (errbuff != NULL)
            YYABORT;
    }
#line 1858 "y.tab.c"
    break;

  case 9: /* entry: PEER WORD LBRACE $@2 scope RBRACE  */
#line 691 "configfile.y"
                   { currScope = currScope->parent; }
#line 1864 "y.tab.c"
    break;

  case 10: /* $@3: %empty  */
#line 692 "configfile.y"
                        {
        errbuff = addScope(currScope, (yyvsp[-1].name), newScope("group"));
        free((yyvsp[-1].name));
        if (errbuff != NULL)
            YYABORT;
    }
#line 1875 "y.tab.c"
    break;

  case 11: /* entry: GROUP WORD LBRACE $@3 scope RBRACE  */
#line 697 "configfile.y"
                   { currScope = currScope->parent; }
#line 1881 "y.tab.c"
    break;

  case 12: /* entry: WORD WORD LBRACE  */
#line 698 "configfile.y"
                       {
        errbuff = xmalloc(strlen(UNKNOWN_SCOPE_TYPE) + 15 + strlen((yyvsp[-2].name)));
        sprintf(errbuff, UNKNOWN_SCOPE_TYPE, lineCount, (yyvsp[-2].name));
        free((yyvsp[-2].name));
        free((yyvsp[-1].name));
        YYABORT;
    }
#line 1893 "y.tab.c"
    break;

  case 13: /* $@4: %empty  */
#line 705 "configfile.y"
           {
    if ((errbuff = keyOk((yyvsp[0].name))) != NULL) {
        YYABORT;
    } else
        key = (yyvsp[0].name);
    }
#line 1904 "y.tab.c"
    break;

  case 15: /* value: WORD  */
#line 712 "configfile.y"
            {
        if ((errbuff = addString(currScope, key, (yyvsp[0].name))) != NULL)
            YYABORT;
        free(key);
        free((yyvsp[0].name));
    }
#line 1915 "y.tab.c"
    break;

  case 16: /* value: IVAL  */
#line 718 "configfile.y"
           {
        if ((errbuff = addInteger(currScope, key, (yyvsp[0].integer))) != NULL)
            YYABORT;
        free(key);
    }
#line 1925 "y.tab.c"
    break;

  case 17: /* value: TRUEBVAL  */
#line 723 "configfile.y"
               {
        if ((errbuff = addBoolean(currScope, key, 1)) != NULL)
            YYABORT;
        free(key);
        free((yyvsp[0].name));
    }
#line 1936 "y.tab.c"
    break;

  case 18: /* value: FALSEBVAL  */
#line 729 "configfile.y"
                {
        if ((errbuff = addBoolean(currScope, key, 0)) != NULL)
            YYABORT;
        free(key);
        free((yyvsp[0].name));
    }
#line 1947 "y.tab.c"
    break;

  case 19: /* value: RVAL  */
#line 735 "configfile.y"
           {
        if ((errbuff = addReal(currScope, key, (yyvsp[0].real))) != NULL)
            YYABORT;
        free(key);
    }
#line 1957 "y.tab.c"
    break;

  case 20: /* value: XSTRING  */
#line 740 "configfile.y"
              {
        if ((errbuff = addString(currScope, key, (yyvsp[0].string))) != NULL)
            YYABORT;
        free(key);
    }
#line 1967 "y.tab.c"
    break;

  case 21: /* value: CHAR  */
#line 745 "configfile.y"
           {
        if ((errbuff = addChar(currScope, key, (yyvsp[0].chr))) != NULL)
            YYABORT;
        free(key);
    }
#line 1977 "y.tab.c"
    break;


#line 1981 "y.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 751 "configfile.y"

/* clang-format on */

int
yyerror(const char *s)
{
#undef FMT
#define FMT "line %d: %s"

    errbuff = xmalloc(strlen(s) + strlen(FMT) + 20);
    sprintf(errbuff, FMT, lineCount, s);

    return 0;
}

int
yywrap(void)
{
    return 1;
}

extern FILE *yyin;
int yydebug;

#define NO_INHERIT 0


#if !defined(WANT_MAIN)

struct peer_table_s {
    char *peerName;
    value *peerValue;
};

static struct peer_table_s *peerTable;
static int peerTableCount;
static int peerTableIdx;

void
configCleanup(void)
{
    int i;

    for (i = 0; i < peerTableIdx; i++)
        free(peerTable[i].peerName);
    free(peerTable);

    freeScopeTree(topScope);
    free(funcs);
    free(args);
}


int
buildPeerTable(FILE *fp, scope *s)
{
    int rval = 1;
    int i, j;

    for (i = 0; i < s->value_idx; i++) {
        if (ISSCOPE(s->values[i]) && ISPEER(s->values[i])) {
            for (j = 0; j < peerTableIdx; j++) {
                if (strcmp(peerTable[j].peerName, s->values[i]->name) == 0) {
                    logOrPrint(LOG_ERR, fp,
                               "ME config: two peers with the same name: %s",
                               peerTable[j].peerName);
                    rval = 0;
                    break;
                }
            }

            if (j == peerTableIdx) {
                if (peerTableCount == peerTableIdx) {
                    peerTableCount += 10;
                    if (peerTable == NULL)
                        peerTable = xmalloc(sizeof(struct peer_table_s)
                                            * peerTableCount);
                    else
                        peerTable =
                            xrealloc(peerTable, sizeof(struct peer_table_s)
                                                    * peerTableCount);
                }

                peerTable[peerTableIdx].peerName = xstrdup(s->values[i]->name);
                peerTable[peerTableIdx].peerValue = s->values[i];
                peerTableIdx++;
            }
        } else if (ISSCOPE(s->values[i]))
            rval = (buildPeerTable(fp, s->values[i]->v.scope_val) && rval);
    }

    return rval;
}


/* read the config file. Any errors go to errorDest if it is non-NULL,
   otherwise they are syslogged. If justCheck is true then return after
   parsing */
static int inited = 0;
int
readConfig(const char *file, FILE *errorDest, int justCheck, int dump)
{
    scope *oldTop = topScope;
    FILE *fp;
    int rval;

    if (!inited) {
        inited = 1;
        yydebug = (getenv("YYDEBUG") == NULL ? 0 : 1);
        if (yydebug)
            atexit(configCleanup);
    }

    if (file == NULL || strlen(file) == 0 || !fileExistsP(file)) {
        logOrPrint(LOG_ERR, errorDest,
                   "ME config aborting, no such config file: %s",
                   file ? file : "(null)");
        d_printf(1, "No such config file: %s\n", file ? file : "(null)");
        exit(1);
    }

    if ((fp = fopen(file, "r")) == NULL) {
        logOrPrint(LOG_ERR, errorDest, "ME config aborting fopen %s: %s", file,
                   strerror(errno));
        exit(1);
    }

    logOrPrint(LOG_NOTICE, errorDest, "loading %s", file);

    yyin = fp;

    topScope = NULL;

    rval = yyparse();

    fclose(fp);

    if (rval != 0) /* failure */
    {
        freeScopeTree(topScope);
        if (justCheck)
            freeScopeTree(oldTop);
        else
            topScope = oldTop;
        topScope = NULL;

        if (errbuff != NULL) {
            if (errorDest != NULL)
                fprintf(errorDest, "config file error: %s\n", errbuff);
            else
                warn("ME config file error: %s", errbuff);

            free(errbuff);
        }

        return 0;
    }

    if (dump) {
        fprintf(errorDest ? errorDest : stderr, "Parsed config file:\n");
        printScope(errorDest ? errorDest : stderr, topScope, -5);
        fprintf(errorDest ? errorDest : stderr, "\n");
    }

    if (justCheck) {
        freeScopeTree(topScope);
        freeScopeTree(oldTop);

        topScope = NULL;
    } else {
        for (peerTableIdx--; peerTableIdx >= 0; peerTableIdx--) {
            free(peerTable[peerTableIdx].peerName);
            peerTable[peerTableIdx].peerName = NULL;
            peerTable[peerTableIdx].peerValue = NULL;
        }
        peerTableIdx = 0;

        if (!buildPeerTable(errorDest, topScope))
            logAndExit(1, "Failed to build list of peers");
    }

    return 1;
}


value *
getNextPeer(int *cookie)
{
    value *rval;

    if (*cookie < 0 || *cookie >= peerTableIdx)
        return NULL;

    rval = peerTable[*cookie].peerValue;

    (*cookie)++;

    return rval;
}


value *
findPeer(const char *name)
{
    value *v = NULL;
    int i;

    for (i = 0; i < peerTableIdx; i++)
        if (strcmp(peerTable[i].peerName, name) == 0) {
            v = peerTable[i].peerValue;
            break;
        }

    return v;
}

#endif

#if defined(WANT_MAIN)
int
main(int argc, char **argv)
{
    if (yyparse())
        printf("parsing failed: %s\n", errbuff ? errbuff : "NONE");
    else {
        printScope(stdout, topScope, -5);

        if (argc == 3) {
#    if defined(INNFEED_DEBUG)
          printf ("Looking for %s of type %s: ",argv[2],argv[1]) ;
          if (strncmp (argv[1],"int",3) == 0)
            {
              int i = 0 ;

              if (!getInteger (topScope,argv[2],&i))
                printf ("wasn't found.\n") ;
              else
                printf (" %d\n",i) ;
            }
          else if (strncmp (argv[1],"real",4) == 0)
            {
              double d = 0.0 ;

              if (!getReal (topScope,argv[2],&d))
                printf ("wasn't found.\n") ;
              else
                printf (" %0.5f\n",d) ;
            }
#    else
            value *v = findValue(topScope, argv[1], 1);

            if (v == NULL)
                printf("Can't find %s\n", argv[1]);
            else {
                long ival = 987654;

                if (getInteger(v->v.scope_val, argv[2], &ival, 1))
                    printf("Getting %s : %ld", argv[2], ival);
                else
                    printf("Name is not legal: %s\n", argv[2]);
            }
#    endif
        } else if (argc == 2) {
            value *v = findValue(topScope, argv[1], 1);

            if (v == NULL)
                printf("Can't find %s\n", argv[1]);
            else {
                printf("Getting %s : ", argv[1]);
                printValue(stdout, v, 0);
            }
        }
    }

    freeScopeTree(topScope);

    return 0;
}
#endif /* defined (WANT_MAIN) */
