/*  $Revision: 1.12 $
**
**  Net News Reading Protocol server.
*/
#include "configdata.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ctype.h>
#include <sys/file.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "paths.h"
#include "nntp.h"
#include "logging.h"
#include "libinn.h"
#include "clibrary.h"
#include "qio.h"
#include "macros.h"


/*
**  Some convenient shorthands.
*/
typedef struct in_addr	INADDR;
#define Printf		(void)printf
#if	defined(VAR_NONE)
#define Reply		(void)printf
#endif	/* defined(VAR_NONE) */


/*
**  The XTHREAD command is too ugly to talk about.
*/
#define DONT_DO_XTHREAD
#define THREAD_NAMES_FLAT
#define THREAD_SUFFIX		""
#define THREAD_DB		"/usr/spool/news/trn.threads/db.init"
#define THREAD_DIR		"/usr/spool/news/trn.threads"
#define THREAD_NNTP_CODE	288


/*
**  A group entry.
*/
typedef struct _GROUPENTRY {
    char	*Name;
    char	Flag;
    char	*Alias;
} GROUPENTRY;


/*
**  What READline returns.
*/
typedef enum _READTYPE {
    RTeof,
    RTok,
    RTlong,
    RTtimeout
} READTYPE;


#if	defined(MAINLINE)
#define EXTERN	/* NULL */
#else
#define EXTERN	extern
#endif	/* defined(MAINLINE) */

EXTERN BOOL	PERMauthorized;
EXTERN BOOL	PERMcanpost;
EXTERN BOOL	PERMcanread;
EXTERN BOOL	PERMneedauth;
EXTERN BOOL	PERMspecified;
EXTERN BOOL	Tracing;
EXTERN char	**PERMlist;
EXTERN STRING	MyHostName;
extern char	ACTIVE[];
EXTERN char	ClientHost[SMBUF];
extern char	ACTIVETIMES[];
extern char	HISTORY[];
extern char	NEWSGROUPS[];
extern char	NOACCESS[];
EXTERN char	PERMpass[20];
EXTERN char	PERMuser[20];
EXTERN char	*RemoteMaster;
EXTERN int	*ARTnumbers;
EXTERN int	ARTindex;
EXTERN int	ARTsize;
extern int	PERMdefault;
EXTERN long	ARTcount;
EXTERN long	GRParticles;
EXTERN long	GRPcount;
EXTERN long	POSTreceived;
EXTERN long	POSTrejected;


extern STRING		ARTpost();
extern void		ARTclose();
extern char		*Glom();
extern int		Argify();
extern void		ExitWithStats();
extern BOOL		GetGroupList();
extern void		GRPreport();
extern GROUPENTRY	*GRPfind();
extern STRING		HISgetent();
extern long		LOCALtoGMT();
extern BOOL		NGgetlist();
extern long		NNTPtoGMT();
extern BOOL		PERMartok();
extern BOOL		PERMinfile();
extern BOOL		PERMmatch();
extern BOOL		ParseDistlist();
extern READTYPE		READline();
#if	defined(VAR_STDARGS)
extern void		Reply(char *, ...);
#else
extern void		Reply();
#endif	/* defined(VAR_STDARGS) */
