/*  $Revision: 1.4 $
**
*/
#if	defined(hpux)
#define DO_USE_GETRLIMIT
#endif	/* defined(hpux) */

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#if	defined(DO_USE_GETRLIMIT)
#include <sys/resource.h>
#endif	/* defined(DO_USE_GETRLIMIT) */


int
getdtablesize()
{
    static int		size = 0;
#if	defined(DO_USE_GETRLIMIT)
    struct rlimit	rl;
#endif	/* defined(DO_USE_GETRLIMIT) */

    if (size == 0) {
	/* There are better ways to do this.  From Guy Harris:
	 *	size = ulimit(0L, 4);		# SysVr3
	 *					# SunOS4.1, SysVr4:
	 *	getrlimit(RLIMIT_NOFILE, &rl), size = rl.rlim_cur;
	 *	size = sysconf(_SC_OPEN_MAX);	# Posix
	 */
#if	defined(DO_USE_GETRLIMIT)
	if (getrlimit(RLIMIT_NOFILE, &rl) < 0)
	    return -1;
	size = rl.rlim_cur;
#else
#if	defined(NOFILE)
	size = NOFILE;
#else
	size = 20;
#endif	/* defined(NOFILE) */
#endif	/* defined(DO_USE_GETRLIMIT) */
    }
    return size;
}
