/*
 * mcasttest.c  --  Silly little program to test multicast group joins/leaves.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet6/in6.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>


void
usage()
{
  fprintf(stderr, "usage: mcasttest [-j mcastgroup] [-d mcastgroup]\n");
  exit(1);
}

main(argc, argv)
     int argc;
     char *argv[];
{
  extern char *optarg;
  extern int optind, error;
  char c;
  int s;
  int iflag = 0;
  int joinflag = 0, jifflag = 0;
  int dropflag = 0;
  struct sockaddr_in6 sin6;
  struct in6_addr jaddr, daddr, iaddr, jif;
  struct ipv6_mreq mreq;
  char buf[80];

  bzero(&mreq,sizeof(mreq));
  while ((c = getopt(argc, argv, "J:j:i:d:")) != EOF)
    switch(c) {
    case 'J':
      jifflag++;
      if (inet_pton(AF_INET6, optarg, (void *)&jif) < 0) {
	fprintf(stderr, "invalid join if\n");
	exit(1);
      }
      break;
    case 'j':
      joinflag++;
      if (inet_pton(AF_INET6, optarg, (void *)&jaddr) < 0) {
	fprintf(stderr, "invalid join addr\n");
	exit(1);
      }
      break;
    case 'i':
      iflag++;
      if (inet_pton(AF_INET6, optarg, (void *)&iaddr) < 0) {
	fprintf(stderr, "invalid intf addr\n");
	exit(1);
      }
      printf("Got iaddr of %s\n",inet_ntop(AF_INET6,&iaddr,buf, sizeof(buf)));
      break;
    case 'd':
      dropflag++;
      if (inet_pton(AF_INET6, optarg, (void *)&daddr) < 0) {
	fprintf(stderr, "invalid drop addr\n");
	exit(1);
      }
      break;
    default:
      usage();
    }

  if ((s = socket(AF_INET6, SOCK_DGRAM, 0)) < 0) {
    perror("socket");
    exit(1);
  }
  
  /*  bzero((char *)&sin6, sizeof(sin6));
      sin6.sin6_family = AF_INET6;
      sin6.sin6_len = sizeof(sin6);
      if (bind(s, (struct sockaddr *)&sin6, sin6.sin6_len) < 0) {
      perror("bind");
      exit(1);
      } */

  if (iflag) 
    {
      int len = sizeof(iaddr);

      printf("Do a get, followed by a set, and then another get.\n");
      if (getsockopt(s, IPPROTO_IP, IPV6_MULTICAST_IF, (char *)&mreq,
		     &len) == -1)
	{
	  perror("getsockopt IPV6_MULTICAST_IF\n");
	  exit(1);
	}
      else
	{
	  printf("len of %d.  Got if addr of:  %s\n",len,
		 inet_ntop(AF_INET6,&mreq.i6mr_multiaddr,buf,sizeof(buf)));
	}
      if (setsockopt(s, IPPROTO_IP, IPV6_MULTICAST_IF, (char *)&iaddr, 
		     sizeof(iaddr)) == -1)
	{
	  perror("setsockopt IPV6_MULTICAST_IF\n");
	  exit(1);
	}
      if (getsockopt(s, IPPROTO_IP, IPV6_MULTICAST_IF, (char *)&mreq,
		     &len) == -1)
	{
	  perror("getsockopt(2) IPV6_MULTICAST_IF\n");
	  exit(1);
	}
      else
	{
	  printf("2nd len of %d.  Got if addr of:  %s\n",len,
		 inet_ntop(AF_INET6,&mreq.i6mr_multiaddr,buf,sizeof(buf)));
	}
    }

  if (joinflag) 
    {
      mreq.i6mr_multiaddr = jaddr;
      if (jifflag)
	mreq.i6mr_interface = jif;
      if (setsockopt(s, IPPROTO_IP, IPV6_ADD_MEMBERSHIP, (char *)&mreq, 
		     sizeof(mreq)) == -1)
	{
	  perror("setsockopt IPV6_ADD_MEMBERSHIP\n");
	  exit(1);
	}
    }

  if (dropflag)
    {
      mreq.i6mr_multiaddr = daddr;
      if (setsockopt(s, IPPROTO_IP, IPV6_DROP_MEMBERSHIP, (char *)&mreq, 
		     sizeof(mreq)) == -1) {
	perror("setsockopt IPV6_DROPMEMBERSHIP\n");
	exit(1);
      }
    }

  printf("Waiting for user to stop program, ping the new joined mcast.\n");
  while (1)
    ;
}
