/*----------------------------------------------------------------------
  Portions Copyright 1996 by Larry Bassham, All Rights Reserved.
  The NRL COPYRIGHT NOTICE and LICENSE governs distribution and use of
  this software.

  Portions Copyright 1995 by Bao Phan, Dan McDonald, & Randall Atkinson.
  All Rights Reserved. All Rights have been assigned to the US
  Naval Research Laboratory (NRL). The NRL COPYRIGHT NOTICE and
  LICENSE governs distribution and use of this software.
----------------------------------------------------------------------*/
/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/param.h>
#include <sys/malloc.h>
#include <sys/systm.h>

#include <netkey/key.h>
#include <netsec/ipsec.h>

#include "sha.h"

struct SHAstate {
  SHA_CTX isb;               	    /* Internal state block for MD5 */
  struct key_secassoc *assoc;       /* Security association (keys!) */
};

u_int8_t	keyfill[64]={0x80, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
			0x00, 0x00,0x00,0x00,0x00,0x00,0x00, 0x00};

void ProcessBlock __P((SHA_CTX *));
int SHAInit __P((SHA_CTX *));
int SHAUpdate __P((SHA_CTX *, BYTE *, int));
int SHAFinal __P((SHA_CTX *));

static void SHAEncode __P((u_int8_t *, unsigned long));
caddr_t ah_shainit __P((struct key_secassoc *));
caddr_t ah_shaupdate __P((caddr_t, caddr_t, int));
caddr_t ah_shafinish __P((caddr_t, caddr_t));

static void	SHAEncode(p, l)
u_int8_t	*p;
unsigned long	l;
{
  bzero(p, 4);
  p[4] = (l>>24)&0xff;
  p[5] = (l>>16)&0xff;
  p[6] = (l>>8)&0xff;
  p[7] = l&0xff;
}

/*----------------------------------------------------------------------
  shainit():   Initialize SHA state and stash pertinent
               Security Association away in SHAstate.
----------------------------------------------------------------------*/
caddr_t ah_shainit(assoc)
     struct key_secassoc *assoc;
{
  struct SHAstate *SHAstate = malloc(sizeof(struct SHAstate), M_TEMP, M_NOWAIT);
  u_int8_t lenpad[8];
  
  if (SHAstate) {
    SHAInit(&(SHAstate->isb));
    SHAUpdate(&(SHAstate->isb), (unsigned char *)assoc->key, assoc->keylen);
    SHAUpdate(&(SHAstate->isb), keyfill,assoc->keylen <56? 56-assoc->keylen:120 - assoc->keylen);
    SHAEncode(lenpad,assoc->keylen*8);
    SHAUpdate(&(SHAstate->isb), lenpad, 8);
    SHAstate->assoc = assoc;
  }

  return (caddr_t)SHAstate;
};

/*----------------------------------------------------------------------
  shaupdate():  Continue the SHA calculation over some data in the packet.
----------------------------------------------------------------------*/
caddr_t ah_shaupdate(state, data, len)
     caddr_t state;
     caddr_t data;
     int len;
{
  SHAUpdate(&(((struct SHAstate *)state)->isb), (unsigned char *)data, len);
  return state;
};

/*----------------------------------------------------------------------
  shafinish():  Conclude the SHA calculation for AH and return AH data (?).
----------------------------------------------------------------------*/
caddr_t ah_shafinish(state, data)
     caddr_t state;
     caddr_t data;
{
  struct SHAstate *SHAstate = (struct SHAstate *)state;
  SHAUpdate(&(SHAstate->isb), (unsigned char *)SHAstate->assoc->key,
	    SHAstate->assoc->keylen);
  SHAFinal(&(SHAstate->isb));
  bcopy(SHAstate->isb.buffer, data, 20);

  free(state, M_TEMP);
  return data;
};
