/* This software is Copyright 1996 by Craig Metz, All Rights Reserved.
   The Inner Net Copyright Notice and License Agreement Version 2
   applies to this software.
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef INET6
#include <netinet6/in6.h>
#endif /* INET6 */

#include "getaddrinfo.h"

extern char *optarg;

char buffer[1024];

void usage(char *myname)
{
  printf("usage: %s [-n <name>] [-s <service>] [-f <family>] [-t <socktype>] [-p protocol] [-c] [-b]\n", myname);
  exit(1);
}

int main(int argc, char **argv)
{
  int i, j;
  struct addrinfo *pai;
  struct addrinfo req;
  char *name = NULL, *service = NULL;
  
  memset(&req, 0, sizeof(req));

  while((i = getopt(argc, argv, "n:s:f:t:p:cb")) != -1) {
    switch(i) {
    case 'n':
      name = optarg;
      break;
    case 's':
      service = optarg;
      break;
    case 'f':
      req.ai_family = atoi(optarg);
      break;
    case 't':
      req.ai_socktype = atoi(optarg);
      break;
    case 'p':
      req.ai_protocol = atoi(optarg);
      break;
    case 'c':
      req.ai_flags |= AI_CANONNAME;
      break;
    case 'b':
      req.ai_flags |= AI_PASSIVE;
      break;
    default:
      usage(argv[0]);
    }
  }

  i = getaddrinfo(name, service, &req, &pai);
  
  printf("getaddrinfo() returned: %s(%d).\n", nrl_gai_strerror(i), i);
  
  if (!i) {
    i = 0;
    while(pai) {
      printf("\nrecord %d:\n", i++);
      printf("ai_flags:      %x(%d)\n", pai->ai_flags, pai->ai_flags);
      printf("ai_family:     %x(%d)\n", pai->ai_family, pai->ai_family);
      printf("ai_socktype:   %x(%d)\n", pai->ai_socktype, pai->ai_socktype);
      printf("ai_protocol:   %x(%d)\n", pai->ai_protocol, pai->ai_protocol);
      printf("ai_addrlen:    %x(%d)\n", pai->ai_addrlen, pai->ai_addrlen);
      printf("ai_addr:       %s\n", inet_ntop(pai->ai_family,
#ifdef INET6
	(pai->ai_family == AF_INET6) ? 
	(char *)&(((struct sockaddr_in6 *)(pai->ai_addr))->sin6_addr) : 
#endif /* INET6 */
	(char *)&(((struct sockaddr_in *)(pai->ai_addr))->sin_addr),
        buffer, sizeof(buffer)));
      printf("ai_canonname:  %s\n", pai->ai_canonname);

      pai = pai->ai_next;
    }
  }

  return i;
}
