# Directories in which to install things.  If these are not specified
# the default values used would overwrite most of the corresponding
# IPv4 only utilities.
#
.ifdef(!ROOT_MK)
ROOT_MK=

DOTS?=../../
.include "${DOTS}/Makefile.config"

LIBCRT0?=	/usr/lib/crt0.o
LIBC?=		/usr/lib/libc.a
LIBKVM?=	/usr/lib/libkvm.a

.if $(SEGREGATE_EXECUTABLES)
LIBEXECDIR=	/libexec
TESTDIR=	/test
USR_BINDIR=	/bin
USR_SBINDIR=	/sbin
SCRIPTDIR=	/bin
.else
LIBEXECDIR=	/bin
TESTDIR=	/bin
USR_BINDIR=	/bin
USR_SBINDIR=	/bin
SBINDIR=	/bin
SCRIPTDIR=	/bin
.endif

INCDIR=		/include
LIBDIR= 	/lib
MANDIR=		/man/cat

# C flags common to all the utilities.
#
CINCDIRFLAGS?=	-I${DOTS}sys -I${DOTS}support
CFLAGS+=	-g ${CINCDIRFLAGS}

.if $(INET6)
DINET6=-DINET6=$(INET6)
.endif
.if $(IPSEC)
DIPSEC=-DIPSEC=$(IPSEC)
.endif
.if $(IPV4CIDR)
DIPV4CIDR=-DIPV4CIDR=$(IPV4CIDR)
.endif
.if $(FASTCTO)
DFASTCTO=-DFASTCTO=$(FASTCTO)
.endif
.if $(SALEN)
CFLAGS+=-DSALEN=$(SALEN)
.endif

# Libraries used by the utilities.
#
LIBDIRFLAGS?=	-L${DOTS}support
LDADD+= ${LIBDIRFLAGS} -linet6
.endif
