/***************************************
  $Revision: 1.4 $

  Public Authentication (PA) - er_PA_errors.h - definition of errors for the
				PA module.

  Status: NOT COMPLETE, NOT REVUED, NOT TESTED, 

  Design and implementation by: daniele@ripe.net

  ******************/ /******************
  Copyright (c) 2000,2001,2002                    RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* I see no way of automating things here... Maybe with a perl script.

   There are three things to do:
   1. Get a new integer number from the enum 
	(using a ??_LOW_<mnem> symbol)
   2. define a new error code (??_<mnem>) by adding the facility and
	severity codes.
   3. put the symbol (using macro ERDUP) and text of the message into the
	array. Should fit in one line with the macro.

   The order of codes in enum does NOT have to match the order of texts.
   The last in the texts array must be the ER_LASTTXT constant.

   Sounds familiar ? That's because facilities and errors are parts
   of the error reporting fractal :-)
*/

/* use m4 macros to keep stuff in sync */
define( `MLUP', `divert(7)#define $1_$2  (ER_SEV_$3 + (FAC_$1<<16) + LOW_$1_$2)
divert(8)  { ERDUP($1_$2),$4 },
divert LOW_$1_$2' )
define( `ERCT', `$1_err_code_t')
define( `MDER', `$1_mod_err')

     /******************************************/
     /* ***** DEFINE THE CURRENT FACILITY **** */
     /* * make sure no whitespaces are inside! */
     /* */       define(`CFAC',`PA')        /* */
     /* ************************************** */
     /******************************************/

/* last thing: disable processing of commented text (this allows to comment
   out some macro entries. Alas, the #%$@&* designers screwed up, so now we
   have to manually disable messing with C preprocessor commands */
changecom(/*,*/)
undefine(`define')
undefine(`ifdef')
undefine(`include')

typedef enum {
  /*  fac  code    sev  descr
      
      current facility specified inside the line below as CFAC
   */

  MLUP(CFAC, OK,      I,  "OK"),
  MLUP(CFAC, CANTSPWN, F, "Cannot spawn"),
  MLUP(CFAC, CANTOPEN,  F,  "Cannot open file"),
  MLUP(CFAC, REAP,  F,  "Could not reap child"),
  MLUP(CFAC, CHST,  F,  "Bad child status:"),
  MLUP(CFAC, CHRC,  F,  "Bad child return code:"),
  MLUP(CFAC, LINETOOLONG,  F,  "Line too long: line number"),
  MLUP(CFAC, NOTEMP,  F,  "Can't create temp file"),
  MLUP(CFAC, CANTREAD,  F,  "Can't read from file")
} ERCT(CFAC);

/* paste the #define'd codes */
undivert(7) 

#ifdef ER_IMPL
er_list_t MDER(CFAC)[]={

  /* paste the ERDUP's */
  undivert(8) 
  
  ER_LASTTXT
};
#endif /* ER_IMPL */
