
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>

#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <stubs.h>
#include "ca_configFns.h"
#include "ca_dictionary.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"

int main (int argc, char** argv)
{
/* Initialise the linked list of sources. */

ca_dbSource_t *source_hdl;
char *source_name, *config_name, *property;
int errflg;
int c;
extern int optind;
extern char *optarg;


errflg=0;
        if(argc<2)errflg++;

        while ((c = getopt(argc, argv, "s:c:p:?")) != EOF)
        switch (c) {
                case 's':
                source_name = optarg;
                break;  

                case 'c':
                config_name = optarg;
                break;

                case 'p':
                property = optarg;
                break;
                
                case '?':
                default :
                errflg++;
                break;
        }
        if (errflg) {
         fprintf(stderr,"usage: getvar -s <source> -c <configfile> -p <property>\n");
         fprintf(stderr,"list of properties:\n\tdatabase\tdatabase name\n"
                                             "\tdbhost\tsql server hostname\n"
                                             "\tdbport\tsql server port\n"
                                             "\tdbuser\tsql user name\n"
                                             "\tdbpswd\tsql user password\n");
         exit (2);
        }


 ca_init(config_name);
 
 source_hdl = ca_get_SourceHandleByName(source_name);

 if(source_hdl == NULL) exit(1);

 if(strcasecmp(property, "dbname")==0){
  printf("%s", ca_get_srcdbname(source_hdl)); exit(0);
 } else 
 if(strcasecmp(property, "dbhost")==0){
  printf("%s",ca_get_srcdbmachine(source_hdl)); exit(0);
 } else
 if(strcasecmp(property, "dbport")==0){
  printf("%d",ca_get_srcdbport(source_hdl)); exit(0);
 } else
 if(strcasecmp(property, "dbuser")==0){
  printf("%s",ca_get_srcdbuser(source_hdl)); exit(0);
 } else
 if(strcasecmp(property, "dbpswd")==0){
  printf("%s",ca_get_srcdbpassword(source_hdl)); exit(0);
 } else {
  printf(""); exit(1);
 }

}
