/***************************************
  $Revision: 1.3 $

  string utilities (ut). 

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : stringutil.c
  Author              : marek@ripe.net
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "ut_string.h"

#define SPACE 0
#define WORD  1
 
/*+
  compress by removing leading/trailing spaces and compressing multiple
  whitespaces to one.

  allocates a string and returns it - it must be freed
+*/


/*++++++++++++++++++++++++++++++++++++++
char *
ut_string_compress    removes leading/trailing whitespaces and compresses 
                      multiple whitespaces to one. The result is an allocated
		      string and must be freed.

char *input           source string
  ++++++++++++++++++++++++++++++++++++++*/
char *
ut_string_compress(char *input)
{
  char *inchr;
  char *copy = malloc(strlen(input)+1);
  char *outchr = copy;
  char *lastchr;
  int nowexpected = WORD; /* skip initial spaces */

  /* find trailing space */
  lastchr = strchr(input, '\0'); 
  while( lastchr != input ) {
    lastchr--;
    if( !isspace((int)*lastchr) ) {
      break;
    }
  }
   
  /* copy the string word by word, inserting spaces */
  inchr=input;
  do { 
    unsigned char ch = *inchr;
    
    if( isspace(ch) ) {
      if( nowexpected == WORD ) { 
	continue; /* skip this whitespace */
      }
      else { 
	ch = ' '; /* convert to a plain space */
	nowexpected = WORD; /* ignore any more spaces */
      }
    }
    else {
      nowexpected = SPACE; 
    }
    
    *outchr = ch;
    outchr++;
  } while(inchr++ != lastchr);
  
  *outchr = '\0';
  
  return copy;
}


/*++++++++++++++++++++++++++++++++++++++

void
ut_string_chop       removes trailing whitespaces from the string, replacing
                     them with '\0' characters. 
		     So it modifies the source string.

char *input          source string
  ++++++++++++++++++++++++++++++++++++++*/
void
ut_string_chop(char *input)
{
  unsigned char *co = (unsigned char *)strchr(input, '\0');

  while( co != (unsigned char *)input && (isspace(*co) || *co == '\0') ) {
    *co = '\0';
    co--;
  }
}

