#	$RCSfile: whoisqry.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

# This is a very simple whois client module

sub getwhoisportandproto {
    local($port)=@_;
    
    local($name,$aliases,$proto);

    if ($port=~ /^\d+$/) {
       $proto="tcp";
    }
    else {
        ($name,$aliases,$port,$proto)=getservbyname("whois", "tcp");
        die "cannot find portnumber for \'whois\' service" if (!$port);
        #print STDERR "-$port-$proto-";
    }

    ($name,$aliases,$proto)=getprotobyname($proto);

    return ($port,$proto);
    
}

sub initwhoisqry {
    local($host, $port, $string, $AF_INET, $SOCKADDR, $SOCK_STREAM)=@_;
    
    local($proto,$address);
    
    if ($host=~ /^\s*\d+\.\d+\.\d+\.\d+\s*$/) {
       $address=pack("C4",split(/\./,$host));
    }
    else {
       $address=(gethostbyname($host))[4];
    }
    
    # find valid port and protocol number for whois service
    
    #print "*$port*\n";
    
    ($port,$proto)=&getwhoisportandproto($port);
    
    #
    # connect
    
    socket(WHOIS_S, $AF_INET, $SOCK_STREAM, $proto) || die "socket creation failed\n";
    #print "-$port-$address-$SOCKADDR-$AF_INET-\n";;
    
    if (connect(WHOIS_S, pack($SOCKADDR, $AF_INET, $port, $address))) {
    
       #
       # no buffering
    
       local($oldhandle)=select(WHOIS_S); $| = 1; select($oldhandle);

       #
       # print options
    
       print WHOIS_S $string, "\n";
       
       return "";
    
    }
    else {
    
       return ("Connect to host: $host port: $port failed");

    }
    
    #
    # returning a socket doesn't work, so we use the global var ...
    #
    # I found how to this but haven't had time to do the change.
    #
    # return (WHOIS_S);

}

1;