#       enwrite - write RIPE database entry
#
#	$RCSfile: enwrite.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $
#
#	This routine writes a RIPE database entry to standard output
#	in long or short form.
#
#       Arguments:
#	$output		file handle for output
#	*object		pointer to assoc array with database entry
#	$long		boolean flag for long or short format output
#	$witherror	boolean flag for with or without error messages
#       $withsugar      boolean flag for with or without syntactic sugar

require "entype.pl";

sub enwrite {

    local($output, *object, $long, $witherrors, $withsugar) = @_;
    
    local($offset)=0;
    
    local($val);
    local(@errs)=();
    local($type)=&entype(*object);
    
    @errs=("uw","ue") if $witherrors;

    # If not long format, and we have an unknown object, let's try
    # and print this anyway to inform the user ...

    if (!$type) {

	return 0 if (!$long);
	return 0 if (!$witherrors);

        print $output "\n";
    
        $offset=tell($output);

	foreach $key (keys %object) {
	    
	    next if (grep(/^$key$/,@errs));
	    
	    foreach $val (split(/\n/, $object{$key})) {
	    
	       if (($long) && ($ATTL{$key})) {
	          $key=$ATTL{$key};
	       }
	       elsif ((length($key)==2) && ($ATTR{$key})) {
	          $key="*".$key;
	       }
	       
	       printf $output "%-15s %s\n", $key.":", $val;
	       
	    }
	
	}
	
	printf $output "%-15s %s\n", $ATTL{"ue"}.":", "Unknown object type";
	
	return $offset;
    
    }

    if ($object{$type}) {

       print $output "\n";
    
       $offset=tell($output);
	    
    }

    # print STDERR $OBJATSQ{$type}, %object,"\n";

    foreach $key (split(/ /, $OBJATSQ{$type}), @errs) {
    
        # print STDERR "*",$key,"* ", $object{$key}, "\n";
    
	if ($object{$key}) {
           
           # print STDERR $key, "\n";

	    foreach $val (split(/\n/, $object{$key})) {

		if ($long) {

		    # HARDCODED SYNTACTIC SUGAR !!!!

		    if ($withsugar) {
			
			local($M) = "\\S+\\s+\\S+\\s+\\S+";
			
			if ($key eq "ae") {
			    $val=~ s/^(AS\d+)/exclude $1 to/;
			}
			elsif ($key eq "ai") {
			    $val=~ s/^(AS\d+\s+\d+)/from $1 accept/;
			}
			elsif ($key eq "ao") {
			    $val=~ s/^(AS\d+)(\s+)/to $1 announce$2/;
			}
			elsif ($key eq "it") {
			    $val=~ s/^($M)\s+(\(\s*pref[=\s\S]+\))/from $1 $2 accept/ ||
			    $val=~ s/^($M)\s+/from $1 accept /;
			}
			elsif ($key eq "io") {
			    $val=~ s/^($M)\s+(\(\s*metric\-out[=\s\S]+\))/to $1 $2 announce/ ||
			    $val=~ s/^($M)\s+/to $1 announce /;
			}
		    }

		    # END HARDCODED

		    printf $output "%-12s %s\n", $ATTL{$key}.":", $val;
		
		}
		else {
		    print $output "*", $key, ": ", $val, "\n";
		}
	    }
	}
    }

    return $offset;
    
}

1;
