#       serial - serialize updates & support routines
#
#	$RCSfile: serial.pl,v $
#	$Revision: 1.3 $
#	$Author: ripe-dbm $
#	$Date: 1996/02/15 12:58:35 $

require "misc.pl";

sub getcurrentserial {
   local($source)=@_;

   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"<".$LOGFILE{"SERIALDIR"}.$source.".CURRENTSERIAL") || die "getcurrentserial - cannot open serial file\n";
   }
   else {
      open(SERIAL,"<".$TOPDIR."\/".$source.".CURRENTSERIAL") || die "getcurrentserial - cannot open serial file\n";      
   }
   
   &lock(SERIAL) || die "getcurrentserial - cannot lock serial file\n";
   
   local($serial)=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
      
   print STDERR "CurrentSerial: *$serial*\n" if $opt_V;
   
   close(SERIAL) || die "getcurrentserial - cannot close/unlock serial file\n";
    
   return $serial;
}

sub getoldestserial {
   local($source)=@_;

   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"<".$LOGFILE{"SERIALDIR"}.$source.".OLDESTSERIAL") || die "getoldestserial - cannot open serial file\n";
   }
   else {
      open(SERIAL,"+<".$TOPDIR."\/".$source.".OLDESTSERIAL") || die "getoldestserial - cannot open serial file\n";
   }
   &lock(SERIAL) || die "getoldestserial - cannot lock serial file\n";
   
   local($serial)=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
      
   print STDERR "OldestSerial: *$serial*\n" if $opt_V;
   
   close(SERIAL) || die "getoldestserial - cannot close/unlock serial file\n";
    
   return $serial
}


sub writeseriallog {
   local($transaction, *en)=@_;
   local($serial);
   
   # open the serial file
   
   if ($LOGFILE{"SERIALDIR"}) {
      open(SERIAL,"+<".$LOGFILE{"SERIALDIR"}.$en{"so"}.".CURRENTSERIAL") || die "writeseriallog - cannot open serial file in: ", $LOGFILE{"SERIALDIR"}, "\n";
   }
   else {
      open(SERIAL,"+<".$TOPDIR."\/".$en{"so"}.".CURRENTSERIAL") || die "writeseriallog - cannot open serial file in: $TOPDIR\n";
   }
   
   &lock(SERIAL) || die "writeseriallog - cannot lock serial file\n";
   
   # get the serial number ...
   
   $serial=<SERIAL>;
   ($serial)=($serial=~ /^\s*(\d+)\s*$/);
   
   # and update it ...
   
   
   seek(SERIAL,0,0);
   ++$serial;
   print SERIAL $serial;
   
   if ($LOGFILE{"SERIALDIR"}) {
      
      open(OUTP,">".$LOGFILE{"SERIALDIR"}.$en{"so"}.".".$serial) || die "writeseriallog - cannot open serial data file\n";
      
      &lock(OUTP) || die "writeseriallog - cannot lock serial data file\n";
   
      close(SERIAL) || die "writeseriallog - cannot close/unlock serial file\n";
   
      #
      # write a log if needed
      #
      #
      
      print OUTP "$transaction\n\n";

      local($oldhandle)=select(OUTP); local($oldflush)=$|; $|=1;
      &enwrite(*en,0,1,0);
      $|=$oldflush; select($oldhandle);
      
      close(OUTP) || die "writeseriallog - cannot close/unlock serial data file\n";
   }
   else {
      close(SERIAL) || die "writeseriallog - cannot close/unlock serial file\n";
   }
   
   
   return $serial;
}

1;
