#	$RCSfile: defines.pl,v $
#	$Revision: 0.19 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $

$OK		=	1;
$NOK		=	0;
$EOF		=	99;

$LOCK_SH = 1;
$LOCK_EX = 2;
$LOCK_NB = 4;
$LOCK_UN = 8;

# Return codes for when trying to modify the database
# with explanatory messages. These are used deep down in the code
# just before or during updates, like dbadd.pl and updatecheck.pl.

$E_EXIST	=	2;
$E_NOT_FOUND	=	3;
$E_MULT_MATCH	=	4;
$E_MISMATCH	=	5;
$E_NOOP		=	6;
$E_OLDER	=	7;
$E_GUARDED	=	8;
$E_AUTHFAIL     =       9;
$E_GENERAL      =      10;

$MESSAGE[$E_EXIST]	= "entry already exists";
$MESSAGE[$E_NOT_FOUND]	= "entry not found";
$MESSAGE[$E_MULT_MATCH]	= "more than one match";
$MESSAGE[$E_MISMATCH]	= "mismatch between update and original";
$MESSAGE[$E_NOOP]	= "update results in NOOP";
$MESSAGE[$E_OLDER]	= "update is older than original";
$MESSAGE[$E_AUTHFAIL]   = "authorisation failed, request forwarded to maintainer";
$MESSAGE[$E_GENERAL]    = "";

# Return codes for syntax checking the objects

$O_OK		=	20;
$O_ERROR	=	21;
$O_WARNING	=	22;
$O_GUARDED      =       23;

$MESSAGE[$O_OK]		=	"object OK";
$MESSAGE[$O_ERROR]	=	"object has errors";
$MESSAGE[$O_WARNING]	=	"object has warnings";

# Return codes for authorisation

$A_OK		=	1;	# Authorisation worked
$A_BAD		= 	0;      # Authorisation failed
$A_ERR  	=      -1;      # Authorisation Error condition

# protocol codes - not implemented
#
# $_AU_OK	= 100;		# Authorization OK
# $_AU_BAD	= 110;		# Authorization BAD
# $_AU_ERR	= 120;		# Authoization ERROR (cannot open file etc)
#
# $_I_GENERAL	= 200;		# General information
# $_I_DUNNO	= 210;		# "I don't know what you mean" message
# $_I_WAIT	= 220;		# Waiting for input ...
# $_I_RECVD	= 230;		# Have received something, will start
#				# processing now
#
# $_A_OK	= 300;		# Addition OK
# $_A_UNKNOWN	= 310;		# Addition general failures
# $_A_PERM	= 320;		# Addition permission denied
#
# $_D_OK	= 400;		# Deletion OK
# $_D_UNKNOWN	= 410;		# Deletion general failures
# $_D_PERM	= 420;		# Deletion permission denied
# $_D_NFOUND	= 430;		# Object not found for deletion
#
# $_M_OK	= 500;		# Modify OK
# $_M_UNKNNOWN	= 510;		# Modify general failures
# $_M_PERM	= 520;		# Modify permission denied
# $_M_NFOUND	= 530;		# Object not found for modification
#
# $_AM_OK	= 600;		# Add_or_modify OK
# $_AM_UNKNOWN	= 610;		# Add_or_modify general failures
# $_AM_PERM	= 620;		# Add_or_modify permission denied

#
# possible actions for an entry
#

$ADDACTION="ADD";
$DELETEACTION="DEL";

#
# The version of the inputformat we default to
#

$UPDATEVERSION=1;

#
# Supported update versions
#

@UPDATEVERSIONS=($UPDATEVERSION);

#
# the attribute value to be used for deleted objects
#

$DELETEDOBJECT="XX";

#
# what is the extension for classless databases ?
#

$CLASSLESSEXT="cl";

# Masks for IP addresses

@masks = ( 0x0,  0x80000000, 0xc0000000, 0xe0000000, 0xf0000000,
	  0xf8000000, 0xfc000000, 0xfe000000, 0xff000000,
	  0xff800000, 0xffc00000, 0xffe00000, 0xfff00000,
	  0xfff80000, 0xfffc0000, 0xfffe0000, 0xffff0000,
	  0xffff8000, 0xffffc000, 0xffffe000, 0xfffff000,
	  0xfffff800, 0xfffffc00, 0xfffffe00, 0xffffff00,
	  0xffffff80, 0xffffffc0, 0xffffffe0, 0xfffffff0,
	  0xfffffff8, 0xfffffffc, 0xfffffffe, 0xffffffff );
