#!PERL

#       whoisd - whois Internet daemon
#
#	$RCSfile: whoisd.pl,v $
#	$Revision: 0.54 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#

USE_DBM

$port = WHOISPORT;

$AF_INET = 2;
$SOCK_STREAM = SOCKSTREAMVALUE;
$SOL_SOCKET = 0xffff;
$SO_REUSEADDR = 0x0004;

$sockaddr = 'S n a4 x8';

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "dbopen.pl";
require "dbclose.pl";
require "enread.pl";
require "enwrite.pl";
require "enkeys.pl";
require "enukey.pl";
require "misc.pl";
require "serial.pl";
require "dbmatch.pl";
require "syslog.pl";
require "template.pl";
require "flush.pl";

sub exitwhoisd {
   local($exitcode, $msg)=@_;
   
   print NS $msg if ($msg);
   &flush(NS);
   close(NS);
   
   exit($exitcode);
}


# If we get a SIGALRM, exit. Used in the read loop, to make sure people
# do not keep the connection open, and open and open ....

sub alarmhandler {

   &exitwhoisd(0,"\n\nTimeout... Closing connection\n\n");

}

#
# sometimes we need to exit earlier ...
#

sub nsexit {
   local($msg) = @_;

   &exitwhoisd(0,"\n\nERROR: ".$msg."\n\n");
   
}

sub nscleanexit {
   local($msg) = @_;

   &exitwhoisd(0,"\n\n".$msg."\n\n");
   
}


#
# check for authorized access...
#

sub allowupdate {
    local($rhost,*accesslist)=@_;
    
    foreach $updfrom (@accesslist) {
       print STDERR "update from: $rhost, Access: $updfrom\n" if $debug;
       if (($updfrom!~ /^\s*$/) &&
           ($rhost=~ /^$updfrom$/)) {
          return 1;
       }
    }
    
    return 0;
}

#
# makekeys - converts a whitespace seperated string of keys into
#                an array. Trailing zeros in netnumbers are removed.
#
# This also does the classless indexes if a classless address is
# requested. The classless index will return db keys, so they will
# simply be added to the set of keys to look up.

sub makekeys {

    local($string) = @_;
    local(@keys) = ();
    local($i);

    $string =~ s/^\s+//;
    $string =~ tr/A-Z/a-z/;

    @keys = split(/\s+/, $string);

    # remove keys shorter than 2 chars, since the indexing does not use
    # them either ;-)

    foreach $i (0..$#keys) {
        if (length($keys[$i]) < 2) {
            splice(@keys, $i, 1);
        }

        # Remember: numbers possibly followed by dots and more numbers
        # are ALWAYS considered IP network numbers!!!!!

        if ($keys[$i] =~ /^\d+(\.\d+){0,3}(\/\d+)?$/) {
            local($p, $l) = split(/\//, $keys[$i]);
            
            $p=~ s/\.\s*$//;
            
            if ($p=~ /^[^\.]+\.[^\.]+$/) {
               $p.=".0.0";
            }
            elsif ($p=~ /^[^\.]+\.[^\.]+.[^\.]+$/) {
               $p.=".0";
            }
            
            if ($p=~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
               if (($1<=255) && ($1>=0) &&
                   ($2<=255) && ($2>=0) &&
                   ($3<=255) && ($3>=0) &&
                   ($4<=255) && ($4>=0)) {
                  if ($l) {
                     $keys[$i]=&quad2int($p,0)."/$l";
                  }
                  else {
                     $keys[$i]=&quad2int($p,0)."/32";
                  }
               }
            }
        }
        
        if (length($keys[$i]) < 2) {
            splice(@keys, $i, 1);
        }
    }
    return @keys;
}

#
# lookupandprint - will find all matches for all keys, and will output
#                the objects found, if they indeed match all the keys.
#                will also generate an array with keys that should be
#                looked up recursively because they are referenced in
#                the printed objects
#
# Exit codes (set in $result):
#        -1 - toomany hits (if result != 1 yet)
#         0 - no match (if $result was not defined yet)
#         1 - OK, something was output (always)

sub lookupandprint {

    local(*db, *keys, $result, $nonintersect) = @_;
    local(%en) = ();
    local(@playkeys) = @keys;
    local(@matches) = ();
    local($save) = "";
    local($i);
    local($type);
    
    # This was meant as an optimization, but it will cause references from
    # the last object in a file to fail. Perhaps do something slightly
    # more clever at some stage.

    # return if (eof(db);


    print STDERR "($$) in lookupandprint - \$nonintersect = $nonintersect\n" if $debug;

    foreach $i (0..$#playkeys) {
        next if $playkeys[$i] !~ /^\d+\/\d+$/;
        if ($opt_m || $opt_M) {
            print NS "% This may take some time, server running at low priority\n" if !$slow_msg_print;
            print NS "\n" if !$slow_msg_print;
            $slow_msg_print = 1;
            system("$RENICECMD 10 $$ > /dev/null 2>/dev/null");
            $xsps = &findmsps($playkeys[$i], $playkeys[$i], 1, $opt_m);
        } else {
            $xsps = &findlsps($playkeys[$i], $opt_L);
        }
        local(@boe);
        foreach $tmp (split(/,/, $xsps)) {
            local($val);
            &getmspnxl($tmp, *val);
            @boe = (@boe, &cla2unikey($tmp));
        }
        splice(@playkeys, $i, 1, @boe);
    }

    @matches = &dbmatch(*db, *playkeys, $nonintersect);

    if (($#matches < 0) && (!$result)) {
        return 0;
    }
    for $j (0..$#matches) {
        if ($matches[$i] == -1) {
            $result = -1 if $result != 1;
            return $result;
        }
        if ($displayed{$matches[$j]}) {
            $result = 1;
            print STDERR "($$) left lookupandprint already seen\n" if $debug;
            next;
        }
        $type=&enread(*en, db, $matches[$j]);
        local($m) = -1;
        if (($#playkeys > 0) && !$nonintersect) {
            foreach (@playkeys) {
                $save = $_;
                local(@tmp) = &enkeys(*en);
                @tmp = (@tmp, &enukey(*en));
                foreach (@tmp) {
                    if ($save eq $_) {
                        $m++;
                    }
                }
            } 
        } else {
            $m = $#playkeys;
        }
        if ($m == $#playkeys) {
            print STDERR "enwrite\n" if $debug;
            print NS "\n" if &enwrite(*en, 1, 0, !$opt_S);
            $displayed{$matches[$j]} = 1;
            $result = 1;
            if ($RECUR{$type} && !$opt_r) {
                local(@tmp) = split(/[\s\t]+/, $RECUR{$type});
                foreach (@tmp) {
                    local(@r) = split(/\n/, $en{$_});
                    for ($k=0;$k<=$#r;$k++) {
                        if (!$refd{$r[$k]}) {
                            $refs[$recindex++] = $r[$k];
                            $refd{$r[$k]} = 1;
                        }
                    }
                }
            }
        }
    }
    print STDERR "($$) left lookupandprint\n" if $debug;
    return $result;
}

# fastlookup - small routine to do fast lookups, always non-recursive
# it basically just reads from a file, and outputs as fast as it can
# without interpreting the data.

sub fastlookup {

    local(*db, *keys, $result, $nonintersect) = @_;
    local($j) = "";
    local($i);
    local(@playkeys) = @keys;

    # This is the same optimization as in lookupandprint()
    # return if eof(db);

    foreach $i (0..$#playkeys) {
        next if $playkeys[$i] !~ /^\d+\/\d+$/;
        if ($opt_m || $opt_M) {
            $xsps = &findmsps($playkeys[$i], $playkeys[$i], 1, $opt_m);
        } else {
            $xsps = &findlsps($playkeys[$i], $opt_L);
        }
        local(@boe);
        foreach $tmp (split(/,/, $xsps)) {
            local($val);
            &getmspnxl($tmp, *val);
            @boe = (@boe, &cla2unikey($tmp));
        }
        splice(@playkeys, $i, 1, @boe);
    }

    local(@matches) = &dbmatch(*db, *playkeys, $nonintersect);
    foreach $j (@matches) {
        $result = 1;
        seek(db, $j, 0);
        local($printed) = 0;
        while (<db>) {
            $printed = 1;
            print NS;
            last if /^\s*$/;
        }
        print NS "\n" if (eof(db) && $printed);
    }
    return $result;
}

#
# whois - main lookup loop. will output all objects found for all sources
#                requested. will also process the recursive lookups generated
#                by lookupandprint()
#

sub whois {
    
    local(*sources, $searchstring, $name, $rhost) = @_;
    local($nonintersect) = 1;

    print NS $REPLYBANNER;
    
    if ($opt_t) {
       local($type) = $opt_t;
       
       $opt_t = $ALIAS{$opt_t} if $ALIAS{$opt_t};
       $opt_t = $ATTR{$opt_t} if $ATTR{$opt_t};
       if (!$OBJATSQ{$opt_t}) {
          print NS "% No template available for object \"$opt_t\"\n";
       }
       else {
          &Template($opt_t);
       }
       return 1;
    }
    elsif ($opt_g) {
       system("$RENICECMD 10 $$ > /dev/null 2>/dev/null");
       &dogetserials($opt_g,$name,$rhost);      
       return 1;
    }
    elsif ($string =~ /^\s*HELP\s*$/i) {
        open (HELP, $HELP);
        while (<HELP>) {
            print NS;
        }
        close(HELP);
        return 1;
    }
    elsif ($opt_U) {
        
        &whoisupdate($name, $rhost, $opt_U);
        
        return 1;
    }
    else {

       local(@keys) = &makekeys($searchstring);
       if ($#keys > 0) {
          $nonintersect=0;
       }
        
       local(%nothing)=();
       local($result)=0;
       local($source);
       
       print STDERR "($$) in whois\n" if $debug;

       foreach $source (@sources) {
          local(%displayed)=();
          local(@searchdb)=();
          local(*i) = 'currentdb';
          
          if ($TYPE{$source} eq "SPLIT") {

             # Here is some guess work about what file to open....
             # We can only do that if there is only one key.

             # took most guesswork out
             # because what about people with names that start with as
             # nic handles like AS.* domain: as.*com
             
             if (($#keys == 0) &&
                 ($keys[0] =~ /^\d+\/\d+$/)) {
                    @searchdb = ("in", "rt", "ir");
             }

             if (!$searchdb[0]) {
                @searchdb = keys %OBJATSQ;
             }
            
             if ($opt_T) {
                @searchdb = @onlysearch;
             }

             foreach $j (@searchdb) {
                next if !&dbopen(i, *nothing, 0, "$DBFILE{$source}.$j");
                &dbclopen(*nothing, 0, "$DBFILE{$source}.$j");
                if ($opt_F) {
                    $result=&fastlookup(*i, *keys, $result, $nonintersect);
                    print STDERR "result: $result\n" if $debug;
                }
                else {
                    $result=&lookupandprint(*i, *keys, $result, $nonintersect);
                    print STDERR "result: $result\n" if $debug;
                }
                &dbclose(*i);
                &dbclclose();
             }
             for ($j=0;$j<$recindex;$j++) {
                 local(@refkeys) = &makekeys($refs[$j]);
                 @searchdb = ("pn");
                 foreach $j (@searchdb) {
                    next if !&dbopen(i, *nothing, 0, "$DBFILE{$source}.$j");
                    &dbclopen(*nothing, 0, "$DBFILE{$source}.$j");
                    $result=&lookupandprint(*i, *refkeys, $result);
                    print STDERR "result: $result\n" if $debug;
                    &dbclose(*i);
                    &dbclclose();
                }
             }
             undef(@refs);
             $recindex=0;
          }
          else {
             &dbopen(i, *nothing, 0, $DBFILE{$source});
             &dbclopen(*nothing, 0, $DBFILE{$source});
             if ($opt_F) {
                $result=&fastlookup(*i, *keys, $result, $nonintersect);
                print STDERR "result: $result\n" if $debug;
             }
             else {
                print STDERR "result: $result\n" if $debug;
                $result=&lookupandprint(*i, *keys, $result, $nonintersect);
             }
             for ($j=0;$j<$recindex;$j++) {
                 local(@refkeys) = &makekeys($refs[$j]);
                 print STDERR "result: $result\n" if $debug;
                 $result=&lookupandprint(*i, *refkeys, $result);
             }
             &dbclose(*i);
             &dbclclose();
             undef(@refs);
             $recindex=0;
          }
       }
       return $result;
       
    }
    
    print STDERR "($$) left whois\n" if $debug;
}
                        
#
# parse - parses the command line string for special options and sets
#                appropriate variables
#

sub parse {

    local($string) = @_;

    print STDERR "($$) got in parse\n" if $debug;

    # Reset all command line arguments, except -k

    @source = ();
    @onlysearch = ();
    $opt_a = 0;
    $opt_g = 0;
    $opt_r = 0;
    $opt_F = 0;
    $opt_s = 0;
    $opt_L = 0;
    $opt_m = 0;
    $opt_M = 0;
    $opt_T = 0;
    $opt_U = 0;
    
    if ($string=~ /^\s*(\S.*)$/) {
       $1=~ /^(.*\S)\s*$/;
       $string=$1;
    }
    else {
       $string="";
    }
    
    while ($string =~ /^-/) {
        if ($string =~ s/^\-([arkFLmUMS]+)\s*//) {
            if (length($1) > 1) {
                foreach (split(/|/, $1)) {
                    eval "\$opt_$_ = 1;";
                }
            } else {
                eval "\$opt_$1 = 1;";
            }
            next;
        }
        
        if ($string =~ s/^-g\s+(\S+)\s*//) {
            $opt_g = $1;
            next;
        }
                
        if ($string =~ s/^-(s)\s+(\S+)\s*//) {
            local($src) = $2;
            $src =~ tr/a-z/A-Z/;
            @source = (@source, split(",",$src));
            $opt_s = 1;
            next;
        }
        
        if ($string =~ s/^-V(..[0-9]+[0-9\.]*)\s*//) {
            $opt_V = $1;
            next;
        }
        
        if ($string =~ s/^-T\s+(\S+)\s*//) {
            local($type) = $1;
            $type = $ALIAS{$1} if $ALIAS{$1};
            $type = $ATTR{$1} if $ATTR{$1};
            if (!$OBJATSQ{$type}) {
                print NS "% Request for unknown object type \"$type\" ignored\n";
            } else {
                @onlysearch = (@onlysearch, $type);
                $opt_T = 1;
            }
            next;
        }
        
        if ($string =~ s/^\-t\s+(\S+)\s*//)  {
            $opt_t=$1;
            next;
            
        }
        last;
    }

    if ($opt_a) {
        @source = split(/\s+/, $ALLLOOK);
    }
    elsif (!$source[0]) {
        @source = split(/\s+/, $DEFLOOK);
    }

    print STDERR "($$) left parse\n" if $debug;

    if ($debug) {
        for $fl ("d","a","s","k","r","F","t","S","T","M","m","L","U","g") {
            if (eval "\$opt_$fl;") {
                if ($flags) {
                    $flags .= ":";
                }
                $flags .= "$fl";
            }
        }
        print STDERR "($$) called with $flags\n";
    }
    return $string;
}


sub whoisupdate {
    local($name, $rhost, $logstr) = @_;
    local($ent) = "";
        
    print STDERR "whoisupdate('$name', '$rhost', '$logstr');\n" if $debug;
    print STDERR "$BINDIR/dbupdate will be used.\n" if $debug;
        
    if (&allowupdate($rhost,*WHOISUPDFROM)) {
       
       alarm $KEEPOPEN;
       
       while(<NS>) {
          last if /^\.\s*$/;
          if (/^\s*$/) {
             if ($ent =~ /\S+/) {
                alarm 0;
                &dowhoisupdate($name, $rhost, $logstr, $ent);
                alarm $KEEPOPEN;
                $ent = "";
             }
          }
          else {
             $ent .= $_;
          }
       }
   }
   else {
      &syslog("AUDITLOG", "Network update authorization failure: $name ($rhost) $logstr");
      &nsexit("\n\n***You are not authorized to do network updates***\n\n");
   }
}

sub dowhoisupdate {
    local($name, $rhost, $logstr, $ent) = @_;
        
    local($tmpfile)="$TMPDIR/wupd.$$";
        
    $logstr =~ s/[^\w\@\.\-\_]//g;  # no shell spoofing but allow E-mail addresses !

    print STDERR "dowhoisupdate('$name', '$rhost', '$logstr');\n" if $debug;
    print STDERR "dowhoisupdate \$ent:\n$ent\n" if $debug;

    unlink($tmpfile);
    open(ENT, ">$tmpfile") || &nsexit("open $tmpfile: $!");
    print ENT $ent;
    close(ENT);

    if ($debug) {
       open(UPD, "$BINDIR/dbupdate -FvV -n 'NETWORK $rhost $name $logstr' <$tmpfile|") || &nsexit("pipe $BINDIR/dbupdate: $!");
    }
    else {
       open(UPD, "$BINDIR/dbupdate -Fv -n 'NETWORK $rhost $name $logstr' <$tmpfile|") || &nsexit("pipe $BINDIR/dbupdate: $!");
    }
        
    while(<UPD>) {
       print NS $_;
    }
    
    close(UPD);
    unlink($tmpfile);
}

sub GetVersionOne {
    
    local($version,$source,$from,$to);

    local($i)=$from;
          
    print NS "\%START Version: $version $source $from-$to\n\n";
    
    $i=$from;
    
    local($basename)=$LOGFILE{"SERIALDIR"}.$source;   
    local($oldbasename)=$LOGFILE{"OLDSERIALDIR"}.$source;   
       
    while ($i<=$to) {
       
       if (-f $basename.$i) {
          open(INP,"<".$basename.$i);
       }
       else {
          open(INP,"<".$oldbasename.$i);
       }
       
       &lock(INP);
       @input=<INP>;
       &unlock(INP); close(INP);
       
       print NS @input, "\n";
       
       $i++;
    }
       
    print NS "\%END $source\n";
} 

sub dogetserials {
    local($option,$name,$rhost)=@_;
    
    print STDERR "string: $string\n" if $debug;
        
    if (&allowupdate($rhost,*GETUPDATESFROM)) {
   
       if ($option=~ /^([\w\.\-]+)\:(\d+)\:(\d+)\-(\S+)$/) {
          local($source)=$1;
          local($version)=$2;
          local($from)=$3;
          local($to)=$4;
               
          local($i);
               
          local($first)=&getoldestserial($source);
          local($last)=&getcurrentserial($source);
               
          print STDERR "from: $from to: $to first: $first last: $last\n" if $debug;
               
          if ($to=~ /^LAST$/i) {
             $to=$last;
             if ($from==scalar($to+1)) {
                &syslog("QRYLOG","($$) [g:] 0 $name $option");
                &nscleanexit("Warning (1): There are no newer updates available");  
             }
          }
               
          if (($to<$first) || ($from>$to)) {
          
             &syslog("QRYLOG","($$) [g:] 0 $name -g syntax error 2: $first-$last, $option");
             &nsexit("2: Invalid range: $from-$to don\'t exist\n");
          }
               
          if ($to>$last) {
             local($range)=++$last;
          
             &syslog("QRYLOG","($$) [g:] 0 $name -g syntax error 3: $first-$last, $option");
             &nsexit("3: Invalid range: serial(s) $range-$to don\'t exist\n");
          }
       
          if ($from<$first) {
             local($range)=--$first;
          
             &syslog("QRYLOG","($$) [g:] 0 $name -g syntax error 4: $first-$last, $option");
             &nsexit("4: Invalid range: serial(s) $from-$first don\'t exist\n");
          }
       
          if ($version==1) {
             &GetVersionOne(1,$source,$from,$to);
          }
          else {
             
             #
             # I am sorry but we currently only support version 1 ...
             #
             
             &GetVersionOne($UPDATEVERSION,$source,$from,$to);
          
          }  
          
          return 1;
       }
       else {
          &syslog("QRYLOG","($$) [g:] 0 $name syntax error 1: $option");
          &nsexit("1: Syntax error in -g argument: $option\n");
       }
    }
    else {
       &syslog("AUDITLOG", "Get serial updates authorization failure: $rhost");
       &nsexit("\n\n***You are not authorized to get updates***\n\n***please contact \<$HUMAILBOX\> for more information***\n\n");
    }
}



#
# Main program
#

# Read config file from RIPEDBCNF, or set to default.

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

$result=0;

# If there are command line options, other than -d (for debug)
# do not run as daemon, but process the command line and exit.

if (($ARGV[0] ne "-d") && ($#ARGV>=0)) {
    local($cmdline) = "";
    
    for $i (0..$#ARGV) {
        $cmdline .= $ARGV[$i]." ";
    }
    
    $string=&parse($cmdline);
    
    $result=&whois(*source, $string, $name, $rhost);
    
    exit;
} 
else {
    if ($ARGV[0] eq "-d") {
        $opt_V=1;
        print STDERR "($$) running in debug mode\n";
        $debug = 1;
    } else {
        # detach from tty
        exit 0 if (fork() > 0);
        if (open(FILE, "/dev/tty")) {
            if (!ioctl(FILE,(0x20000000|(ord('t')<<8)|113),0)) {   
                print STDERR "ioctl: $!\n" if ($debug);
            }
            close(FILE);
        }
        close(0) if -t;
    }
}


($name, $aliases, $proto) = getprotobyname('tcp');
if ($port !~ /^\d+$/) {
    ($name, $aliases, $port) = getservbyport($port, 'tcp');
}

$this = pack($sockaddr, $AF_INET, $port, "\0\0\0\0");

select(NS); $| = 1; select(STDOUT);

socket(S, $AF_INET, $SOCK_STREAM, $proto) || die "socket: $!";

#
# || die "setsockopt: $!"; commented out.
#
# didn't work for perl4 & BSDI
#

setsockopt(S, $SOL_SOCKET, $SO_REUSEADDR, 1); # || die "setsockopt: $!";

while (!bind(S, $this)) {
    if ($bindcount >= 20) {
        print STDERR "whoisd: bind() failed 20 times, giving up\n";
        &syslog("ERRLOG", "whoisd cannot bind() for 20 times, giving up");
        exit 1;
    } else {
        print STDERR "-- bind: $!, trying again\n" if ($debug);
        $bindcount++;
        sleep 5;
    }
}

if ($bindcount) {
    &syslog("ERRLOG", "whoisd needed $bindcount binds before succeeding");
}

listen(S,5) || die "listen: $!";

select(S); $| = 1; select(STDOUT);

# Set up the alarm handler

$SIG{'ALRM'} = 'alarmhandler';

# We have come this far, let's write the PID to $PIDFILE, useful for
# killing and stuff.

if (open(PID, ">$LOCKDIR$PIDFILE")) {
    print PID "$$\n";
    close(PID);
} else {
    &syslog("ERRLOG", "cannot write to $PIDFILE: $!");
}

# Main waiting loop, wait for connection, and fork of child to process
# the incoming request

for (;;) {
    ($addr = accept(NS,S)) || die $!;

    if (($child = fork()) == 0) {
        ($af,$port,$inetaddr) = unpack($sockaddr,$addr);
        @inetaddr = unpack('C4', $inetaddr);

        $rhost = "$inetaddr[0].$inetaddr[1].$inetaddr[2].$inetaddr[3]";

        print STDERR "($$) fork connection [$rhost]\n" if $debug;

        local($name,$alias,$at,$len,@addr)=gethostbyaddr($inetaddr,$af);
        if ($name eq "") {
            $name = $rhost;
        }                

        # Set alarm to timeout after people did not send anything

        alarm $KEEPOPEN;

        while(<NS>) {

            # Got something, reset alarm;

            alarm 0;

            chop;
            
            # we want at least some alphanumeric stuff ...
            if (/\w+/) {
            
                $string = &parse($_);
                print STDERR "($$) lookup $string\n" if $debug;
                
                select(NS);
                
                ($result)=&whois(*source, $string, $name, $rhost);
                
                print NS $NOMATCH,"\n" if $result == 0;
                print NS $TOOMANY,"\n" if $result ==-1;
                
                &flush(NS);
                select(STDOUT);

                if ($opt_k) {
                   print NS "\n";
                   alarm $KEEPOPEN;
                }
                else {
                   &flush(NS);
                   close(NS);
                }
            
            }
            # got something completely non-alphanumeric
            else {
                select(NS);
                $string = $_;
                print STDERR "($$) lookup $string\n" if $debug;
                print NS "Cannot lookup non-alphanumeric keys\n";
                print NS "Connection closed\n";
                $result = 0;
                &flush(NS);
                select(STDOUT);
                close(NS);
            }

            # Log this query

            $flags = "";
            for $fl ("d","a","g","s","k","r","F","t","S","T","U","M","m","L") {
                if (eval "\$opt_$fl;") {
                    if ($flags) {
                        $flags .= ":";
                    }
                    $flags .= "$fl";
                }
            }
            if ($opt_V) {
                if ($flags) {
                    $flags .= ":";
                }
                $flags .= "V$opt_V";
            }
            
            &syslog("QRYLOG","($$) [$flags] $result $name $string");
            
        }
        &flush(NS);
        close(NS);

        print STDERR "($$) exit connection [$rhost]\n" if $debug;
        exit;
    }
    while (waitpid(-1, 1) > 0) {}
    
}
