#       dbopen - open a database
#
#	$RCSfile: dbopen.pl,v $
#	$Revision: 0.16 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
# arguments:
#            $handle = file handle to dbm and flat file
#            *entry  = pointer to object, determines what file to open
#            $write  = open for write or not
#            $name   = open a file independent of type

sub dbopen {

    local($handle, *entry, $write, $name) = @_;

    if (!$name) {
	local($source) = $entry{"so"};
	$name = $DBFILE{$source};
	local($lockfile) = "";
	local($type) = &entype(*entry);

	if ($TYPE{$source} eq "SPLIT") {
	    $name .= ".".$type;
	}
    }

    if ($write) {

	# If we want to open the dbfile for writing, make sure that
	# cleandb is not using the database. If it is there will be a
	# race condition between rename and open.

	# the file name used for this lockfile is $CLEANLOCK, concatenated
	# with the database filename (no full path)

	$name =~ /([^\/]+)$/;
	local($fileext) = $1;

	if ($TYPE{$source} eq "SPLIT") {
	    $lockfile = "$LOCKDIR$CLEANLOCK.$fileext.$type";
	} else {
	    $lockfile = "$LOCKDIR$CLEANLOCK.$fileext";
	}
	
	while (-e "$lockfile") {
	    sleep 60;
	}
        if (eval "open($handle, \"+<$name\") || return 0;") {
	    eval "select($handle);";
	    eval "\$| = 1;";
	    eval "select(STDOUT);";
	    eval "dbmopen(%$handle, \"$name\", 0666);";
	    eval "\$$handle\[0\] = 1;";
	    eval "\$$handle\[1\] = \"$name\";";

	    # Moved away to seperate routine below
	    # dbmopen(%mspnxl, $name.".".$CLASSLESSEXT, 0666);

	    return 1;
	}
	else {
	    return 0;
	}
    } else {
	if (eval "open($handle, \"$name\") || return 0;") {
            eval "dbmopen(%$handle, \"$name\", 0666);";
            eval "\$$handle\[0\] = 1;";
            eval "\$$handle\[1\] = \"$name\";";

	    # Move to seperate routing below
	    # dbmopen(%mspnxl, $name.".".$CLASSLESSEXT, undef);

	    return 1;
        }
        else {
            return 0;
        }
    }
}

# Now, for classless we have a seperate database. Due to a slight design
# error (err'hum) we have to open this seperately. It will keep track
# of things. Thing to achieve here is to *never* have two classless
# indexes open at the same time. This should be done differently but
# we have to get things thing running. Usually you would call this
# for a lookup and an insert that requires classless thingies.

# So, once more: ONLY ONE OPEN AT THE SAME TIME!!!!

sub dbclopen {
    local(*entry, $write, $name) = @_;

    if ($CLSTATUS == 1) {
	print STDERR "Classless index already open!!!!\n";
	return;
    }
    if (!$name) {
	local($source) = $entry{"so"};
	$name = $DBFILE{$source};
	local($lockfile) = "";
	local($type) = &entype(*entry);

	if ($TYPE{$source} eq "SPLIT") {
	    $name .= ".".$type;
	}
    }

    # This is a bit yucky, but I need it in here....

    $OVERFLOWPREFIX = $name;

    if ($write) {

	$name =~ /([^\/]+)$/;
	local($fileext) = $1;

	# No need to check for lockfiles, is done by normal db opening

	dbmopen(%mspnxl, $name.".".$CLASSLESSEXT, 0666);

	$CLSTATUS = 1;

    } 
    else {
	dbmopen(%mspnxl, $name.".".$CLASSLESSEXT, undef);
    }
}

sub dbclclose {
    dbmclose(%mspnxl);
    $CLSTATUS = 0;
}
	
1;
