#!/bin/sh

# Copyright (c) 2000                    RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# build.sh
# This script is a wrapper to configure with some site-specific variables
# (mainly locations of external packages) set.
# It does not "build" everything per se, but you can always just
# put a "gmake" as the last line.:)

# Where is the glib-config script
GLIBCONF=/usr/local/bin/glib-config

# MySQL include and lib directories
MYSQLINC=/usr/local/include/mysql
MYSQLLIB=/usr/local/lib/mysql

# c-client build directory
CCLIENTDIR=/usr/local/build/imap/c-client

## Environment variables to pass to configure
# All warnings on 
#CC="gcc -Wall"
# Solaris Workshop C
#CC="ucbcc -xCC"
# Don't forget to export all the variables you pass
#export CC

#Supplementary arguments to configure: taken from command line
CONFIGARGS="$@"

# Invoke the configure script
./configure \
--with-mysqlinc=$MYSQLINC \
--with-mysqllib=$MYSQLLIB \
--with-cclientdir=$CCLIENTDIR \
--with-glibconfig=$GLIBCONF \
$CONFIGARGS

