#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>

#include <ud.h>
#include <ud_int.h>
#include <constants.h>
#include <properties.h>


#include "ca_configFns.h"
#include "ca_dictSyms.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"




void stop_updates()
{
 char print_buf[STR_M];
 
 fprintf(stderr, "Updates interrupted..\n");
 sprintf(print_buf, "%d", 0);
 CO_set_const("UD.do_update", print_buf);
 return;
}
                      



/***********************************************
******* MAIN **********************************
***********************************************/


int main(int argc, char** argv) {
  FILE *file = NULL;
  FILE *logfile;
  char *logname="log.XXXX";
int c;
extern int optind;
extern char *optarg;
int errflg = 0;
int dummy_allowed;
int start_object;
int num_ok, num_failed;
long num_skip=0;
struct _nrtm *nrtm=NULL;
UD_stream_t ud_stream;
Log_t log;
int current_serial=-1;
int load_pass=0;
int delay=1;
char *prop_file_name=NULL;
char *logfilename=NULL;
int do_update;
char *source_name = "RIPE";
ca_dbSource_t *source_hdl;
char *db_host, *db_name, *db_user, *db_passwd;
int db_port;



struct sigaction sig;
  
  num_ok=0; num_failed=0;
  dummy_allowed=0;
  
//  strcpy(db_host, "rowan.ripe.net");

  start_object = 1;

	while ((c = getopt(argc, argv, "n:M:L:p:s:?")) != EOF)
		switch (c) {
		case 'n':
			num_skip=atol(optarg);
			break;	
		case 'p':
			prop_file_name = optarg;
			break;
		case 'L':
			load_pass=atoi(optarg);
			dummy_allowed=1;
			break;
		case 's':
		        source_name=optarg;
			break;
		case '?':
		default :
			errflg++;
			break;
		}
		if (errflg) {
			fprintf(stderr,"usage: standalone [-L pass#] [-n num_skip] [-p properties] file\n");
			exit (2);
		}


sig.sa_handler=stop_updates;
sigemptyset(&sig.sa_mask);
sig.sa_flags=SA_RESTART;
sigaction(SIGINT, &sig, NULL);
sigaction(SIGTERM, &sig, NULL);

  /* 2. Load properties object from prop_file. */
  fprintf(stderr,"Properties:\n");
  if(prop_file_name==NULL)prop_file_name=".properties";
  PR_load(prop_file_name);
  fprintf(stderr,"%s\n", PR_to_string() );
      
  /* 3. Set the constants. */
  fprintf(stderr,"Constants:\n");
  CO_set();
  fprintf(stderr,"%s\n", CO_to_string() );
            
 /* 3a. Populate dictionary and load config */
  ca_populateDictionary(dictionary, VARS);
  ca_readConfig(CO_get_config_file(), confVars, VARS);
  fprintf(stderr, "Configuration file: %s - ok\n", CO_get_config_file());


/* set mode of operation: unprotected (dummy allowed), updates, standalone */
   ud_stream.ud_mode=7;
   
/* get the source handle */
  source_hdl = ca_get_SourceHandleByName(source_name);

/* get error log facility */
  logfilename=ca_get_srcnrtmlog(source_hdl);
     
                        
/* Connect to the database */
   db_host = ca_get_srcdbmachine(source_hdl);
   db_port = ca_get_srcdbport(source_hdl);
   db_name = ca_get_srcdbname(source_hdl);
   db_user = ca_get_srcdbuser(source_hdl);
   db_passwd = ca_get_srcdbpassword(source_hdl);
 
/*   fprintf(stderr, "D: Making SQL connection to %s@%s ...", CO_get_database(), CO_get_host()); */
  fprintf(stderr, "D: Making SQL connection to %s@%s ...", db_name, db_host);

/*  ud_stream.db_connection=SQ_get_connection2(); */
  ud_stream.db_connection=SQ_get_connection(db_host, db_port, db_name, db_user, db_passwd);
     
 
  if(! ud_stream.db_connection) {
   fprintf(stderr, "D: ERROR: no SQL connection\n");
    return;
  }
  	
  fprintf(stderr, "OK\n");

			    
									                                    
 ud_stream.nrtm=NULL;
                                            
 ud_stream.log.logfile = fopen(logfilename, "a+");
 ud_stream.log.num_ok=0;
 ud_stream.log.num_failed=0;

  free(db_host);
  free(db_name);
  free(db_user);
  free(db_passwd);
  free(logfilename);


 if(optind<argc) file=fopen(argv[optind], "r"); else file=stdin;

 if (file==NULL) { 	fprintf(stderr, "Cannot open data stream. Exiting..\n");
			exit(1); }


  ud_stream.stream=file;
  ud_stream.num_skip=num_skip;
  ud_stream.load_pass=load_pass;

/* Start to process the stream */

fprintf(stderr, "starting processing stream\n");
  num_ok=UD_process_stream(&ud_stream);
fprintf(stderr, "processing stream finished\n");
fprintf(stderr, "%d objects processed\n", num_ok);

return(0);

} /* main() */




