/***************************************
  $Revision: 1.35 $

  Protocol whois module (pw).  Whois protocol.

  Status: NOT REVUED, TESTED

  ******************/ /******************
  Filename            : protocol_whois.c
  Authors             : ottrey@ripe.net
                        marek@ripe.net
  OSs Tested          : Solaris
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <glib.h>

#include "NAME"

#include "defs.h"
#include "protocol_whois.h"
#include "mysql_driver.h"
#include "query_command.h"
#include "query_instructions.h"
#include "constants.h"
/*
#include "objects.h"
*/
#include "access_control.h"
#include "socket.h"
#include "stubs.h"

#include "ca_configFns.h"
#include "ca_dictSyms.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"

#include "protocol_mirror.h"

#include "ta.h"

#include  "timediff.h"

void print_hello_banner(Query_environ *qe) { 
  SK_cd_puts(&(qe->condat), CVS_NAME);
  SK_cd_puts(&(qe->condat), "% Rights restricted by copyright. \n% See http://www.ripe.net/ripencc/pub-services/db/copyright.html\n");

#if 0
  /* Send the environment aswell. */
  SK_cd_puts(&(qe->condat), "% Environment={");
  str1 = QC_environ_to_string(*qe);
  SK_cd_puts(&(qe->condat), str1);
  wr_free(str1);
  SK_cd_puts(&(qe->condat), "}\n");
#endif

  SK_cd_puts(&(qe->condat), "\n");
}


void
strchop(char *input)
{
  char *co = strchr(input, '\0');
  while( co != input && (isspace(*co) || *co == '\0') ) {
    *co = '\0';
    co--;
  }
}


static
void pw_log_query( Query_environ *qe, 
		   Query_command *qc, 
		   acc_st *copy_credit,   
		   ut_timer_t begintime,   
		   ut_timer_t endtime, 
		   char *hostaddress, 
		   char *input) 
{
  char *qrystat = AC_credit_to_string(copy_credit);
  float elapsed;	  
  char *qrytypestr =
    qc->query_type == QC_REAL ? "" : QC_get_qrytype(qc->query_type);
  
  
  elapsed = UT_timediff( &begintime, &endtime);
  
  /* log the connection/query/#results/time/denial to file */ 
  ER_inf_va(FAC_PW, ASP_PWI_QRYLOG,
	    "<%s> %s%s %.2fs [%s] --  %s",
	    qrystat, 
	    qe->condat.rtc ? "INT " : "",
	    qrytypestr,
	    elapsed, hostaddress, input
	    );
  wr_free(qrystat);
}

     


er_ret_t PW_process_qc(Query_environ *qe, 
		   Query_command *qc,
		   acc_st *acc_credit, 
		   acl_st *acl_eip )
{
  GList *qitem;
  Query_instructions *qis=NULL;
  er_ret_t err;

  switch( qc->query_type ) {
      case QC_SYNERR:
	SK_cd_puts(&(qe->condat), USAGE);
	/* FALLTHROUGH */
      case QC_PARERR:
	/* parameter error. relevant error message is already printed */ 
	
	/* force disconnection on error */
	qe->k = 0;
	break;
      case QC_NOKEY:
	/* no key (this is OK for some operational stuff, like -k) */
	break;       
      case QC_EMPTY:
        
	/* The user didn't specify a key, so
	   - print moron banner
	   - force disconnection of the user. */
	SK_cd_puts(&(qe->condat), "% No search key specified\n");
	qe->condat.rtc = SK_NOTEXT;
	break;
      case QC_HELP:
	SK_cd_puts(&(qe->condat), "% Nothing can help you anymore...:-)\n");
	break;
      case QC_TEMPLATE:
	switch(qc->q) {
	case QC_Q_SOURCES:
	  /* print source & mirroring info */
	  {
	    GString *srcs = PM_get_nrtm_sources( & qe->condat.rIP, NULL);
	    SK_cd_puts(&(qe->condat), srcs->str);
	    g_string_free (srcs, TRUE);
	  }
	  break;
	case QC_Q_VERSION:
	  SK_cd_puts(&(qe->condat), "% RIP version " VERSION "\n"); 
	  break;
	default: 
	  /* EMPTY */;
	} /* -q */
	
	if (qc->t >= 0) {
	  SK_cd_puts(&(qe->condat), DF_get_class_template(qc->t)); 
	}
	if (qc->v >= 0) {
	  SK_cd_puts(&(qe->condat), DF_get_class_template_v(qc->v)); 
	}
	break;
	
      case QC_FILTERED:
	SK_cd_puts(&(qe->condat), "% Note: this output has been filtered.\n% Only primary keys will be visible.\n% Contact information will not be shown\n\n");
	
	/* FALLTROUGH */
      case QC_REAL:
	qis = QI_new(qc,qe);
	
	/* stop as soon as further action considered meaningless */
	for( qitem = g_list_first(qe->sources_list);
	     qitem != NULL && qe->condat.rtc == 0;
	     qitem = g_list_next(qitem)) {
	  
	  /* QI will decrement the credit counters */
	  err = QI_execute(qitem->data, qis, qe, acc_credit, acl_eip );
	  
	  if( !NOERR(err) ) { 
	    if( err == QI_CANTDB ) {
	      SK_cd_puts(&(qe->condat), "% WARNING: Failed to make connection to ");
	      SK_cd_puts(&(qe->condat), (char *)qitem->data);
	      SK_cd_puts(&(qe->condat), " database.\n\n");
	    }
	    
	    break; /* quit the loop after any error */
	  }/* if */
	  
	}/* for every source */

	QI_free(qis);
	
	if( AC_credit_isdenied(acc_credit) ) {
	  SK_cd_puts(&(qe->condat),
 "% You have reached the limit of returned contact information objects.\n"
 "% This connection will be terminated now.\n"
 "% This is a mechanism to prevent abusive use of contact data in the RIPE Database.\n"
 "% You will not be allowed to query for more CONTACT information for a while.\n"
 "% Continued attempts to return excessive amounts of contact\n"
 "% information will result in permanent denial of service.\n"
 "% Please do not try to use CONTACT information in the\n"
 "% RIPE Database for non-operational purposes.\n"
 "% Refer to http://www.ripe.net/db/dbcopyright.html for more information.\n"
		       );
	}
	
	break;
      default: die;
      }
  
  return err;
}

/* PW_interact() */
/*++++++++++++++++++++++++++++++++++++++
  Interact with the client.

  int sock Socket that client is connected to.

  More:
  +html+ <PRE>
  Authors:
        ottrey (original CP/M version)
	marek

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
void PW_interact(int sock) {
  char input[MAX_INPUT_SIZE];
  int read_result;
  char *hostaddress=NULL;
  acl_st acl_rip,   acl_eip;
  acc_st acc_credit, copy_credit;
  Query_environ *qe=NULL;
  Query_command *qc=NULL;
  ut_timer_t begintime, endtime;

  
  /* Get the IP of the client */
  hostaddress = SK_getpeername(sock);	  
  ER_dbg_va(FAC_PW, 1, "connection from %s", hostaddress);
  
  /* Initialize the query environment. */
  qe = QC_environ_new(hostaddress, sock);
  
  /* init to zeros */
  memset( &(qe->condat), 0, sizeof(sk_conn_st));

  /* set the connection data: both rIP and eIP to real IP */
  qe->condat.sock = sock;
  qe->condat.ip = hostaddress;
  SK_getpeerip(sock, &(qe->condat.rIP));
  qe->condat.eIP = qe->condat.rIP;

  qe->condat.rd_timeout.tv_sec = 180; /* read timeout */

  /* see if we should be talking at all */
  /* check the acl using the realIP, get a copy applicable to this IP */
  AC_check_acl( &(qe->condat.rIP), NULL, &acl_rip);
  
  do {
    int unauth_pass=0;

    TA_setactivity("waiting for query");
    /* Read input */
    read_result = SK_cd_gets(&(qe->condat), input, MAX_INPUT_SIZE);
    /* trash trailing whitespaces(including \n) */
    strchop(input);
      
    TA_setactivity(input);
    TA_increment();

    UT_timeget( &begintime );
    
    qc = QC_create(input, qe);

    print_hello_banner(qe);

    /* ADDRESS PASSING: check if -V option has passed IP in it */
    if( ! STRUCT_EQUAL(qe->pIP,IP_ADDR_UNSPEC)) {
      if(acl_rip.trustpass) {     
	acc_st pass_acc;

	/* accounting */
	memset(&pass_acc, 0, sizeof(acc_st));
	pass_acc.addrpasses=1;
	AC_commit( &qe->condat.rIP, &pass_acc, &acl_rip);

	/* set eIP to this IP */
	qe->condat.eIP = qe->pIP;                 
      }
      else {
	/* XXX shall we deny such user ? Now we can... */
	ER_inf_va(FAC_PW, ASP_PWI_PASSUN, 
		  "unauthorised address passing by %s", hostaddress);
	unauth_pass = 1; /* keep in mind ... */
      }
    } /* if an address was passed */
    
    /* start setting counters in the connection acc from here on 
       decrement the credit counter (needed to prevent QI_execute from
       returning too many results */
    
    /* check ACL. Get the proper acl record. Calculate credit */
    AC_check_acl( &(qe->condat.eIP), &acc_credit, &acl_eip);
    /* save the original credit, later check how much was used */
    copy_credit = acc_credit;

    copy_credit.connections ++;

    /* printing notices */
    if( unauth_pass && ! acl_rip.deny ) {
      SK_cd_puts(&(qe->condat), /* print only if not yet completely denied */
"% Sorry, you are not allowed to pass addresses on the query line.\n"
"% Please contact us for such permission. For the moment, continuing\n"
"% this will cause permanent denial of the access\n");
    }
    if( acl_eip.deny || acl_rip.deny ) {
      SK_cd_puts(&(qe->condat), 

"% Sorry, access from your host has been permanently denied\n"
"% because of a repeated abusive behaviour.\n"
"% Please contact <ripe-dbm@ripe.net> for unblocking\n");
    }
    
    if( acl_eip.deny || acl_rip.deny || unauth_pass ) {
      copy_credit.denials ++; 
    }
    else {
      /************ ACTUAL PROCESSING IS HERE ***********/
      PW_process_qc(qe, qc, &acc_credit, &acl_eip);

      if( qc->query_type == QC_REAL ) {
	copy_credit.queries ++;
      }
    }/* if denied ... else */
      
    /* calc. the credit used, result  into copy_credit 
       This step MUST NOT be forgotten. It must complement
       the initial calculation of a credit, otherwise accounting
       will go bgzzzzzt.
    */
    AC_acc_addup(&copy_credit, &acc_credit, ACC_MINUS);
    
    /* now we can check how many results there were, etc. */
    if(  ! AC_credit_isdenied(&acc_credit) ) {
      if( (qc->query_type == QC_REAL || qc->query_type == QC_FILTERED)
	  && copy_credit.private_objects + copy_credit.public_objects
	  + copy_credit.referrals == 0 ) {
	SK_cd_puts(&(qe->condat),
"% No entries found for the selected source(s).\n"
"%\n"
"% If you would like to search on arbitrary strings,\n"
"% please see the Database page on the RIPE NCC\n"
"% web-site at http://www.ripe.net/ripencc/pub-services/db/\n"
"% This will only work for RIPE data.\n"
"%\n"
"% Please note that the RIPE whoisd service temporarily\n"
"% mirrors only ARIN and APNIC databases.\n");
      }

      UT_timeget(&endtime);
      /* query logging */
      pw_log_query(qe, qc, &copy_credit, begintime, endtime, 
		   hostaddress, input);

      /* Commit the credit. This will deny if bonus limit hit 
	 and clear the copy */ 
      AC_commit(&(qe->condat.eIP), &copy_credit, &acl_eip); 

    } /* if ! denied ... (after credit addup) */

    /* end-of-result -> one extra line */
    SK_cd_puts(&(qe->condat), "\n");
      
    QC_free(qc);      
  } /* do */
  while( qe->k && qe->condat.rtc == 0 
	 && AC_credit_isdenied( &copy_credit ) == 0
	 && CO_get_whois_suspended() == 0);

  /* Free the hostaddress */
  wr_free(hostaddress);

  SK_cd_close(&(qe->condat));
  
  /* Free the query_environ */
  QC_environ_free(qe);

} /* PW_interact() */
