#ifndef UPDATE_UPPER_H
#define UPDATE_UPPER_H


#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 
#include <stubs.h>
#include <string>
#include <glib.h>
#include <iostream.h>
#include <fstream>

#include <netdb.h> 
#include <sys/types.h> 
#include <netinet/in.h> 
#include <sys/socket.h> 
#include <errno.h> 
#include <unistd.h>

#include <config.h>
#include <istream.h>
#include "rpsl/object.hh"
#include "util/rusage.hh"
#include "util/debug.hh"
#include "util/trace.hh"
#include "util/Argv.hh"
#include "util/version.hh"
#ifdef IRR_NEEDED
#include "irr/irr.hh"
#include "irr/rawhoisc.hh"
#endif // IRR_NEEDED
#include "rpsl/schema.hh"
#include "erroutines.h"
#include "AU_util.h"
#include "ack.h"
#define private private_xx
#include "mm.h"
#undef private


#define MAXDATASIZE 100 /* max number of bytes we can get at once */

#define UPDATE_HOST "reimp.ripe.net"
#define UPDATE_PORT 4346 
#define QUERY_HOST "reimp.ripe.net"
#define QUERY_PORT 4343

#define OVR_OK 0 /* override succeded */


#define UPDATE_SOURCE "RIPE"

#define ACK_FILE_PREFIX "ack"


#ifdef __cplusplus
extern "C" {
#endif



int send_object_db(char * arg, char * assigned_NIC, char * operation);

char * get_type(Object *arg);

char * get_search_key(Object *arg, char * type, const char * text);

char * send_and_get(char * host, int port, char * arg);

int count_objects(char * arg);

char * take_object(char * arg);

char * get_as_block(char *autnum_object);

char * get_less_specific_domain(char *domain_object);

char * get_less_specific_set(char *set_object, char *type);

char * get_less_specific(char *inetnum_object, char *type);

GSList *get_mntners(char * object);

GSList *get_auths(char * object);

GSList *get_attr_list(char * object, char * attr_type);

GSList *get_mnt_lowers(char * object);

char *get_override(char * object);

int check_override(char * string);

GSList * add_to_auth_vector(GSList * list_of_auth_struct, GSList * auths, char * mntner_name);

GSList * get_auth_vector(GSList * mntners);

GSList * get_mntnfy_vector(GSList * mntners);

int check_auth(char *new_object, char *old_object, char *type, credentials_struct credentials);

char * get_old_version(char * arg);

//int process_object(char * arg, credentials_struct credentials, GHashTable * NIC_hdl_hash, char * ack_file_name);

void process_mail_header(credentials_struct * credentials_ptr ,char * header);

int has_ref_to_AUTO_nic_hdl(const char * object);

char * find_to_address(const char * from_line);

char * replace_refs_to_AUTO_NIC_hdl(char * changed_obj, char * arg, GHashTable * auto_nic_hash);

int identical(const char * old_version, const char * new_version);

int has_AUTO_NIC_hdl(const char * object);

char * replace_AUTO_NIC_hdl(char * arg, char * auto_nic_hdl);


#ifdef __cplusplus
}
#endif

#endif
