/***************************************
  $Revision: 1.2 $

  Functions to interface with RX module (create/update rx-nodes)

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#include "ud_int.h"
#include "rxroutines.h"

void save_rx_pref(rx_bin_data_t *rx_data, unsigned int prefix, unsigned int prefix_length)
{
ip_prefix_t *myprefptr = &(rx_data->mypref);

  memset(myprefptr, 0, sizeof(ip_prefix_t));
  myprefptr->ip.space = IP_V4;
  myprefptr->ip.words[0] = prefix;
  myprefptr->bits = prefix_length; 

}

void save_rx_orig(rx_bin_data_t *rx_data, char *origin)
{
  rx_data->origin = origin;
}


void save_rx_rang(rx_inum_data_t *rx_data, unsigned int begin_in, unsigned int end_in)
{
ip_range_t *myrangptr = &(rx_data->myrang);

  memset(myrangptr, 0, sizeof(ip_range_t));
  myrangptr->begin.space =  myrangptr->end.space = IP_V4;
  myrangptr->begin.words[0] = begin_in;
  myrangptr->end.words[0] = end_in;
  
}


int update_rx_inum(rx_oper_mt mode, rx_tree_t *mytree, rx_inum_data_t *rx_data, long in_id)
{
ip_range_t *myrangptr = &(rx_data->myrang);
rx_dataleaf_t *leafptr;
char prstr[IP_RANGSTR_MAX];

  if( wr_calloc( (void **)& leafptr, sizeof(rx_dataleaf_t), 1) != UT_OK) return(-1);                        
  
  leafptr->data_key = in_id;
 
  if(mode != RX_OPER_DEL) {
    if( IP_rang_b2a( myrangptr, prstr, IP_RANGSTR_MAX) != IP_OK ) return(-1);
                                    
#define PAYLOAD_INETNUM_LENGTH strlen("inetnum:\t\n")

    leafptr->data_len = PAYLOAD_INETNUM_LENGTH + 1 + strlen(prstr);
    if( wr_calloc( (void **) & leafptr->data_ptr, leafptr->data_len, 1) != UT_OK) return(-1);
  
    if( snprintf(leafptr->data_ptr, leafptr->data_len, 
     "inetnum:\t%s\n", prstr ) > leafptr->data_len ) return(-1);
  }
     
  
  if( RX_inum_node( mode, myrangptr, mytree, leafptr ) != RX_OK ) {
    fprintf(stderr,"%ld\t%s\n", in_id, prstr);
    return(-1);
  }
                        
return(0);
}



int update_rx_bin(rx_oper_mt mode, rx_tree_t *mytree, rx_bin_data_t *rx_data, long rt_id)
{
rx_dataleaf_t *leafptr;
ip_prefix_t *myprefptr = &(rx_data->mypref);
char prstr[IP_PREFSTR_MAX];


  if( wr_calloc( (void **)& leafptr, sizeof(rx_dataleaf_t), 1) != UT_OK) return(-1);
  
  leafptr->data_key = rt_id;
  
  if(mode != RX_OPER_DEL) {
    if( IP_pref_b2a( myprefptr, prstr, IP_PREFSTR_MAX) != IP_OK ) return(-1);
                          
#define PAYLOAD_ROUTE_LENGTH strlen("route:\t/\norigin:\t\n")                          

    leafptr->data_len = PAYLOAD_ROUTE_LENGTH + 1 
		+ strlen(prstr) + strlen(rx_data->origin);
           
    if( wr_calloc( (void **) & leafptr->data_ptr, leafptr->data_len, 1)!= UT_OK) return(-1);
                              
    if( snprintf(leafptr->data_ptr, leafptr->data_len,
     "route:\t%s\norigin:\t%s\n", prstr, rx_data->origin ) > leafptr->data_len ) return(-1);
  }   

  if( RX_bin_node( mode, myprefptr, mytree, leafptr ) != RX_OK ) {
    fprintf(stderr,"%ld\t%s\n", rt_id, rx_data->origin);
    return(-1);
  }
  
return(0);  
}

