/***************************************
  $Revision: 1.4 $

  Semi-internal header file for UD module

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#ifndef _UD_INT_H
#define _UD_INT_H

#include <stdio.h>
#include <strings.h>
#include <glib.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>

#include "defs.h"
#include "mysql_driver.h"
#include "iproutines.h"
#include "rxroutines.h"


#include "globaldefs.h"
// #include "isnic.h" 
#include "bitmask.h"
#include "which_keytypes.h"


/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383
#define STR_XXXL 65535


#define MAX_NIC_HDL  20


/* row# of object.id in the table */
#define OBJECT_ID	1

/* class type for dummy objects */
#define DUMMY_TYPE	100


typedef struct _Attribute_t { 
  A_Type_t type;
  char *value;
} Attribute_t;

typedef struct _Object_t {
  C_Type_t type;
  long id;
  GSList *attributes;
  GString *object;
} Object_t;

#define MAX_DUMMIES 16

typedef struct _Transaction {
  SQ_connection_t *sql_connection;
  Object_t *object; // ptr to the object
  int thread_ins; // Thread number to mark(backup) creates 
  int thread_upd; // Thread number to mark(backup) updates
  long object_id; // Object id which the transaction is carried out for
  long sequence_id; // for last and history tables
  int dummy; // Permission to create dummies for PE, RO objects (initial population)
  int ndummy; // number of attempts to create dummy
  long dummy_id[MAX_DUMMIES]; // to store object_id's of dummies
  int action; // indicates wether we are updating/deleting creating a new object
  int load_pass; // No. of te pass for initial loading , 0 otherwise
  int standalone; // 0 if server
  C_Type_t class_type;
  int succeeded;
  int error;
  GString *error_script;
  void *save;
} Transaction_t;

/*++++++++++++++++++++++++++++++++++++++++++++*/

/* Definitions for "refer" (domain referral mechanism) */
#define S_RIPE "RIPE"
#define S_INTERNIC "InterNIC"
#define S_SIMPLE "SIMPLE"

#define RF_RIPE	1
#define RF_INTERNIC 2
#define RF_SIMPLE 0
#define RF_DEF_PORT	43


#define CURRENT_SERIAL_FILE "./RIPE.CURRENTSERIAL"
//#define NRTM_ADD        1
//#define NRTM_DEL        2
#define OP_ADD	        1
#define OP_DEL	        2
#define OP_UPD	        3
#define OP_NOOP         4

#define _NRTM_PORT	43
#define _NRTM_VERSION	1
#define _DB_PORT	3306
#define _DB_NAME	"andrei"
#define _DB_USER        "dbint"
#define _DB_PSWD        "reimp"

#define IS_DUMMY_ALLOWED(a)     ((a)&0x01)
#define IS_UPDATE(a)            ((a)&0x02)
#define IS_STANDALONE(a)        ((a)&0x04)

struct _nrtm {
 char *server;
 int port;
 int version;
 int current_serial;
 Transaction_t *tr;
 char object_name[STR_M];
 int op;
};
       
typedef struct UD_stream_t_ {
 FILE * stream;
 int num_skip;
 int load_pass;
// int dummy_allowed;
 int ud_mode;
 struct _nrtm *nrtm;
 char *db_host;
 int  db_port;
 char *db_name;
 char *db_user;
 char *db_pswd;
 char *log; 
 char *error_script;
} UD_stream_t;
         
typedef struct _Log_t {
 int num_ok;
 int num_failed;
 FILE *logfile;
} Log_t;

// Stuff needed for radix trees.
//Here we save attributes. br-r-r...

typedef struct rx_bin_data_t_ {
  ip_prefix_t mypref;
  char *origin;
} rx_bin_data_t;
  
typedef struct rx_inum_data_t_ {
  ip_range_t myrang;
//  char *origin;
} rx_inum_data_t;
    
       
   
                
#define TR_UPDATE	1000
#define TR_INSERT	2000
#define TR_CREATE	TR_INSERT
#define TR_DELETE       3000

/* res_type for mysql_info */
#define SQL_RECORDS 0
#define SQL_MATCHES 0 // for UPDATE queries (checking for duplicates)
#define SQL_DUPLICATES 1
#define SQL_WARNINGS 2


/*++++++++++++++++++ Function Prototypes +++++++++++++++++++++*/

FILE *get_NRTM_stream(struct _nrtm *nrtm, int upto_last);

int UD_process_stream(UD_stream_t *ud_stream);

int object_process(Transaction_t *tr);

int commit(Transaction_t *tr);

int rollback(Transaction_t *tr);

int delete(Transaction_t *tr);


long get_object_id(Transaction_t *tr);
long get_sequence_id(Transaction_t *tr);
char *get_field_str(Transaction_t *tr, char *field,
                 char *ref_tbl_name, char *ref_name,
                 char * attr_value, char *condition);


void attribute_free(void *data, void *ptr);

Attribute_t *attribute_new1(int type, const char *value);

Attribute_t *attribute_new(const char *line);

void object_free(Object_t *obj);

Object_t *object_new(const char *line);

void transaction_free(Transaction_t *tr);

Transaction_t *transaction_new(SQ_connection_t *sql_connection, C_Type_t class_type);

void save_rx_pref(rx_bin_data_t *rx_data, unsigned int prefix, unsigned int prefix_length);
void save_rx_orig(rx_bin_data_t *rx_data, char *origin);
void save_rx_rang(rx_inum_data_t *rx_data, unsigned int begin_in, unsigned int end_in);
int update_rx_inum(rx_oper_mt mode, rx_tree_t *mytree, rx_inum_data_t *rx_data, long in_id);
int update_rx_bin(rx_oper_mt mode, rx_tree_t *mytree, rx_bin_data_t *rx_data, long rt_id);


er_ret_t expand_rt(char *avalue, unsigned int *prefix, unsigned int *prefix_length);
er_ret_t convert_if(char *avalue, unsigned int *address);
er_ret_t convert_in(char *rangstr, unsigned int *begin_in, unsigned int *end_in);
char *convert_rf(char *avalue, int *type, int *port);
int convert_as_range(const char *as_range, int *begin, int *end);
time_t convert_time(char *asc_time);




#endif /* _UD_INT_H */

