/***************************************
  $Revision: 1.6 $

  Definitions module (df)

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : defs.c
  Author              : ottrey@ripe.net
  OSs Tested          : Solaris
  Related Modules     : 
  Problems            : 
  To Do               : 
  Comments            :
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <strings.h>
#include <glib.h>

/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

#include "defs.h"
#include "memwrap.h"

#include "DF_class_names.def"
#include "DF_class_codes.def"
#include "DF_class_aliases.def"
#include "DF_class_aliases_map.def"
#include "DF_class_dbase_code_map.def"
#include "DF_class_templates.def"
#include "DF_class_templates_v.def"

#include "DF_attribute_names.def"
#include "DF_attribute_codes.def"
#include "DF_attribute_aliases.def"
#include "DF_attribute_aliases_map.def"

/*+ Source database mirrors +*/
typedef struct {
  char src[32];
  char db[32];
} source_info_t;

source_info_t const Sources[] = {
  {"RIPE","RIPE6"},
  
  /*  "ARIN",
      "APNIC",
  */
  
  {"",""}
}; /* Sources */

/* getsubopt requires a vector of pointers to a list of possible options
   It's used for parsing the source list.
   Therefore a quick 
 XXX  !!!!
   hack: hardcode it. Will be initialised from the Sources array 
   once the config module is defined
*/

char * const Sources_vector[] = {
  "RIPE",
  NULL
};

char * const  Server_queries[] = {
  "help",
  "sources",
  "version",
  "version",
  NULL
}; /* Server_queries */

char * const  Server_query[] = {
  "You need help ...\n",
  "The sources are ...\n",
  "The version is ...\n",
  NULL
}; /* Server_query */

char * const  Filter_names[] = {
  "aut-num",
  "domain",
  "inet6num",
  "inetnum",
  "inet-rtr",
  "key-cert",
  "limerick",
  "mntner",
  "route",
  "origin",
  "as-set",
  "route-set",   
  "members",
  NULL
}; /* Filter_names */

char * const *DF_get_filter_names(void) {
  return Filter_names;
} /* DF_get_filter_names() */

char * const *DF_get_class_names(void) {
  return Class_names;
} /* DF_get_class_names() */

char * const *DF_get_class_aliases(void) {
  return Class_aliases;
} /* DF_get_class_aliases() */

int DF_get_class_index(int alias_index) {
  return Class_aliases_map[alias_index];
} /* DF_get_class_index() */

char * const DF_get_class_name(int alias_index) {
  return Class_names[Class_aliases_map[alias_index]];
} /* DF_get_class_name() */

char * const DF_get_class_code(C_Type_t index) {
  if( index == -1 ) {
    return "*";
  }
  else {
    return Class_codes[index];
  }
} /* DF_get_class_code() */

int DF_get_class_dbase_code(int class_index) {
  return Class_dbase_code_map[class_index];
} /* DF_get_class_dbase_code() */

char * const *DF_get_sources(void) {
  return Sources_vector;
} /* DF_get_sources() */

const char *DF_get_source(int index) {
const char *s = Sources[index].src;

 return (*s == 0) 
   ? NULL 
   : s; 
 
} /* DF_get_source() */

const char *DF_get_database(int index) {
const char *s = Sources[index].db;

 return (*s == 0) 
   ? NULL 
   : s; 
 
} /* DF_get_database() */


char * const *DF_get_attribute_aliases(void) {
  return Attribute_aliases;
} /* DF_get_attribute_aliases() */

const char *DF_get_attribute_name(A_Type_t index) {
  return Attribute_names[index];
} /* DF_get_attribute_name() */

const char *DF_get_attribute_code(A_Type_t index) {
  return Attribute_codes[index];
} /* DF_get_attribute_code() */

char * const *DF_get_attribute_names(void) {
  return Attribute_names;
} /* DF_get_attribute_names() */

int DF_get_attribute_index(int alias_index) {
  return Attribute_aliases_map[alias_index];
} /* DF_get_attribute_index() */

const char *DF_get_class_template(C_Type_t index) {
  return Templates[index];
} /* DF_get_class_template() */

const char *DF_get_class_template_v(C_Type_t index) {
  return Templates_v[index];
} /* DF_get_class_template_v() */

const char *DF_get_server_query(int index) {
  return Server_query[index];
} /* DF_get_server_query() */

char * const *DF_get_server_queries(void) {
  return Server_queries;
} /* DF_get_server_queries() */

const char *DF_get_attribute_desc(A_Type_t index) {
/*
  return (char *)Attributes_details[attr_index][0];
*/
  return NULL;
} /* DF_get_attribute_desc() */

const char *DF_get_attribute_frmt(A_Type_t index) {
/*
  return (char *)Attributes_details[attr_index][1];
*/
  return NULL;
} /* DF_get_attribute_frmt() */

/* source_foreach() */
/*++++++++++++++++++++++++++++++++++++++
  Function to adds the source string to the created string from the Glist of sources.
  It is called via g_list_foreach().

  void *element_data The source name.

  void *result_buf_ptr The string to be populated.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
static void source_foreach(void *element_data, void *result_buf_ptr) {
  char *source = element_data;
  char *result_buf = (char *)result_buf_ptr;

  strcat(result_buf, source);
  strcat(result_buf, ",");

} /* source_foreach() */

/* DF_sources_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Creates a string from Sources.

  char * DF_sources_to_string Returns a string of the Sources.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char * DF_sources_to_string(void) {
  char *result=NULL;
  char result_buf[STR_XL];
  int result_len;
  int i;

  strcpy(result_buf, "{");
  for (i=0; Sources[i].src[0] != 0 ; i++) {
    strcat(result_buf, Sources[i].src);
    strcat(result_buf, ",");
  }
  result_len = strlen(result_buf);
  result_buf[result_len-1] = '}';
  result_buf[result_len] = '\0';
  
  //  result = (char *)calloc(1, result_len+1);
  dieif( wr_malloc((void **)&result, result_len+1) != UT_OK);  
  strcpy(result, result_buf);

  return result;

} /* DF_sources_to_string() */

/* DF_sources_list_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Creates a string from the sources in the GList.

  GList *sources_list  The GList of sources.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char *DF_sources_list_to_string(GList *sources_list) {
  char *result=NULL;
  char result_buf[STR_XL];
  int result_len;

  strcpy(result_buf, "{");
  g_list_foreach(sources_list, source_foreach, &result_buf);
  result_len = strlen(result_buf);
  if (result_len == 1) {
    /* If an empty set */
    result_buf[1] = '}';
    result_buf[2] = '\0';
  }
  else {
    result_buf[result_len-1] = '}';
    result_buf[result_len] = '\0';
  }

  //result = (char *)calloc(1, result_len+1);
  dieif( wr_malloc((void **)&result, result_len+1) != UT_OK);  
  strcpy(result, result_buf);

  return result;

} /* DF_sources_list_to_string() */


/* DF_attributes_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Returns a string of all the attributes.  Only there for debugging and tracing purposes.

  int offset The offset (Ie short or long name).

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char *DF_attributes_to_string(void) {
  int i;
  char *str;
  char str_buffer[4096];
  int str_len;

  strcpy(str_buffer, "{\"");
  for (i=0; Attribute_names[i] != NULL; i++) {
    strcat(str_buffer, Attribute_names[i]);
    strcat(str_buffer, "\", \"");
  }
  str_len = strlen(str_buffer);
  str_buffer[str_len-3] = '}';
  str_buffer[str_len-2] = '\0';
  str_len--;

  //  str = (char *)calloc(1, str_len);
  dieif( wr_malloc((void **)&str, str_len ) != UT_OK);  
  strcpy(str, str_buffer);

  return str;

} /* DF_attributes_to_string() */

/* XXX This could be done MUCH more efficiently (with a hash) */
A_Type_t DF_attribute_code2type(const gchar *token) {
  A_Type_t result=-1;

  int i;
  for (i=0; Attribute_aliases[i] != NULL; i++) {
    if (strcmp(Attribute_aliases[i], token) == 0) {
      result = Attribute_aliases_map[i];
      break;
    }
  }

  return result;
} /* DF_attribute_code2type() */

/* XXX This could be done MUCH more efficiently (with a hash) */
A_Type_t DF_attribute_name2type(const gchar *token) {
  A_Type_t result=-1;

  int i;
  for (i=0; Attribute_aliases[i] != NULL; i++) {
    if (strcmp(Attribute_aliases[i], token) == 0) {
      result = Attribute_aliases_map[i];
      break;
    }
  }

  return result;
} /* DF_attribute_name2type() */

/* XXX This could be done MUCH more efficiently (with a hash) */
C_Type_t DF_class_code2type(const gchar *token) {
  C_Type_t result=-1;

  int i;
  for (i=0; Class_aliases[i] != NULL; i++) {
    if (strcmp(Class_aliases[i], token) == 0) {
      result = Class_aliases_map[i];
      break;
    }
  }

  return result;
} /* DF_class_code2type() */

/* XXX This could be done MUCH more efficiently (with a hash) */
C_Type_t DF_class_name2type(const gchar *token) {
  C_Type_t result=-1;

  int i;
  for (i=0; Class_aliases[i] != NULL; i++) {
    if (strcmp(Class_aliases[i], token) == 0) {
      result = Class_aliases_map[i];
      break;
    }
  }

  return result;
} /* DF_class_name2type() */

